/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.contract.ContractCreateTransactionBody;
import com.hedera.node.app.service.contract.impl.exec.ActionSidecarContentTracer;
import com.hedera.node.app.service.contract.impl.exec.FeatureFlags;
import com.hedera.node.app.service.contract.impl.exec.FrameRunner;
import com.hedera.node.app.service.contract.impl.exec.gas.CustomGasCharging;
import com.hedera.node.app.service.contract.impl.exec.gas.GasCharges;
import com.hedera.node.app.service.contract.impl.exec.processors.CustomMessageCallProcessor;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameBuilder;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.exec.utils.OpsDurationCounter;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmContext;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmTransaction;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmTransactionResult;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.infra.StorageAccessTracker;
import com.hedera.node.app.service.contract.impl.state.HederaEvmAccount;
import com.hedera.node.app.service.contract.impl.state.ProxyWorldUpdater;
import com.hedera.node.app.service.contract.impl.state.TxStorageUsage;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.ResourceExhaustedException;
import com.hedera.node.config.data.ContractsConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.code.CodeFactory;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.processor.ContractCreationProcessor;

public class TransactionProcessor {
    private final FrameBuilder frameBuilder;
    private final FrameRunner frameRunner;
    private final CustomGasCharging gasCharging;
    private final CustomMessageCallProcessor messageCall;
    private final ContractCreationProcessor contractCreation;
    private final FeatureFlags featureFlags;
    private final CodeFactory codeFactory;

    public TransactionProcessor(@NonNull FrameBuilder frameBuilder, @NonNull FrameRunner frameRunner, @NonNull CustomGasCharging gasCharging, @NonNull CustomMessageCallProcessor messageCall, @NonNull ContractCreationProcessor contractCreation, @NonNull FeatureFlags featureFlags, @NonNull CodeFactory codeFactory) {
        this.frameBuilder = Objects.requireNonNull(frameBuilder);
        this.frameRunner = Objects.requireNonNull(frameRunner);
        this.gasCharging = Objects.requireNonNull(gasCharging);
        this.messageCall = Objects.requireNonNull(messageCall);
        this.contractCreation = Objects.requireNonNull(contractCreation);
        this.featureFlags = Objects.requireNonNull(featureFlags);
        this.codeFactory = codeFactory;
    }

    public FeatureFlags featureFlags() {
        return this.featureFlags;
    }

    public HederaEvmTransactionResult processTransaction(@NonNull HederaEvmTransaction transaction, @NonNull HederaWorldUpdater updater, @NonNull HederaEvmContext context, @NonNull ActionSidecarContentTracer tracer, @NonNull Configuration config, @NonNull OpsDurationCounter opsDurationCounter) {
        InvolvedParties parties = this.computeInvolvedPartiesOrAbort(transaction, updater, config);
        return this.processTransactionWithParties(transaction, updater, context, tracer, config, opsDurationCounter, parties);
    }

    private HederaEvmTransactionResult processTransactionWithParties(@NonNull HederaEvmTransaction transaction, @NonNull HederaWorldUpdater updater, @NonNull HederaEvmContext context, @NonNull ActionSidecarContentTracer tracer, @NonNull Configuration config, @NonNull OpsDurationCounter opsDurationCounter, @NonNull InvolvedParties parties) {
        GasCharges gasCharges = this.gasCharging.chargeForGas(parties.sender(), parties.relayer(), context, updater, transaction);
        MessageFrame initialFrame = this.frameBuilder.buildInitialFrameWith(transaction, updater, context, config, opsDurationCounter, this.featureFlags, parties.sender().getAddress(), parties.receiverAddress(), gasCharges.intrinsicGas(), this.codeFactory);
        HederaEvmTransactionResult result = this.frameRunner.runToCompletion(transaction.gasLimit(), parties.senderId(), initialFrame, tracer, this.messageCall, this.contractCreation);
        this.gasCharging.maybeRefundGiven(transaction.unusedGas(result.gasUsed()), gasCharges.relayerAllowanceUsed(), parties.sender(), parties.relayer(), context, updater);
        initialFrame.getSelfDestructs().forEach(arg_0 -> ((HederaWorldUpdater)updater).deleteAccount(arg_0));
        return this.safeCommit(result, transaction, updater, context, FrameUtils.accessTrackerFor(initialFrame));
    }

    private InvolvedParties computeInvolvedPartiesOrAbort(@NonNull HederaEvmTransaction transaction, @NonNull HederaWorldUpdater updater, @NonNull Configuration config) {
        try {
            return this.computeInvolvedParties(transaction, updater, config);
        }
        catch (HandleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HandleException(ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        }
    }

    private HederaEvmTransactionResult safeCommit(@NonNull HederaEvmTransactionResult result, @NonNull HederaEvmTransaction transaction, @NonNull HederaWorldUpdater updater, @NonNull HederaEvmContext context, @Nullable StorageAccessTracker accessTracker) {
        try {
            TxStorageUsage txStorageUsage;
            updater.commit();
            if (result.isSuccess() && (txStorageUsage = ConversionUtils.txStorageUsageFrom((ProxyWorldUpdater)updater, accessTracker, true)) != null) {
                return result.withTxStorageUsage(txStorageUsage);
            }
            return result;
        }
        catch (ResourceExhaustedException e) {
            updater.revert();
            HederaEvmAccount sender = updater.getHederaAccount(transaction.senderId());
            return HederaEvmTransactionResult.resourceExhaustionFrom(Objects.requireNonNull(sender).hederaId(), transaction.gasLimit(), context.gasPrice(), e.getStatus());
        }
    }

    private InvolvedParties computeInvolvedParties(@NonNull HederaEvmTransaction transaction, @NonNull HederaWorldUpdater updater, @NonNull Configuration config) {
        InvolvedParties parties;
        HederaEvmAccount sender = updater.getHederaAccount(transaction.senderId());
        HandleException.validateTrue((sender != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
        HederaEvmAccount relayer = null;
        if (transaction.isEthereumTransaction()) {
            relayer = updater.getHederaAccount(Objects.requireNonNull(transaction.relayerId()));
            HandleException.validateTrue((relayer != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
        if (transaction.isCreate()) {
            Address to;
            ContractCreateTransactionBody op = Objects.requireNonNull(transaction.hapiCreation());
            if (transaction.isEthereumTransaction()) {
                to = Address.contractAddress((Address)sender.getAddress(), (long)sender.getNonce());
                updater.setupAliasedTopLevelCreate(ConversionUtils.sponsorCustomizedCreation(op, sender.toNativeAccount()), to);
            } else {
                to = updater.setupTopLevelCreate(op);
            }
            parties = new InvolvedParties(sender, relayer, to);
        } else {
            HederaEvmAccount to = updater.getHederaAccount(transaction.contractIdOrThrow());
            parties = this.contractNotRequired(to, config) ? this.partiesWhenContractNotRequired(to, sender, relayer, transaction, updater, config) : this.partiesWhenContractRequired(to, sender, relayer, transaction, updater, config);
        }
        if (transaction.isEthereumTransaction()) {
            HandleException.validateTrue((transaction.nonce() == parties.sender().getNonce() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.WRONG_NONCE);
        }
        return parties;
    }

    private boolean contractNotRequired(@Nullable HederaEvmAccount to, @NonNull Configuration config) {
        Long maybeGrandfatheredNumber = to == null || to.isTokenFacade() || to.isScheduleTxnFacade() ? null : to.hederaId().accountNumOrThrow();
        return this.featureFlags.isAllowCallsToNonContractAccountsEnabled((ContractsConfig)config.getConfigData(ContractsConfig.class), maybeGrandfatheredNumber);
    }

    private InvolvedParties partiesWhenContractRequired(@Nullable HederaEvmAccount to, @NonNull HederaEvmAccount sender, @Nullable HederaEvmAccount relayer, @NonNull HederaEvmTransaction transaction, @NonNull HederaWorldUpdater updater, @NonNull Configuration config) {
        InvolvedParties parties;
        if (this.maybeLazyCreate(transaction, to, config)) {
            HandleException.validateTrue((boolean)transaction.hasValue(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
            Bytes alias = transaction.contractIdOrThrow().evmAddressOrThrow();
            HandleException.validateTrue((boolean)ConversionUtils.isEvmAddress(alias), (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
            parties = new InvolvedParties(sender, relayer, ConversionUtils.pbjToBesuAddress(alias));
            updater.setupTopLevelLazyCreate(Objects.requireNonNull(parties.receiverAddress));
        } else {
            HandleException.validateTrue((to != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
            parties = new InvolvedParties(sender, relayer, Objects.requireNonNull(to).getAddress());
        }
        return parties;
    }

    private InvolvedParties partiesWhenContractNotRequired(@Nullable HederaEvmAccount to, @NonNull HederaEvmAccount sender, @Nullable HederaEvmAccount relayer, @NonNull HederaEvmTransaction transaction, @NonNull HederaWorldUpdater updater, @NonNull Configuration config) {
        InvolvedParties parties;
        if (this.maybeLazyCreate(transaction, to, config)) {
            Bytes alias = transaction.contractIdOrThrow().evmAddress();
            if (transaction.hasValue() && alias != null) {
                parties = new InvolvedParties(sender, relayer, ConversionUtils.pbjToBesuAddress(alias));
                updater.setupTopLevelLazyCreate(Objects.requireNonNull(parties.receiverAddress));
            } else {
                updater.setContractNotRequired();
                parties = new InvolvedParties(sender, relayer, ConversionUtils.contractIDToBesuAddress(updater.entityIdFactory(), transaction.contractIdOrThrow()));
            }
        } else {
            updater.setContractNotRequired();
            parties = new InvolvedParties(sender, relayer, to != null ? to.getAddress() : ConversionUtils.contractIDToBesuAddress(updater.entityIdFactory(), transaction.contractIdOrThrow()));
        }
        return parties;
    }

    private boolean maybeLazyCreate(@NonNull HederaEvmTransaction transaction, @Nullable HederaEvmAccount to, @NonNull Configuration config) {
        return to == null && transaction.isEthereumTransaction() && this.messageCall.isImplicitCreationEnabled();
    }

    private record InvolvedParties(@NonNull HederaEvmAccount sender, @Nullable HederaEvmAccount relayer, @NonNull Address receiverAddress) {
        @NonNull
        AccountID senderId() {
            return this.sender.hederaId();
        }
    }
}

