/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.account;

import java.util.Map;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.bigints.UInt256Value;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.Account;

public interface MutableAccount
extends Account {
    default public long incrementNonce() {
        long current = this.getNonce();
        this.setNonce(current + 1L);
        return current;
    }

    public void setNonce(long var1);

    default public Wei incrementBalance(Wei value) {
        Wei current = this.getBalance();
        this.setBalance((Wei)current.addExact((UInt256Value)value));
        return current;
    }

    default public Wei decrementBalance(Wei value) {
        Wei current = this.getBalance();
        if (current.compareTo((Bytes)value) < 0) {
            throw new IllegalStateException(String.format("Cannot remove %s wei from account, balance is only %s", value, current));
        }
        this.setBalance((Wei)current.subtract((UInt256Value)value));
        return current;
    }

    public void setBalance(Wei var1);

    public void setCode(Bytes var1);

    public void setStorageValue(UInt256 var1, UInt256 var2);

    public void clearStorage();

    public Map<UInt256, UInt256> getUpdatedStorage();

    public void becomeImmutable();
}

