/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.frame;

public interface ExceptionalHaltReason {
    public static final ExceptionalHaltReason NONE = DefaultExceptionalHaltReason.NONE;
    public static final ExceptionalHaltReason INSUFFICIENT_GAS = DefaultExceptionalHaltReason.INSUFFICIENT_GAS;
    public static final ExceptionalHaltReason INSUFFICIENT_STACK_ITEMS = DefaultExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS;
    public static final ExceptionalHaltReason INVALID_JUMP_DESTINATION = DefaultExceptionalHaltReason.INVALID_JUMP_DESTINATION;
    public static final ExceptionalHaltReason INVALID_OPERATION = DefaultExceptionalHaltReason.INVALID_OPERATION;
    public static final ExceptionalHaltReason INVALID_RETURN_DATA_BUFFER_ACCESS = DefaultExceptionalHaltReason.INVALID_RETURN_DATA_BUFFER_ACCESS;
    public static final ExceptionalHaltReason TOO_MANY_STACK_ITEMS = DefaultExceptionalHaltReason.TOO_MANY_STACK_ITEMS;
    public static final ExceptionalHaltReason ILLEGAL_STATE_CHANGE = DefaultExceptionalHaltReason.ILLEGAL_STATE_CHANGE;
    public static final ExceptionalHaltReason OUT_OF_BOUNDS = DefaultExceptionalHaltReason.OUT_OF_BOUNDS;
    public static final ExceptionalHaltReason CODE_TOO_LARGE = DefaultExceptionalHaltReason.CODE_TOO_LARGE;
    public static final ExceptionalHaltReason INVALID_CODE = DefaultExceptionalHaltReason.INVALID_CODE;
    public static final ExceptionalHaltReason PRECOMPILE_ERROR = DefaultExceptionalHaltReason.PRECOMPILE_ERROR;
    public static final ExceptionalHaltReason EOF_CREATE_VERSION_INCOMPATIBLE = DefaultExceptionalHaltReason.EOF_CREATE_VERSION_INCOMPATIBLE;
    public static final ExceptionalHaltReason NONEXISTENT_CONTAINER = DefaultExceptionalHaltReason.NONEXISTENT_CONTAINER;
    public static final ExceptionalHaltReason INVALID_CONTAINER = DefaultExceptionalHaltReason.INVALID_CONTAINER;
    public static final ExceptionalHaltReason DATA_TOO_SMALL = DefaultExceptionalHaltReason.DATA_TOO_SMALL;
    public static final ExceptionalHaltReason ADDRESS_OUT_OF_RANGE = DefaultExceptionalHaltReason.ADDRESS_OUT_OF_RANGE;

    public String name();

    public String getDescription();

    public static ExceptionalHaltReason newInvalidOperation(final long opcode) {
        return new ExceptionalHaltReason(){

            @Override
            public String name() {
                return INVALID_OPERATION.name();
            }

            @Override
            public String getDescription() {
                return "Invalid opcode: 0x%02x".formatted(opcode);
            }

            public String toString() {
                return this.name();
            }
        };
    }

    public static enum DefaultExceptionalHaltReason implements ExceptionalHaltReason
    {
        NONE(""),
        INSUFFICIENT_GAS("Out of gas"),
        INSUFFICIENT_STACK_ITEMS("Stack underflow"),
        INVALID_JUMP_DESTINATION("Bad jump destination"),
        INVALID_OPERATION("Bad instruction"),
        INVALID_RETURN_DATA_BUFFER_ACCESS("Out of bounds"),
        TOO_MANY_STACK_ITEMS("Out of stack"),
        ILLEGAL_STATE_CHANGE("Illegal state change"),
        OUT_OF_BOUNDS("Out of bounds"),
        CODE_TOO_LARGE("Code is too large"),
        INVALID_CODE("Code is invalid"),
        PRECOMPILE_ERROR("Precompile error"),
        INSUFFICIENT_CODE_SECTION_RETURN_DATA("The stack for a return "),
        EOF_CREATE_VERSION_INCOMPATIBLE("EOF Code is attempting to create EOF code of an earlier version"),
        NONEXISTENT_CONTAINER("Referenced subcontainer index does not exist"),
        INVALID_CONTAINER("Referenced subcontainer index is invalid"),
        DATA_TOO_SMALL("Insufficient AuxData provided to a truncated container"),
        ADDRESS_OUT_OF_RANGE("Address has more than 20 bytes and is out of range");

        final String description;

        private DefaultExceptionalHaltReason(String description) {
            this.description = description;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

