/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle;

import com.hedera.hapi.block.stream.BlockItem;
import com.hedera.hapi.block.stream.input.EventHeader;
import com.hedera.hapi.block.stream.input.ParentEventReference;
import com.hedera.hapi.block.stream.input.RoundHeader;
import com.hedera.hapi.block.stream.output.StateChange;
import com.hedera.hapi.block.stream.output.StateChanges;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.blockrecords.BlockInfo;
import com.hedera.hapi.node.transaction.ExchangeRateSet;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.blocks.BlockHashSigner;
import com.hedera.node.app.blocks.BlockStreamManager;
import com.hedera.node.app.blocks.impl.ImmediateStateChangeListener;
import com.hedera.node.app.blocks.impl.streaming.BlockBufferService;
import com.hedera.node.app.fees.ExchangeRateManager;
import com.hedera.node.app.hints.HintsService;
import com.hedera.node.app.hints.impl.ReadableHintsStoreImpl;
import com.hedera.node.app.hints.impl.WritableHintsStoreImpl;
import com.hedera.node.app.history.HistoryService;
import com.hedera.node.app.history.impl.WritableHistoryStoreImpl;
import com.hedera.node.app.ids.WritableEntityIdStore;
import com.hedera.node.app.info.CurrentPlatformStatus;
import com.hedera.node.app.records.BlockRecordManager;
import com.hedera.node.app.records.schemas.V0490BlockRecordSchema;
import com.hedera.node.app.roster.ActiveRosters;
import com.hedera.node.app.service.schedule.ExecutableTxn;
import com.hedera.node.app.service.schedule.ExecutableTxnIterator;
import com.hedera.node.app.service.schedule.ScheduleService;
import com.hedera.node.app.service.token.impl.WritableNetworkStakingRewardsStore;
import com.hedera.node.app.service.token.impl.WritableStakingInfoStore;
import com.hedera.node.app.service.token.impl.handlers.staking.StakeInfoHelper;
import com.hedera.node.app.service.token.impl.handlers.staking.StakePeriodManager;
import com.hedera.node.app.services.NodeRewardManager;
import com.hedera.node.app.spi.api.ServiceApiProvider;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.hedera.node.app.spi.ids.WritableEntityCounters;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.app.state.HederaRecordCache;
import com.hedera.node.app.state.SingleTransactionRecord;
import com.hedera.node.app.state.logging.TransactionStateLogger;
import com.hedera.node.app.state.recordcache.LegacyListRecordSource;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.hedera.node.app.store.StoreFactoryImpl;
import com.hedera.node.app.throttle.CongestionMetrics;
import com.hedera.node.app.throttle.ThrottleServiceManager;
import com.hedera.node.app.workflows.OpWorkflowMetrics;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.node.app.workflows.handle.Dispatch;
import com.hedera.node.app.workflows.handle.DispatchProcessor;
import com.hedera.node.app.workflows.handle.HandleOutput;
import com.hedera.node.app.workflows.handle.TransactionType;
import com.hedera.node.app.workflows.handle.cache.CacheWarmer;
import com.hedera.node.app.workflows.handle.record.SystemTransactions;
import com.hedera.node.app.workflows.handle.steps.HollowAccountCompletions;
import com.hedera.node.app.workflows.handle.steps.ParentTxn;
import com.hedera.node.app.workflows.handle.steps.ParentTxnFactory;
import com.hedera.node.app.workflows.handle.steps.StakePeriodChanges;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.BlockStreamConfig;
import com.hedera.node.config.data.ConsensusConfig;
import com.hedera.node.config.data.SchedulingConfig;
import com.hedera.node.config.data.TssConfig;
import com.hedera.node.config.types.StreamMode;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.service.ReadablePlatformStateStore;
import com.swirlds.platform.state.service.WritablePlatformStateStore;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.state.State;
import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.event.ConsensusEvent;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.model.transaction.ConsensusTransaction;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;
import org.hiero.consensus.roster.ReadableRosterStore;
import org.hiero.consensus.roster.ReadableRosterStoreImpl;
import org.hiero.consensus.roster.WritableRosterStore;

@Singleton
public class HandleWorkflow {
    private static final Logger logger = LogManager.getLogger(HandleWorkflow.class);
    public static final String ALERT_MESSAGE = "Possibly CATASTROPHIC failure";
    public static final String SYSTEM_ENTITIES_CREATED_MSG = "System entities created";
    private final StreamMode streamMode;
    private final NetworkInfo networkInfo;
    private final StakePeriodChanges stakePeriodChanges;
    private final DispatchProcessor dispatchProcessor;
    private final BlockRecordManager blockRecordManager;
    private final BlockStreamManager blockStreamManager;
    private final CacheWarmer cacheWarmer;
    private final OpWorkflowMetrics opWorkflowMetrics;
    private final ThrottleServiceManager throttleServiceManager;
    private final InitTrigger initTrigger;
    private final HollowAccountCompletions hollowAccountCompletions;
    private final SystemTransactions systemTransactions;
    private final StakeInfoHelper stakeInfoHelper;
    private final HederaRecordCache recordCache;
    private final ExchangeRateManager exchangeRateManager;
    private final StakePeriodManager stakePeriodManager;
    private final List<StateChanges.Builder> migrationStateChanges;
    private final ParentTxnFactory parentTxnFactory;
    private final HintsService hintsService;
    private final HistoryService historyService;
    private final ConfigProvider configProvider;
    private final ImmediateStateChangeListener immediateStateChangeListener;
    private final ScheduleService scheduleService;
    private final CongestionMetrics congestionMetrics;
    private final CurrentPlatformStatus currentPlatformStatus;
    private final BlockHashSigner blockHashSigner;
    private final BlockBufferService blockBufferService;
    private final Map<Class<?>, ServiceApiProvider<?>> apiProviders;
    @Nullable
    private final AtomicBoolean systemEntitiesCreatedFlag;
    private long lastMetricUpdateSecond;
    private long lastExecutedSecond;
    private final NodeRewardManager nodeRewardManager;
    private final PlatformStateFacade platformStateFacade;
    private boolean checkedForTransplant;
    private boolean systemAccountCleanupDone;

    @Inject
    public HandleWorkflow(@NonNull NetworkInfo networkInfo, @NonNull StakePeriodChanges stakePeriodChanges, @NonNull DispatchProcessor dispatchProcessor, @NonNull ConfigProvider configProvider, @NonNull BlockRecordManager blockRecordManager, @NonNull BlockStreamManager blockStreamManager, @NonNull CacheWarmer cacheWarmer, @NonNull OpWorkflowMetrics opWorkflowMetrics, @NonNull ThrottleServiceManager throttleServiceManager, @NonNull InitTrigger initTrigger, @NonNull HollowAccountCompletions hollowAccountCompletions, @NonNull SystemTransactions systemTransactions, @NonNull StakeInfoHelper stakeInfoHelper, @NonNull HederaRecordCache recordCache, @NonNull ExchangeRateManager exchangeRateManager, @NonNull StakePeriodManager stakePeriodManager, @NonNull List<StateChanges.Builder> migrationStateChanges, @NonNull ParentTxnFactory parentTxnFactory, @NonNull ImmediateStateChangeListener immediateStateChangeListener, @NonNull ScheduleService scheduleService, @NonNull HintsService hintsService, @NonNull HistoryService historyService, @NonNull CongestionMetrics congestionMetrics, @NonNull CurrentPlatformStatus currentPlatformStatus, @NonNull BlockHashSigner blockHashSigner, @Nullable AtomicBoolean systemEntitiesCreatedFlag, @NonNull NodeRewardManager nodeRewardManager, @NonNull PlatformStateFacade platformStateFacade, @NonNull BlockBufferService blockBufferService, @NonNull Map<Class<?>, ServiceApiProvider<?>> apiProviders) {
        this.networkInfo = Objects.requireNonNull(networkInfo);
        this.stakePeriodChanges = Objects.requireNonNull(stakePeriodChanges);
        this.dispatchProcessor = Objects.requireNonNull(dispatchProcessor);
        this.blockRecordManager = Objects.requireNonNull(blockRecordManager);
        this.blockStreamManager = Objects.requireNonNull(blockStreamManager);
        this.cacheWarmer = Objects.requireNonNull(cacheWarmer);
        this.opWorkflowMetrics = Objects.requireNonNull(opWorkflowMetrics);
        this.throttleServiceManager = Objects.requireNonNull(throttleServiceManager);
        this.initTrigger = Objects.requireNonNull(initTrigger);
        this.hollowAccountCompletions = Objects.requireNonNull(hollowAccountCompletions);
        this.systemTransactions = Objects.requireNonNull(systemTransactions);
        this.stakeInfoHelper = Objects.requireNonNull(stakeInfoHelper);
        this.recordCache = Objects.requireNonNull(recordCache);
        this.exchangeRateManager = Objects.requireNonNull(exchangeRateManager);
        this.stakePeriodManager = Objects.requireNonNull(stakePeriodManager);
        this.migrationStateChanges = new ArrayList<StateChanges.Builder>(migrationStateChanges);
        this.parentTxnFactory = Objects.requireNonNull(parentTxnFactory);
        this.configProvider = Objects.requireNonNull(configProvider);
        this.immediateStateChangeListener = Objects.requireNonNull(immediateStateChangeListener);
        this.scheduleService = Objects.requireNonNull(scheduleService);
        this.congestionMetrics = Objects.requireNonNull(congestionMetrics);
        this.streamMode = ((BlockStreamConfig)configProvider.getConfiguration().getConfigData(BlockStreamConfig.class)).streamMode();
        this.hintsService = Objects.requireNonNull(hintsService);
        this.historyService = Objects.requireNonNull(historyService);
        this.blockHashSigner = Objects.requireNonNull(blockHashSigner);
        this.currentPlatformStatus = Objects.requireNonNull(currentPlatformStatus);
        this.nodeRewardManager = Objects.requireNonNull(nodeRewardManager);
        this.systemEntitiesCreatedFlag = systemEntitiesCreatedFlag;
        this.platformStateFacade = Objects.requireNonNull(platformStateFacade);
        this.blockBufferService = Objects.requireNonNull(blockBufferService);
        this.apiProviders = Objects.requireNonNull(apiProviders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRound(@NonNull State state, @NonNull Round round, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTxnCallback) {
        TransactionStateLogger.logStartRound(round);
        this.blockBufferService.ensureNewBlocksPermitted();
        this.cacheWarmer.warm(state, round);
        if (this.streamMode != StreamMode.RECORDS) {
            this.blockStreamManager.startRound(round, state);
            this.blockStreamManager.writeItem(BlockItem.newBuilder().roundHeader(new RoundHeader(round.getRoundNum())).build());
            if (!this.migrationStateChanges.isEmpty()) {
                Instant startupConsTime = this.systemTransactions.firstReservedSystemTimeFor(((ConsensusEvent)round.iterator().next()).getConsensusTimestamp());
                this.migrationStateChanges.forEach(builder -> this.blockStreamManager.writeItem(BlockItem.newBuilder().stateChanges(builder.consensusTimestamp(HapiUtils.asTimestamp((Instant)startupConsTime)).build()).build()));
                this.migrationStateChanges.clear();
            }
        }
        this.systemTransactions.resetNextDispatchNonce();
        this.recordCache.resetRoundReceipts();
        boolean transactionsDispatched = false;
        if (this.migrationStateChanges.isEmpty() && !this.checkedForTransplant) {
            boolean dispatchedTransplantUpdates = false;
            try {
                Instant now = this.streamMode == StreamMode.RECORDS ? round.getConsensusTimestamp() : ((ConsensusEvent)round.iterator().next()).getConsensusTimestamp();
                dispatchedTransplantUpdates = this.systemTransactions.dispatchTransplantUpdates(state, now, round.getRoundNum());
                transactionsDispatched |= dispatchedTransplantUpdates;
            }
            catch (Exception e) {
                logger.error("Failed to dispatch transplant updates", (Throwable)e);
            }
            finally {
                this.checkedForTransplant = true;
                if (dispatchedTransplantUpdates) {
                    WritableStates writableStates = state.getWritableStates("RosterService");
                    WritableRosterStore writableRosterStore = new WritableRosterStore(writableStates);
                    writableRosterStore.updateTransplantInProgress(false);
                    ((CommittableWritableStates)writableStates).commit();
                    logger.info("Transplant in progress is set to false in the roster store");
                }
            }
        }
        if (this.streamMode != StreamMode.RECORDS) {
            this.configureTssCallbacks(state);
            try {
                this.reconcileTssState(state, round.getConsensusTimestamp());
            }
            catch (Exception e) {
                logger.error("{} trying to reconcile TSS state", (Object)ALERT_MESSAGE, (Object)e);
            }
        }
        try {
            int receiptEntriesBatchSize = ((BlockStreamConfig)this.configProvider.getConfiguration().getConfigData(BlockStreamConfig.class)).receiptEntriesBatchSize();
            transactionsDispatched |= this.handleEvents(state, round, receiptEntriesBatchSize, stateSignatureTxnCallback);
            try {
                Instant lastConsTime;
                Instant instant = lastConsTime = this.streamMode == StreamMode.RECORDS ? this.blockRecordManager.lastUsedConsensusTime() : this.blockStreamManager.lastUsedConsensusTime();
                if (lastConsTime.isAfter(Instant.EPOCH)) {
                    transactionsDispatched |= this.nodeRewardManager.maybeRewardActiveNodes(state, lastConsTime.plusNanos(1L), this.systemTransactions);
                }
            }
            catch (Exception e) {
                logger.warn("Failed to reward active nodes", (Throwable)e);
            }
            if (transactionsDispatched && this.streamMode != StreamMode.BLOCKS) {
                this.blockRecordManager.endRound(state);
            }
            if (this.platformStateFacade.isFreezeRound(state, round)) {
                WritablePlatformStateStore platformStateStore = new WritablePlatformStateStore(state.getWritableStates("PlatformStateService"));
                platformStateStore.setLatestFreezeRound(round.getRoundNum());
            }
        }
        finally {
            this.recordCache.commitReceipts(state, round.getConsensusTimestamp(), this.immediateStateChangeListener, this.blockStreamManager, this.streamMode);
        }
    }

    private boolean handleEvents(@NonNull State state, @NonNull Round round, int receiptEntriesBatchSize, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTxnCallback) {
        boolean isGenesis;
        boolean transactionsDispatched = false;
        ReadableStoreFactory storeFactory = new ReadableStoreFactory(state);
        ReadablePlatformStateStore platformStateStore = storeFactory.getStore(ReadablePlatformStateStore.class);
        for (ConsensusEvent event : round) {
            NodeInfo creator;
            if (this.streamMode != StreamMode.RECORDS) {
                this.writeEventHeader(event);
            }
            if ((creator = this.networkInfo.nodeInfo(event.getCreatorId().id())) == null) {
                if (event.getEventCore().birthRound() <= platformStateStore.getLatestFreezeRound()) continue;
                logger.warn("Received event with birth round {}, last freeze round is {}, from node {} which is not in the address book", (Object)event.getEventCore().birthRound(), (Object)platformStateStore.getLatestFreezeRound(), (Object)event.getCreatorId());
                continue;
            }
            Consumer<StateSignatureTransaction> simplifiedStateSignatureTxnCallback = txn -> {
                ScopedSystemTransaction scopedTxn = new ScopedSystemTransaction(event.getCreatorId(), event.getBirthRound(), txn);
                stateSignatureTxnCallback.accept(scopedTxn);
            };
            TransactionStateLogger.logStartEvent(event, creator);
            Iterator it = event.consensusTransactionIterator();
            while (it.hasNext()) {
                ConsensusTransaction platformTxn = (ConsensusTransaction)it.next();
                try {
                    transactionsDispatched |= this.handlePlatformTransaction(state, creator, platformTxn, event.getEventCore().birthRound(), simplifiedStateSignatureTxnCallback);
                }
                catch (Exception e) {
                    logger.fatal("Possibly CATASTROPHIC failure while running the handle workflow. While this node may not die right away, it is in a bad way, most likely fatally.", (Throwable)e);
                }
            }
            this.recordCache.maybeCommitReceiptsBatch(state, round.getConsensusTimestamp(), this.immediateStateChangeListener, receiptEntriesBatchSize, this.blockStreamManager, this.streamMode);
        }
        switch (this.streamMode) {
            default: {
                throw new MatchException(null, null);
            }
            case RECORDS: {
                boolean bl = this.blockRecordManager.consTimeOfLastHandledTxn().equals(Instant.EPOCH);
                break;
            }
            case BLOCKS: 
            case BOTH: {
                boolean bl = isGenesis = this.blockStreamManager.pendingWork() == BlockStreamManager.PendingWork.GENESIS_WORK;
            }
        }
        if (isGenesis) {
            Instant genesisEventTime = ((ConsensusEvent)round.iterator().next()).getConsensusTimestamp();
            logger.info("Doing genesis setup before {}", (Object)genesisEventTime);
            this.systemTransactions.doGenesisSetup(genesisEventTime, state);
            transactionsDispatched = true;
            if (this.streamMode != StreamMode.RECORDS) {
                this.blockStreamManager.confirmPendingWorkFinished();
            }
            logger.info(SYSTEM_ENTITIES_CREATED_MSG);
            Objects.requireNonNull(this.systemEntitiesCreatedFlag).set(true);
        }
        this.throttleServiceManager.updateAllMetrics();
        return transactionsDispatched;
    }

    private void writeEventHeader(ConsensusEvent event) {
        this.blockStreamManager.trackEventHash(event.getHash());
        ArrayList<ParentEventReference> parents = new ArrayList<ParentEventReference>();
        Iterator iterator = event.allParentsIterator();
        while (iterator.hasNext()) {
            EventDescriptorWrapper parent = (EventDescriptorWrapper)iterator.next();
            Optional<Integer> parentHash = this.blockStreamManager.getEventIndex(parent.hash());
            if (parentHash.isEmpty()) {
                parents.add(ParentEventReference.newBuilder().eventDescriptor(parent.eventDescriptor()).build());
                continue;
            }
            parents.add(ParentEventReference.newBuilder().index(parentHash.get().intValue()).build());
        }
        BlockItem headerItem = BlockItem.newBuilder().eventHeader(new EventHeader(event.getEventCore(), parents)).build();
        this.blockStreamManager.writeItem(headerItem);
    }

    private boolean handlePlatformTransaction(@NonNull State state, @NonNull NodeInfo creator, @NonNull ConsensusTransaction txn, long eventBirthRound, @NonNull Consumer<StateSignatureTransaction> stateSignatureTxnCallback) {
        Instant executionStart;
        long handleStart = System.nanoTime();
        Instant consensusNow = txn.getConsensusTimestamp();
        TransactionType type = TransactionType.ORDINARY_TRANSACTION;
        this.stakePeriodManager.setCurrentStakePeriodFor(consensusNow);
        boolean startsNewRecordFile = false;
        if (this.streamMode != StreamMode.BLOCKS) {
            startsNewRecordFile = this.blockRecordManager.willOpenNewBlock(consensusNow, state);
            if (this.streamMode == StreamMode.RECORDS && startsNewRecordFile) {
                type = this.typeOfBoundary(state);
            }
        }
        if (this.streamMode != StreamMode.RECORDS) {
            switch (this.blockStreamManager.pendingWork()) {
                case POST_UPGRADE_WORK: {
                    TransactionType transactionType = TransactionType.POST_UPGRADE_TRANSACTION;
                    break;
                }
                default: {
                    TransactionType transactionType = type = TransactionType.ORDINARY_TRANSACTION;
                }
            }
        }
        if (type == TransactionType.POST_UPGRADE_TRANSACTION) {
            logger.info("Doing post-upgrade setup @ {}", (Object)consensusNow);
            this.systemTransactions.doPostUpgradeSetup(consensusNow, state);
            if (this.streamMode != StreamMode.RECORDS) {
                this.blockStreamManager.confirmPendingWorkFinished();
            }
            WritableStates writableTokenStates = state.getWritableStates("TokenService");
            WritableStates writableEntityIdStates = state.getWritableStates("EntityIdService");
            this.doStreamingKVChanges(writableTokenStates, writableEntityIdStates, () -> this.stakeInfoHelper.adjustPostUpgradeStakes(this.networkInfo, (Configuration)this.configProvider.getConfiguration(), new WritableStakingInfoStore(writableTokenStates, (WritableEntityCounters)new WritableEntityIdStore(writableEntityIdStates)), new WritableNetworkStakingRewardsStore(writableTokenStates)));
            if (this.streamMode == StreamMode.RECORDS) {
                this.blockRecordManager.markMigrationRecordsStreamed();
            }
        } else if (!this.systemAccountCleanupDone) {
            this.systemAccountCleanupDone = this.systemTransactions.do066SystemAccountCleanup(consensusNow, state);
        }
        ParentTxn userTxn = this.parentTxnFactory.createUserTxn(state, creator, txn, consensusNow, stateSignatureTxnCallback);
        if (userTxn == null) {
            return false;
        }
        if (this.streamMode != StreamMode.BLOCKS && startsNewRecordFile) {
            this.blockRecordManager.startUserTransaction(consensusNow, state);
        }
        HandleOutput handleOutput = this.executeSubmittedParent(userTxn, eventBirthRound, state);
        if (this.streamMode != StreamMode.BLOCKS) {
            List<SingleTransactionRecord> records = ((LegacyListRecordSource)handleOutput.recordSourceOrThrow()).precomputedRecords();
            this.blockRecordManager.endUserTransaction(records.stream(), state);
        }
        if (this.streamMode != StreamMode.RECORDS) {
            handleOutput.blockRecordSourceOrThrow().forEachItem(this.blockStreamManager::writeItem);
        } else if (handleOutput.lastAssignedConsensusTime().isAfter(consensusNow)) {
            this.blockRecordManager.setLastUsedConsensusTime(handleOutput.lastAssignedConsensusTime(), state);
        }
        this.opWorkflowMetrics.updateDuration(userTxn.functionality(), (int)(System.nanoTime() - handleStart));
        this.congestionMetrics.updateMultiplier(userTxn.txnInfo(), userTxn.readableStoreFactory());
        Instant instant = executionStart = this.streamMode == StreamMode.RECORDS ? this.blockRecordManager.lastIntervalProcessTime() : this.blockStreamManager.lastIntervalProcessTime();
        if (executionStart.equals(Instant.EPOCH)) {
            executionStart = userTxn.consensusNow();
        }
        try {
            this.executeAsManyScheduled(state, executionStart, userTxn.consensusNow(), userTxn.creatorInfo());
        }
        catch (Exception e) {
            logger.error("{} - unhandled exception while executing schedules between [{}, {}]", (Object)ALERT_MESSAGE, (Object)executionStart, (Object)userTxn.consensusNow(), (Object)e);
            if (this.streamMode != StreamMode.RECORDS) {
                this.blockStreamManager.setLastIntervalProcessTime(userTxn.consensusNow());
            }
            this.blockRecordManager.setLastIntervalProcessTime(userTxn.consensusNow(), state);
        }
        return true;
    }

    private void executeAsManyScheduled(@NonNull State state, @NonNull Instant executionStart, @NonNull Instant consensusNow, @NonNull NodeInfo creatorInfo) {
        Instant executionEnd = consensusNow;
        if (executionEnd.getEpochSecond() > this.lastExecutedSecond) {
            VersionedConfiguration config = this.configProvider.getConfiguration();
            SchedulingConfig schedulingConfig = (SchedulingConfig)config.getConfigData(SchedulingConfig.class);
            ConsensusConfig consensusConfig = (ConsensusConfig)config.getConfigData(ConsensusConfig.class);
            Instant lastUsableTime = consensusNow.plusNanos(schedulingConfig.consTimeSeparationNanos() - schedulingConfig.reservedSystemTxnNanos() - (consensusConfig.handleMaxFollowingRecords() + consensusConfig.handleMaxPrecedingRecords() + 1));
            Instant lastTime = this.streamMode == StreamMode.RECORDS ? this.blockRecordManager.lastUsedConsensusTime() : this.blockStreamManager.lastUsedConsensusTime();
            Instant nextTime = lastTime.plusNanos(consensusConfig.handleMaxPrecedingRecords() + 1);
            WritableStates entityIdWritableStates = state.getWritableStates("EntityIdService");
            WritableEntityIdStore writableEntityIdStore = new WritableEntityIdStore(entityIdWritableStates);
            int maxSecsToCheck = schedulingConfig.maxExpirySecsToCheckPerUserTxn();
            long lastCheckableSecond = executionStart.getEpochSecond() + (long)maxSecsToCheck - 1L;
            Instant iteratorEnd = lastCheckableSecond >= consensusNow.getEpochSecond() ? consensusNow : executionStart.plusSeconds(maxSecsToCheck);
            ExecutableTxnIterator iter = this.scheduleService.executableTxns(executionStart, iteratorEnd, StoreFactoryImpl.from(state, "ScheduleService", (Configuration)config, writableEntityIdStore, this.apiProviders));
            WritableStates writableStates = state.getWritableStates("ScheduleService");
            for (int n = schedulingConfig.maxExecutionsPerUserTxn(); iter.hasNext() && !nextTime.isAfter(lastUsableTime) && n > 0; --n) {
                ExecutableTxn executableTxn = (ExecutableTxn)iter.next();
                if (schedulingConfig.longTermEnabled()) {
                    this.stakePeriodManager.setCurrentStakePeriodFor(nextTime);
                    if (this.streamMode != StreamMode.BLOCKS) {
                        this.blockRecordManager.startUserTransaction(nextTime, state);
                    }
                    HandleOutput handleOutput = this.executeScheduled(state, nextTime, creatorInfo, (ExecutableTxn<? extends StreamBuilder>)executableTxn);
                    if (this.streamMode != StreamMode.RECORDS) {
                        handleOutput.blockRecordSourceOrThrow().forEachItem(this.blockStreamManager::writeItem);
                    } else if (handleOutput.lastAssignedConsensusTime().isAfter(consensusNow)) {
                        this.blockRecordManager.setLastUsedConsensusTime(handleOutput.lastAssignedConsensusTime(), state);
                    }
                    if (this.streamMode != StreamMode.BLOCKS) {
                        List<SingleTransactionRecord> records = ((LegacyListRecordSource)handleOutput.recordSourceOrThrow()).precomputedRecords();
                        this.blockRecordManager.endUserTransaction(records.stream(), state);
                    }
                }
                executionEnd = executableTxn.nbf();
                this.doStreamingKVChanges(writableStates, entityIdWritableStates, () -> iter.remove());
                lastTime = this.streamMode == StreamMode.RECORDS ? this.blockRecordManager.lastUsedConsensusTime() : this.blockStreamManager.lastUsedConsensusTime();
                nextTime = lastTime.plusNanos(consensusConfig.handleMaxPrecedingRecords() + 1);
            }
            this.doStreamingKVChanges(writableStates, entityIdWritableStates, () -> ((ExecutableTxnIterator)iter).purgeUntilNext());
            if (iter.hasNext()) {
                this.lastExecutedSecond = executionEnd.getEpochSecond() - 1L;
            } else {
                executionEnd = iteratorEnd;
                this.lastExecutedSecond = executionEnd.getEpochSecond();
            }
        }
        if (this.streamMode != StreamMode.RECORDS) {
            this.blockStreamManager.setLastIntervalProcessTime(executionEnd);
        } else {
            this.blockRecordManager.setLastIntervalProcessTime(executionEnd, state);
        }
    }

    private <T extends StreamBuilder> T baseBuilderFor(@NonNull ExecutableTxn<T> executableTxn, @NonNull ParentTxn parentTxn) {
        return parentTxn.initBaseBuilder(this.exchangeRateManager.exchangeRates(), executableTxn.builderType(), executableTxn.builderSpec());
    }

    private HandleOutput executeSubmittedParent(@NonNull ParentTxn parentTxn, long eventBirthRound, @NonNull State state) {
        try {
            ReadablePlatformStateStore platformStateStore = new ReadablePlatformStateStore(state.getReadableStates("PlatformStateService"));
            if (this.initTrigger != InitTrigger.EVENT_STREAM_RECOVERY && eventBirthRound <= platformStateStore.getLatestFreezeRound()) {
                if (this.streamMode != StreamMode.RECORDS) {
                    this.blockStreamManager.setLastTopLevelTime(parentTxn.consensusNow());
                }
                if (this.streamMode != StreamMode.BLOCKS) {
                    this.blockRecordManager.setLastTopLevelTime(parentTxn.consensusNow(), parentTxn.state());
                }
                HandleWorkflow.initializeBuilderInfo(parentTxn.baseBuilder(), parentTxn.txnInfo(), this.exchangeRateManager.exchangeRates()).status(ResponseCodeEnum.BUSY);
                parentTxn.stack().commitTransaction(parentTxn.baseBuilder());
            } else {
                Dispatch dispatch = this.parentTxnFactory.createDispatch(parentTxn, this.exchangeRateManager.exchangeRates());
                this.stakePeriodChanges.advanceTimeTo(parentTxn, true);
                HandleWorkflow.logPreDispatch(parentTxn);
                this.hollowAccountCompletions.completeHollowAccounts(parentTxn, dispatch);
                this.dispatchProcessor.processDispatch(dispatch);
                this.updateWorkflowMetrics(parentTxn);
            }
            HandleOutput handleOutput = parentTxn.stack().buildHandleOutput(parentTxn.consensusNow(), this.exchangeRateManager.exchangeRates());
            this.recordCache.addRecordSource(parentTxn.creatorInfo().nodeId(), parentTxn.txnInfo().transactionID(), parentTxn.preHandleResult().dueDiligenceFailure(), handleOutput.preferringBlockRecordSource());
            return handleOutput;
        }
        catch (Exception e) {
            logger.error("{} - exception thrown while handling user transaction", (Object)ALERT_MESSAGE, (Object)e);
            return HandleOutput.failInvalidStreamItems(parentTxn, this.exchangeRateManager.exchangeRates(), this.streamMode, this.recordCache);
        }
    }

    private HandleOutput executeScheduled(@NonNull State state, @NonNull Instant consensusNow, @NonNull NodeInfo creatorInfo, @NonNull ExecutableTxn<? extends StreamBuilder> executableTxn) {
        ParentTxn scheduledTxn = this.parentTxnFactory.createSystemTxn(state, creatorInfo, consensusNow, TransactionType.ORDINARY_TRANSACTION, executableTxn.payerId(), executableTxn.body());
        StreamBuilder baseBuilder = this.baseBuilderFor(executableTxn, scheduledTxn);
        Dispatch dispatch = this.parentTxnFactory.createDispatch(scheduledTxn, baseBuilder, executableTxn.keyVerifier(), HandleContext.TransactionCategory.SCHEDULED);
        this.stakePeriodChanges.advanceTimeTo(scheduledTxn, true);
        try {
            this.dispatchProcessor.processDispatch(dispatch);
            HandleOutput handleOutput = scheduledTxn.stack().buildHandleOutput(scheduledTxn.consensusNow(), this.exchangeRateManager.exchangeRates());
            this.recordCache.addRecordSource(scheduledTxn.creatorInfo().nodeId(), scheduledTxn.txnInfo().transactionID(), HederaRecordCache.DueDiligenceFailure.NO, handleOutput.preferringBlockRecordSource());
            return handleOutput;
        }
        catch (Exception e) {
            logger.error("{} - exception thrown while handling scheduled transaction", (Object)ALERT_MESSAGE, (Object)e);
            return HandleOutput.failInvalidStreamItems(scheduledTxn, this.exchangeRateManager.exchangeRates(), this.streamMode, this.recordCache);
        }
    }

    private void doStreamingKVChanges(@NonNull WritableStates writableStates, @Nullable WritableStates entityIdWritableStates, @NonNull Runnable action) {
        List<StateChange> changes;
        if (this.streamMode != StreamMode.RECORDS) {
            this.immediateStateChangeListener.resetKvStateChanges(null);
        }
        action.run();
        ((CommittableWritableStates)writableStates).commit();
        if (entityIdWritableStates != null) {
            ((CommittableWritableStates)entityIdWritableStates).commit();
        }
        if (this.streamMode != StreamMode.RECORDS && !(changes = this.immediateStateChangeListener.getKvStateChanges()).isEmpty()) {
            this.blockStreamManager.writeItem(now -> BlockItem.newBuilder().stateChanges(new StateChanges(now, new ArrayList(changes))).build());
        }
    }

    private void updateWorkflowMetrics(@NonNull ParentTxn parentTxn) {
        if (parentTxn.consensusNow().getEpochSecond() > this.lastMetricUpdateSecond) {
            this.opWorkflowMetrics.switchConsensusSecond();
            this.lastMetricUpdateSecond = parentTxn.consensusNow().getEpochSecond();
        }
    }

    public static StreamBuilder initializeBuilderInfo(@NonNull StreamBuilder builder, @NonNull TransactionInfo txnInfo, @NonNull ExchangeRateSet exchangeRateSet) {
        return builder.signedTx(txnInfo.signedTx()).functionality(txnInfo.functionality()).serializedSignedTx(txnInfo.serializedSignedTx()).transactionID(txnInfo.txBody().transactionIDOrThrow()).exchangeRate(exchangeRateSet).memo(txnInfo.txBody().memo());
    }

    private void configureTssCallbacks(@NonNull State state) {
        TssConfig tssConfig = (TssConfig)this.configProvider.getConfiguration().getConfigData(TssConfig.class);
        if (tssConfig.hintsEnabled()) {
            this.hintsService.onFinishedConstruction((hintsStore, construction, context) -> {
                ReadableRosterStoreImpl rosterStore;
                if (hintsStore.getActiveConstruction().constructionId() == construction.constructionId()) {
                    context.setConstruction(construction);
                } else if (!tssConfig.historyEnabled() && (rosterStore = new ReadableRosterStoreImpl(state.getReadableStates("RosterService"))).candidateIsWeightRotation()) {
                    this.hintsService.manageRosterAdoption(hintsStore, Objects.requireNonNull(rosterStore.getActiveRoster()), Objects.requireNonNull(rosterStore.getCandidateRoster()), Objects.requireNonNull(rosterStore.getCandidateRosterHash()), tssConfig.forceHandoffs());
                }
            });
        }
        if (tssConfig.historyEnabled()) {
            this.historyService.onFinishedConstruction((historyStore, construction) -> {
                if (historyStore.getActiveConstruction().constructionId() == construction.constructionId()) {
                    return;
                }
                ReadableRosterStoreImpl rosterStore = new ReadableRosterStoreImpl(state.getReadableStates("RosterService"));
                if (rosterStore.candidateIsWeightRotation()) {
                    historyStore.handoff(Objects.requireNonNull(rosterStore.getActiveRoster()), Objects.requireNonNull(rosterStore.getCandidateRoster()), Objects.requireNonNull(rosterStore.getCandidateRosterHash()));
                    if (tssConfig.hintsEnabled()) {
                        WritableStates writableHintsStates = state.getWritableStates("HintsService");
                        WritableStates writableEntityStates = state.getWritableStates("EntityIdService");
                        WritableEntityIdStore entityCounters = new WritableEntityIdStore(writableEntityStates);
                        WritableHintsStoreImpl hintsStore = new WritableHintsStoreImpl(writableHintsStates, entityCounters);
                        this.hintsService.manageRosterAdoption(hintsStore, Objects.requireNonNull(rosterStore.getActiveRoster()), Objects.requireNonNull(rosterStore.getCandidateRoster()), Objects.requireNonNull(rosterStore.getCandidateRosterHash()), tssConfig.forceHandoffs());
                    }
                }
            });
        }
    }

    private void reconcileTssState(@NonNull State state, @NonNull Instant roundTimestamp) {
        TssConfig tssConfig = (TssConfig)this.configProvider.getConfiguration().getConfigData(TssConfig.class);
        if (tssConfig.hintsEnabled() || tssConfig.historyEnabled()) {
            boolean isActive;
            ReadableRosterStoreImpl rosterStore = new ReadableRosterStoreImpl(state.getReadableStates("RosterService"));
            WritableEntityIdStore entityCounters = new WritableEntityIdStore(state.getWritableStates("EntityIdService"));
            ActiveRosters activeRosters = ActiveRosters.from((ReadableRosterStore)rosterStore);
            boolean bl = isActive = this.currentPlatformStatus.get() == PlatformStatus.ACTIVE;
            if (tssConfig.hintsEnabled()) {
                WritableStates crsWritableStates = state.getWritableStates("HintsService");
                Instant workTime = this.blockHashSigner.isReady() ? this.blockStreamManager.lastUsedConsensusTime() : roundTimestamp;
                this.doStreamingKVChanges(crsWritableStates, null, () -> this.hintsService.executeCrsWork(new WritableHintsStoreImpl(crsWritableStates, entityCounters), workTime, isActive));
                WritableStates hintsWritableStates = state.getWritableStates("HintsService");
                this.doStreamingKVChanges(hintsWritableStates, null, () -> this.hintsService.reconcile(activeRosters, new WritableHintsStoreImpl(hintsWritableStates, entityCounters), roundTimestamp, tssConfig, isActive));
            }
            if (tssConfig.historyEnabled()) {
                Bytes currentMetadata = tssConfig.hintsEnabled() ? new ReadableHintsStoreImpl(state.getReadableStates("HintsService"), (ReadableEntityCounters)entityCounters).getActiveVerificationKey() : HintsService.DISABLED_HINTS_METADATA;
                WritableStates historyWritableStates = state.getWritableStates("HistoryService");
                WritableHistoryStoreImpl historyStore = new WritableHistoryStoreImpl(historyWritableStates);
                this.doStreamingKVChanges(historyWritableStates, null, () -> this.historyService.reconcile(activeRosters, currentMetadata, historyStore, this.blockStreamManager.lastUsedConsensusTime(), tssConfig, isActive));
            }
        }
    }

    private static void logPreDispatch(@NonNull ParentTxn parentTxn) {
        if (logger.isDebugEnabled()) {
            TransactionStateLogger.logStartUserTransaction(parentTxn.consensusNow(), parentTxn.txnInfo().txBody(), Objects.requireNonNull(parentTxn.txnInfo().payerID()));
            TransactionStateLogger.logStartUserTransactionPreHandleResultP2(parentTxn.preHandleResult());
            TransactionStateLogger.logStartUserTransactionPreHandleResultP3(parentTxn.preHandleResult());
        }
    }

    private TransactionType typeOfBoundary(@NonNull State state) {
        BlockInfo blockInfo = (BlockInfo)state.getReadableStates("BlockRecordService").getSingleton(V0490BlockRecordSchema.BLOCKS_STATE_ID).get();
        return !Objects.requireNonNull(blockInfo).migrationRecordsStreamed() ? TransactionType.POST_UPGRADE_TRANSACTION : TransactionType.ORDINARY_TRANSACTION;
    }
}

