/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.processors;

import com.hedera.node.app.service.contract.impl.exec.processors.HasTranslatorsModule;
import com.hedera.node.app.service.contract.impl.exec.processors.HssTranslatorsModule;
import com.hedera.node.app.service.contract.impl.exec.processors.HtsTranslatorsModule;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.ExchangeRateSystemContract;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HasSystemContract;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HederaSystemContract;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HssSystemContract;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HtsSystemContract;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.PrngSystemContract;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Objects;
import javax.inject.Singleton;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EvmSpecVersion;
import org.hyperledger.besu.evm.code.CodeFactory;
import org.hyperledger.besu.evm.contractvalidation.ContractValidationRule;
import org.hyperledger.besu.evm.contractvalidation.MaxCodeSizeRule;
import org.hyperledger.besu.evm.contractvalidation.PrefixCodeRule;
import org.hyperledger.besu.evm.internal.EvmConfiguration;

@Module(includes={HtsTranslatorsModule.class, HasTranslatorsModule.class, HssTranslatorsModule.class})
public interface ProcessorModule {
    public static final long INITIAL_CONTRACT_NONCE = 1L;
    public static final boolean REQUIRE_CODE_DEPOSIT_TO_SUCCEED = true;
    public static final int NUM_SYSTEM_ACCOUNTS = 750;

    @Provides
    @Singleton
    @IntoSet
    public static ContractValidationRule provideMaxCodeSizeRule(@NonNull EvmConfiguration evmConfiguration) {
        return MaxCodeSizeRule.from((EvmSpecVersion)EvmSpecVersion.defaultVersion(), (EvmConfiguration)evmConfiguration);
    }

    @Provides
    @Singleton
    @IntoSet
    public static ContractValidationRule providePrefixCodeRule() {
        return PrefixCodeRule.of();
    }

    @Provides
    @Singleton
    public static CodeFactory provideCodeFactory() {
        return new CodeFactory(0, 0);
    }

    @Provides
    @Singleton
    public static Map<Address, HederaSystemContract> provideHederaSystemContracts(@NonNull HtsSystemContract htsSystemContract, @NonNull ExchangeRateSystemContract exchangeRateSystemContract, @NonNull PrngSystemContract prngSystemContract, @NonNull HasSystemContract hasSystemContract, @NonNull HssSystemContract hssSystemContract) {
        return Map.ofEntries(Map.entry(Address.fromHexString((String)"0x167"), Objects.requireNonNull(htsSystemContract)), Map.entry(Address.fromHexString((String)"0x16C"), Objects.requireNonNull(htsSystemContract)), Map.entry(Address.fromHexString((String)"0x168"), Objects.requireNonNull(exchangeRateSystemContract)), Map.entry(Address.fromHexString((String)"0x169"), Objects.requireNonNull(prngSystemContract)), Map.entry(Address.fromHexString((String)"0x16a"), Objects.requireNonNull(hasSystemContract)), Map.entry(Address.fromHexString((String)"0x16b"), Objects.requireNonNull(hssSystemContract)));
    }
}

