/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.preconsensus;

import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.metrics.api.DoubleGauge;
import com.swirlds.metrics.api.LongGauge;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;

public class PcesMetrics {
    private static final String CATEGORY = "platform";
    private static final LongGauge.Config PRECONSENSUS_EVENT_FILE_COUNT_CONFIG = new LongGauge.Config("platform", "preconsensusEventFileCount").withUnit("count").withDescription("The number of preconsensus event files currently being stored");
    private final LongGauge preconsensusEventFileCount;
    private static final DoubleGauge.Config PRECONSENSUS_EVENT_FILE_AVERAGE_SIZE_MB_CONFIG = new DoubleGauge.Config("platform", "preconsensusEventFileAverageSizeMB").withUnit("megabytes").withDescription("The average size of preconsensus event files, in megabytes.");
    private final DoubleGauge preconsensusEventFileAverageSizeMB;
    private static final DoubleGauge.Config PRECONSENSUS_EVENT_FILE_TOTAL_SIZE_GB_CONFIG = new DoubleGauge.Config("platform", "preconsensusEventFileTotalSizeGB").withUnit("gigabytes").withDescription("The total size of all preconsensus event files, in gigabytes.");
    private final DoubleGauge preconsensusEventFileTotalSizeGB;
    private static final SpeedometerMetric.Config PRECONSENSUS_EVENT_FILE_RATE_CONFIG = new SpeedometerMetric.Config("platform", "preconsensusEventFileRate").withUnit("hertz").withDescription("The number of preconsensus event files written per second.");
    private final SpeedometerMetric preconsensusEventFileRate;
    private static final RunningAverageMetric.Config PRECONSENSUS_EVENT_AVERAGE_FILE_SPAN_CONFIG = new RunningAverageMetric.Config("platform", "preconsensusEventAverageFileSpan").withDescription("The average span of preconsensus event files. Only reflectsfiles written since the last restart.");
    private final RunningAverageMetric preconsensusEventAverageFileSpan;
    private static final RunningAverageMetric.Config PRECONSENSUS_EVENT_AVERAGE_UN_UTILIZED_FILE_SPAN_CONFIG = new RunningAverageMetric.Config("platform", "preconsensusEventAverageUnutilizedFileSpan").withDescription("The average unutilized span of preconsensus event files prior to span compaction. Only reflects files written since the last restart. Smaller is better.");
    private final RunningAverageMetric preconsensusEventAverageUnUtilizedFileSpan;
    private static final LongGauge.Config PRECONSENSUS_EVENT_FILE_OLDEST_IDENTIFIER_CONFIG = new LongGauge.Config("platform", "preconsensusEventFileOldestIdentifier").withDescription("The oldest possible ancient indicator that is being stored in preconsensus event files.");
    private final LongGauge preconsensusEventFileOldestIdentifier;
    private static final LongGauge.Config PRECONSENSUS_EVENT_FILE_YOUNGEST_IDENTIFIER_CONFIG = new LongGauge.Config("platform", "preconsensusEventFileYoungestIdentifier").withDescription("The youngest possible ancient indicator that is being stored in preconsensus event files.");
    private final LongGauge preconsensusEventFileYoungestIdentifier;
    private static final LongGauge.Config PRECONSENSUS_EVENT_FILE_OLDEST_SECONDS_CONFIG = new LongGauge.Config("platform", "preconsensusEventFileOldestSeconds").withUnit("seconds").withDescription("The age of the oldest preconsensus event file, in seconds.");
    private final LongGauge preconsensusEventFileOldestSeconds;

    public PcesMetrics(@NonNull Metrics metrics) {
        this.preconsensusEventFileCount = (LongGauge)metrics.getOrCreate((MetricConfig)PRECONSENSUS_EVENT_FILE_COUNT_CONFIG);
        this.preconsensusEventFileAverageSizeMB = (DoubleGauge)metrics.getOrCreate((MetricConfig)PRECONSENSUS_EVENT_FILE_AVERAGE_SIZE_MB_CONFIG);
        this.preconsensusEventFileTotalSizeGB = (DoubleGauge)metrics.getOrCreate((MetricConfig)PRECONSENSUS_EVENT_FILE_TOTAL_SIZE_GB_CONFIG);
        this.preconsensusEventFileRate = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)PRECONSENSUS_EVENT_FILE_RATE_CONFIG);
        this.preconsensusEventAverageFileSpan = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)PRECONSENSUS_EVENT_AVERAGE_FILE_SPAN_CONFIG);
        this.preconsensusEventAverageUnUtilizedFileSpan = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)PRECONSENSUS_EVENT_AVERAGE_UN_UTILIZED_FILE_SPAN_CONFIG);
        this.preconsensusEventFileOldestIdentifier = (LongGauge)metrics.getOrCreate((MetricConfig)PRECONSENSUS_EVENT_FILE_OLDEST_IDENTIFIER_CONFIG);
        this.preconsensusEventFileYoungestIdentifier = (LongGauge)metrics.getOrCreate((MetricConfig)PRECONSENSUS_EVENT_FILE_YOUNGEST_IDENTIFIER_CONFIG);
        this.preconsensusEventFileOldestSeconds = (LongGauge)metrics.getOrCreate((MetricConfig)PRECONSENSUS_EVENT_FILE_OLDEST_SECONDS_CONFIG);
    }

    public LongGauge getPreconsensusEventFileCount() {
        return this.preconsensusEventFileCount;
    }

    public DoubleGauge getPreconsensusEventFileAverageSizeMB() {
        return this.preconsensusEventFileAverageSizeMB;
    }

    public DoubleGauge getPreconsensusEventFileTotalSizeGB() {
        return this.preconsensusEventFileTotalSizeGB;
    }

    public SpeedometerMetric getPreconsensusEventFileRate() {
        return this.preconsensusEventFileRate;
    }

    public RunningAverageMetric getPreconsensusEventAverageFileSpan() {
        return this.preconsensusEventAverageFileSpan;
    }

    public RunningAverageMetric getPreconsensusEventAverageUnUtilizedFileSpan() {
        return this.preconsensusEventAverageUnUtilizedFileSpan;
    }

    public LongGauge getPreconsensusEventFileOldestIdentifier() {
        return this.preconsensusEventFileOldestIdentifier;
    }

    public LongGauge getPreconsensusEventFileYoungestIdentifier() {
        return this.preconsensusEventFileYoungestIdentifier;
    }

    public LongGauge getPreconsensusEventFileOldestSeconds() {
        return this.preconsensusEventFileOldestSeconds;
    }
}

