/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hyperledger.besu.datatypes.Blob;
import org.hyperledger.besu.datatypes.KZGCommitment;
import org.hyperledger.besu.datatypes.KZGProof;
import org.hyperledger.besu.datatypes.VersionedHash;

public class BlobsWithCommitments {
    private final List<BlobQuad> blobQuads;

    public BlobsWithCommitments(List<KZGCommitment> kzgCommitments, List<Blob> blobs, List<KZGProof> kzgProofs, List<VersionedHash> versionedHashes) {
        if (blobs.isEmpty()) {
            throw new InvalidParameterException("There needs to be a minimum of one blob in a blob transaction with commitments");
        }
        if (blobs.size() != kzgCommitments.size() || blobs.size() != kzgProofs.size() || blobs.size() != versionedHashes.size()) {
            throw new InvalidParameterException("There must be an equal number of blobs, commitments, proofs, and versioned hashes");
        }
        ArrayList<BlobQuad> toBuild = new ArrayList<BlobQuad>(blobs.size());
        for (int i = 0; i < blobs.size(); ++i) {
            toBuild.add(new BlobQuad(blobs.get(i), kzgCommitments.get(i), kzgProofs.get(i), versionedHashes.get(i)));
        }
        this.blobQuads = toBuild;
    }

    public BlobsWithCommitments(List<BlobQuad> quads) {
        this.blobQuads = quads;
    }

    public List<Blob> getBlobs() {
        return this.blobQuads.stream().map(BlobQuad::blob).toList();
    }

    public List<KZGCommitment> getKzgCommitments() {
        return this.blobQuads.stream().map(BlobQuad::kzgCommitment).toList();
    }

    public List<KZGProof> getKzgProofs() {
        return this.blobQuads.stream().map(BlobQuad::kzgProof).toList();
    }

    public List<VersionedHash> getVersionedHashes() {
        return this.blobQuads.stream().map(BlobQuad::versionedHash).toList();
    }

    public List<BlobQuad> getBlobQuads() {
        return this.blobQuads;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlobsWithCommitments that = (BlobsWithCommitments)o;
        return Objects.equals(this.getBlobQuads(), that.getBlobQuads());
    }

    public int hashCode() {
        return Objects.hash(this.getBlobQuads());
    }

    public record BlobQuad(Blob blob, KZGCommitment kzgCommitment, KZGProof kzgProof, VersionedHash versionedHash) {
    }
}

