/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.common.Builder;
import io.helidon.http.http2.FlowControl;
import io.helidon.http.http2.Http2WindowUpdate;
import io.helidon.http.http2.StreamFlowControl;
import io.helidon.http.http2.WindowSize;
import java.time.Duration;
import java.util.function.BiConsumer;

public class ConnectionFlowControl {
    private static final System.Logger LOGGER_OUTBOUND = System.getLogger(FlowControl.class.getName() + ".ofc");
    private final Type type;
    private final BiConsumer<Integer, Http2WindowUpdate> windowUpdateWriter;
    private final Duration timeout;
    private final WindowSize.Inbound inboundConnectionWindowSize;
    private final WindowSize.Outbound outboundConnectionWindowSize;
    private volatile int maxFrameSize = 16384;
    private volatile int initialWindowSize = 65535;

    private ConnectionFlowControl(Type type, int initialWindowSize, int maxFrameSize, BiConsumer<Integer, Http2WindowUpdate> windowUpdateWriter, Duration timeout) {
        this.type = type;
        this.windowUpdateWriter = windowUpdateWriter;
        this.timeout = timeout;
        this.inboundConnectionWindowSize = WindowSize.createInbound(type, 0, initialWindowSize, maxFrameSize, windowUpdateWriter);
        this.outboundConnectionWindowSize = WindowSize.createOutbound(type, 0, this);
    }

    public static ConnectionFlowControlBuilder serverBuilder(BiConsumer<Integer, Http2WindowUpdate> windowUpdateWriter) {
        return new ConnectionFlowControlBuilder(Type.SERVER, windowUpdateWriter);
    }

    public static ConnectionFlowControlBuilder clientBuilder(BiConsumer<Integer, Http2WindowUpdate> windowUpdateWriter) {
        return new ConnectionFlowControlBuilder(Type.CLIENT, windowUpdateWriter);
    }

    public StreamFlowControl createStreamFlowControl(int streamId, int outboundInitialWindowSize, int outboundMaxFrameSize) {
        return new StreamFlowControl(this.type, streamId, outboundInitialWindowSize, outboundMaxFrameSize, this, this.windowUpdateWriter);
    }

    public long incrementOutboundConnectionWindowSize(int increment) {
        return this.outboundConnectionWindowSize.incrementWindowSize(increment);
    }

    public long decrementInboundConnectionWindowSize(int decrement) {
        return this.inboundConnectionWindowSize.decrementWindowSize(decrement);
    }

    public void resetMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public void resetInitialWindowSize(int initialWindowSize) {
        if (LOGGER_OUTBOUND.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER_OUTBOUND.log(System.Logger.Level.DEBUG, String.format("%s OFC STR *: Recv INIT_WINDOW_SIZE %s", new Object[]{this.type, initialWindowSize}));
        }
        this.initialWindowSize = initialWindowSize;
    }

    public WindowSize.Outbound outbound() {
        return this.outboundConnectionWindowSize;
    }

    WindowSize.Inbound inbound() {
        return this.inboundConnectionWindowSize;
    }

    int maxFrameSize() {
        return this.maxFrameSize;
    }

    int initialWindowSize() {
        return this.initialWindowSize;
    }

    Duration timeout() {
        return this.timeout;
    }

    static enum Type {
        SERVER,
        CLIENT;

    }

    public static class ConnectionFlowControlBuilder
    implements Builder<ConnectionFlowControlBuilder, ConnectionFlowControl> {
        private static final Duration DEFAULT_TIMEOUT = Duration.ofMillis(100L);
        private final Type type;
        private final BiConsumer<Integer, Http2WindowUpdate> windowUpdateWriter;
        private int initialWindowSize = 65535;
        private int maxFrameSize = 16384;
        private Duration blockTimeout = DEFAULT_TIMEOUT;

        ConnectionFlowControlBuilder(Type type, BiConsumer<Integer, Http2WindowUpdate> windowUpdateWriter) {
            this.type = type;
            this.windowUpdateWriter = windowUpdateWriter;
        }

        public ConnectionFlowControlBuilder initialWindowSize(int initialWindowSize) {
            this.initialWindowSize = initialWindowSize;
            return this;
        }

        public ConnectionFlowControlBuilder maxFrameSize(int maxFrameSize) {
            this.maxFrameSize = maxFrameSize;
            return this;
        }

        public ConnectionFlowControlBuilder blockTimeout(Duration timeout) {
            this.blockTimeout = timeout;
            return this;
        }

        public ConnectionFlowControl build() {
            return new ConnectionFlowControl(this.type, this.initialWindowSize, this.maxFrameSize, this.windowUpdateWriter, this.blockTimeout);
        }
    }
}

