/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.block.api;

import com.hedera.hapi.block.stream.BlockItem;
import com.hedera.hapi.block.stream.MerkleSiblingHash;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.hiero.block.api.codec.BlockContentsProofJsonCodec;
import org.hiero.block.api.codec.BlockContentsProofProtoCodec;
import org.hiero.block.api.schema.BlockContentsProofSchema;

public final class BlockContentsProof {
    public static final Codec<BlockContentsProof> PROTOBUF = new BlockContentsProofProtoCodec();
    public static final JsonCodec<BlockContentsProof> JSON = new BlockContentsProofJsonCodec();
    public static final BlockContentsProof DEFAULT = BlockContentsProof.newBuilder().build();
    @Nullable
    private final BlockItem blockItem;
    @NonNull
    private final List<MerkleSiblingHash> siblingHashes;
    @NonNull
    private final Bytes blockSignature;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public BlockContentsProof(BlockItem blockItem, List<MerkleSiblingHash> siblingHashes, Bytes blockSignature) {
        this.$unknownFields = null;
        this.blockItem = blockItem;
        this.siblingHashes = siblingHashes == null ? Collections.emptyList() : siblingHashes;
        this.blockSignature = blockSignature != null ? blockSignature : Bytes.EMPTY;
    }

    public BlockContentsProof(BlockItem blockItem, List<MerkleSiblingHash> siblingHashes, Bytes blockSignature, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.blockItem = blockItem;
        this.siblingHashes = siblingHashes == null ? Collections.emptyList() : siblingHashes;
        this.blockSignature = blockSignature != null ? blockSignature : Bytes.EMPTY;
    }

    public BlockItem blockItem() {
        return this.blockItem;
    }

    public List<MerkleSiblingHash> siblingHashes() {
        return this.siblingHashes;
    }

    public Bytes blockSignature() {
        return this.blockSignature;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockContentsProofSchema.BLOCK_ITEM, (Object)this.blockItem, BlockItem.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)BlockContentsProofSchema.SIBLING_HASHES, this.siblingHashes, MerkleSiblingHash.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)BlockContentsProofSchema.BLOCK_SIGNATURE, (RandomAccessData)this.blockSignature, (boolean)true);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            List<MerkleSiblingHash> list$siblingHashes;
            int result = 1;
            if (this.blockItem != null && !this.blockItem.equals(BlockContentsProof.DEFAULT.blockItem)) {
                result = 31 * result + this.blockItem.hashCode();
            }
            if ((list$siblingHashes = this.siblingHashes) != null) {
                for (MerkleSiblingHash o : list$siblingHashes) {
                    if (o != null) {
                        result = 31 * result + ((Object)o).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.blockSignature != null && !this.blockSignature.equals((Object)BlockContentsProof.DEFAULT.blockSignature)) {
                result = 31 * result + this.blockSignature.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        BlockContentsProof thatObj = (BlockContentsProof)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.blockItem == null && thatObj.blockItem != null) {
            return false;
        }
        if (this.blockItem != null && !this.blockItem.equals(thatObj.blockItem)) {
            return false;
        }
        if (this.siblingHashes == null && thatObj.siblingHashes != null) {
            return false;
        }
        if (this.siblingHashes != null && !this.siblingHashes.equals(thatObj.siblingHashes)) {
            return false;
        }
        if (this.blockSignature == null && thatObj.blockSignature != null) {
            return false;
        }
        if (this.blockSignature != null && !this.blockSignature.equals((Object)thatObj.blockSignature)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "BlockContentsProof[blockItem=" + String.valueOf(this.blockItem) + ", siblingHashes=" + String.valueOf(this.siblingHashes) + ", blockSignature=" + String.valueOf(this.blockSignature) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasBlockItem() {
        return this.blockItem != null;
    }

    public BlockItem blockItemOrElse(@NonNull BlockItem defaultValue) {
        return this.hasBlockItem() ? this.blockItem : defaultValue;
    }

    @NonNull
    public BlockItem blockItemOrThrow() {
        return Objects.requireNonNull(this.blockItem, "Field blockItem is null");
    }

    public void ifBlockItem(@NonNull Consumer<BlockItem> ifPresent) {
        if (this.hasBlockItem()) {
            ifPresent.accept(this.blockItem);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.blockItem, this.siblingHashes, this.blockSignature, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private BlockItem blockItem = null;
        @NonNull
        private List<MerkleSiblingHash> siblingHashes = Collections.emptyList();
        @NonNull
        private Bytes blockSignature = Bytes.EMPTY;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(BlockItem blockItem, List<MerkleSiblingHash> siblingHashes, Bytes blockSignature) {
            this.$unknownFields = null;
            this.blockItem = blockItem;
            this.siblingHashes = siblingHashes == null ? Collections.emptyList() : siblingHashes;
            this.blockSignature = blockSignature != null ? blockSignature : Bytes.EMPTY;
        }

        public Builder(BlockItem blockItem, List<MerkleSiblingHash> siblingHashes, Bytes blockSignature, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.blockItem = blockItem;
            this.siblingHashes = siblingHashes == null ? Collections.emptyList() : siblingHashes;
            this.blockSignature = blockSignature != null ? blockSignature : Bytes.EMPTY;
        }

        public BlockContentsProof build() {
            return new BlockContentsProof(this.blockItem, this.siblingHashes, this.blockSignature);
        }

        public Builder blockItem(@Nullable BlockItem blockItem) {
            this.blockItem = blockItem;
            return this;
        }

        public Builder blockItem(BlockItem.Builder builder) {
            this.blockItem = builder.build();
            return this;
        }

        public Builder siblingHashes(@NonNull List<MerkleSiblingHash> siblingHashes) {
            this.siblingHashes = siblingHashes != null ? siblingHashes : Collections.emptyList();
            return this;
        }

        public Builder siblingHashes(MerkleSiblingHash ... values) {
            this.siblingHashes = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder blockSignature(@NonNull Bytes blockSignature) {
            this.blockSignature = blockSignature != null ? blockSignature : Bytes.EMPTY;
            return this;
        }
    }
}

