/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import io.helidon.common.LruCache;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

final class LruCacheImpl<K, V>
implements LruCache<K, V> {
    private final LinkedHashMap<K, V> backingMap = new LinkedHashMap();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final int capacity;

    LruCacheImpl(int capacity) {
        this.capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<V> get(K key) {
        V value;
        this.readLock.lock();
        try {
            value = this.backingMap.get(key);
        }
        finally {
            this.readLock.unlock();
        }
        if (null == value) {
            return Optional.empty();
        }
        this.writeLock.lock();
        try {
            value = this.backingMap.get(key);
            if (null == value) {
                Optional optional = Optional.empty();
                return optional;
            }
            this.backingMap.remove(key);
            this.backingMap.put(key, value);
            Optional<V> optional = Optional.of(value);
            return optional;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Optional<V> remove(K key) {
        this.writeLock.lock();
        try {
            Optional optional = Optional.ofNullable(this.backingMap.remove(key));
            return optional;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<V> put(K key, V value) {
        this.writeLock.lock();
        try {
            Object currentValue = this.backingMap.remove(key);
            if (null == currentValue && this.backingMap.size() >= this.capacity) {
                Iterator<V> iterator = this.backingMap.values().iterator();
                iterator.next();
                iterator.remove();
            }
            this.backingMap.put(key, value);
            Optional optional = Optional.ofNullable(currentValue);
            return optional;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Optional<V> computeValue(K key, Supplier<Optional<V>> valueSupplier) {
        Optional<V> currentValue = this.get(key);
        if (currentValue.isPresent()) {
            return currentValue;
        }
        Optional<V> newValue = valueSupplier.get();
        newValue.ifPresent(theValue -> this.put(key, theValue));
        return newValue;
    }

    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = this.backingMap.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.backingMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

