/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.spi;

import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.MergingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class FallbackMergingStrategy
implements MergingStrategy {
    FallbackMergingStrategy() {
    }

    @Override
    public ConfigNode.ObjectNode merge(List<ConfigNode.ObjectNode> rootNodesParam) {
        ArrayList<ConfigNode.ObjectNode> rootNodes = new ArrayList<ConfigNode.ObjectNode>(rootNodesParam);
        Collections.reverse(rootNodes);
        ConfigNode.ObjectNode.Builder builder = ConfigNode.ObjectNode.builder();
        rootNodes.forEach(root -> root.forEach((key, node) -> FallbackMergingStrategy.addNode(builder, key, node)));
        return builder.build();
    }

    private static void addNode(ConfigNode.ObjectNode.Builder builder, String key, ConfigNode node) {
        switch (node.nodeType()) {
            case OBJECT: {
                builder.addObject(key, (ConfigNode.ObjectNode)node);
                return;
            }
            case LIST: {
                builder.addList(key, (ConfigNode.ListNode)node);
                return;
            }
            case VALUE: {
                builder.addValue(key, (ConfigNode.ValueNode)node);
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported node type: " + node.getClass().getName());
    }
}

