/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.common.nativesupport;

import com.hedera.common.nativesupport.Architecture;
import com.hedera.common.nativesupport.OperatingSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class NativeBinary {
    private static final String SOFTWARE_FOLDER_NAME = "com/hedera/nativelib";
    private static final String RESOURCE_PATH_DELIMITER = "/";
    private static final Map<String, Path> pathCache = new HashMap<String, Path>();
    private final String name;
    private final Map<OperatingSystem, String> libExtensions;
    private final Map<OperatingSystem, String> libPrefixes;

    public NativeBinary(String name, Map<OperatingSystem, String> libPrefixes, Map<OperatingSystem, String> libExtensions) {
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.libExtensions = Map.copyOf(Objects.requireNonNull(libExtensions, "libExtensions must not be null"));
        this.libPrefixes = Map.copyOf(Objects.requireNonNull(libPrefixes, "libPrefixes must not be null"));
    }

    public String name() {
        return this.name;
    }

    public String locationInJar() {
        return NativeBinary.locationInJar(this.name, this.libPrefixes, this.libExtensions);
    }

    public static String locationInJar(String libraryName, Map<OperatingSystem, String> libPrefixes, Map<OperatingSystem, String> libExtensions) {
        Objects.requireNonNull(libraryName, "name must not be null");
        Objects.requireNonNull(libPrefixes, "libPrefixes must not be null");
        Objects.requireNonNull(libExtensions, "libExtensions must not be null");
        OperatingSystem os = OperatingSystem.current();
        Architecture arch = Architecture.current();
        String libPrefix = libPrefixes.getOrDefault((Object)os, "");
        Object libExtension = libExtensions.get((Object)os);
        libExtension = libExtension != null && !((String)libExtension).isEmpty() ? "." + (String)libExtension : "";
        return "com/hedera/nativelib/" + libraryName + RESOURCE_PATH_DELIMITER + os.name().toLowerCase(Locale.US) + RESOURCE_PATH_DELIMITER + arch.name().toLowerCase(Locale.US) + RESOURCE_PATH_DELIMITER + libPrefix + libraryName + (String)libExtension;
    }

    public String packageNameOfResource() {
        String name = this.locationInJar();
        int index = name.lastIndexOf(47);
        if (index == -1 || index == name.length() - 1) {
            return "";
        }
        return name.substring(0, index).replace('/', '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path extract(Class<?> c) {
        if (!c.getModule().isOpen(this.packageNameOfResource(), this.getClass().getModule())) {
            throw new IllegalStateException("The module '%s' must open the package '%s' to module '%s'".formatted(c.getModule().getName(), this.packageNameOfResource(), this.getClass().getModule().getName()));
        }
        Map<String, Path> map = pathCache;
        synchronized (map) {
            return pathCache.computeIfAbsent(this.name, k -> this.extractUnchecked(c));
        }
    }

    protected Path extractUnchecked(Class<?> c) {
        try {
            return this.extract(c.getModule().getResourceAsStream(this.locationInJar()));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to load adapter " + this.name(), new IOException(e));
        }
    }

    private Path extract(InputStream resourceStream) throws IOException {
        Objects.requireNonNull(resourceStream, "resourceStream must not be null");
        OperatingSystem os = OperatingSystem.current();
        String libName = os == OperatingSystem.WINDOWS ? this.name + "." + this.libExtensions.get((Object)OperatingSystem.WINDOWS) : this.name;
        String fileName = Path.of(libName, new String[0]).getFileName().toString();
        Path tempDirectory = this.createTempDirectory();
        Path tempFile = tempDirectory.resolve(fileName);
        Files.copy(resourceStream, tempFile, new CopyOption[0]);
        if (NativeBinary.isPosixCompliant()) {
            Files.setPosixFilePermissions(tempFile, PosixFilePermissions.fromString("rwxrwxrwx"));
        } else {
            File f = tempFile.toFile();
            f.setExecutable(true, false);
            f.setReadable(true, false);
            f.setWritable(true, false);
        }
        return tempFile;
    }

    private Path createTempDirectory() throws IOException {
        Path tempDirectory = Files.createTempDirectory(this.name, new FileAttribute[0]);
        tempDirectory.toFile().mkdir();
        tempDirectory.toFile().deleteOnExit();
        return tempDirectory;
    }

    static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (SecurityException | FileSystemNotFoundException | ProviderNotFoundException e) {
            return false;
        }
    }
}

