/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.keys;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.ThresholdKey;
import com.hedera.node.app.hapi.utils.keys.Ed25519Utils;
import com.hedera.node.app.hapi.utils.keys.Secp256k1Utils;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.security.DrbgParameters;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PKCS8Generator;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPKCS8Generator;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8EncryptorBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

public final class KeyUtils {
    public static final Key IMMUTABILITY_SENTINEL_KEY = Key.newBuilder().keyList(KeyList.DEFAULT).build();
    public static final String TEST_CLIENTS_PREFIX = "hedera-node" + File.separator + "test-clients" + File.separator;
    public static final Provider BC_PROVIDER = new BouncyCastleProvider();
    private static final int ENCRYPTOR_ITERATION_COUNT = 10000;
    private static final String RESOURCE_PATH_SEGMENT = "src/main/resource";
    private static final DrbgParameters.Instantiation DRBG_INSTANTIATION = DrbgParameters.instantiation(256, DrbgParameters.Capability.RESEED_ONLY, null);

    private KeyUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static Path relocatedIfNotPresentInWorkingDir(Path path) {
        return KeyUtils.relocatedIfNotPresentInWorkingDir(path.toFile()).toPath();
    }

    public static File relocatedIfNotPresentInWorkingDir(File file) {
        return KeyUtils.relocatedIfNotPresentWithCurrentPathPrefix(file, RESOURCE_PATH_SEGMENT, TEST_CLIENTS_PREFIX);
    }

    public static File relocatedIfNotPresentWithCurrentPathPrefix(File file, String firstSegmentToRelocate, String newPathPrefix) {
        if (!file.exists()) {
            String absPath = KeyUtils.withDedupedHederaNodePathSegments(file.getAbsolutePath());
            int idx = absPath.indexOf(firstSegmentToRelocate);
            if (idx == -1) {
                return new File(absPath);
            }
            String relocatedPath = newPathPrefix + absPath.substring(idx);
            return new File(relocatedPath);
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends PrivateKey> T readKeyFrom(File pem, String passphrase, Provider pemKeyProvider) {
        File relocatedPem = KeyUtils.relocatedIfNotPresentInWorkingDir(pem);
        try (FileInputStream in = new FileInputStream(relocatedPem);){
            T t = KeyUtils.readKeyFrom(in, passphrase, pemKeyProvider);
            return t;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends PrivateKey> T readKeyFrom(@NonNull InputStream in, @NonNull String passphrase, @NonNull Provider pemKeyProvider) {
        try {
            InputDecryptorProvider decryptProvider = new JceOpenSSLPKCS8DecryptorProviderBuilder().setProvider(BC_PROVIDER).build(passphrase.toCharArray());
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(pemKeyProvider);
            try (PEMParser parser = new PEMParser((Reader)new InputStreamReader(in));){
                PKCS8EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)parser.readObject();
                PrivateKeyInfo info = encryptedPrivateKeyInfo.decryptPrivateKeyInfo(decryptProvider);
                PrivateKey privateKey = converter.getPrivateKey(info);
                return (T)privateKey;
            }
        }
        catch (IOException | OperatorCreationException | PKCSException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void writeKeyTo(PrivateKey key, String pemLoc, String passphrase) {
        File pem = new File(pemLoc);
        try (FileOutputStream out = new FileOutputStream(pem);){
            SecureRandom random = SecureRandom.getInstance("DRBG", DRBG_INSTANTIATION);
            OutputEncryptor encryptor = new JceOpenSSLPKCS8EncryptorBuilder(PKCS8Generator.AES_256_CBC).setPRF(PKCS8Generator.PRF_HMACSHA384).setIterationCount(10000).setRandom(random).setPassword(passphrase.toCharArray()).setProvider(BC_PROVIDER).build();
            try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)new OutputStreamWriter(out));){
                pemWriter.writeObject((PemObjectGenerator)new JcaPKCS8Generator(key, encryptor).generate());
                pemWriter.flush();
            }
        }
        catch (IOException | NoSuchAlgorithmException | OperatorCreationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isEmpty(@Nullable Key pbjKey) {
        return KeyUtils.isEmptyInternal(pbjKey, false);
    }

    private static boolean isEmptyInternal(@Nullable Key pbjKey, boolean honorImmutable) {
        if (pbjKey == null) {
            return true;
        }
        OneOf key = pbjKey.key();
        if (key == null || Key.KeyOneOfType.UNSET.equals((Object)key.kind())) {
            return true;
        }
        if (honorImmutable && IMMUTABILITY_SENTINEL_KEY.equals((Object)pbjKey)) {
            return false;
        }
        if (pbjKey.hasKeyList()) {
            KeyList keyList = (KeyList)key.value();
            if (keyList.keys().isEmpty()) {
                return true;
            }
            for (Key k : keyList.keys()) {
                if (KeyUtils.isEmpty(k)) continue;
                return false;
            }
            return true;
        }
        if (pbjKey.hasThresholdKey()) {
            ThresholdKey thresholdKey = (ThresholdKey)key.value();
            if (!thresholdKey.hasKeys() || thresholdKey.keys().keys().size() == 0) {
                return true;
            }
            for (Key k : thresholdKey.keys().keys()) {
                if (KeyUtils.isEmpty(k)) continue;
                return false;
            }
            return true;
        }
        if (pbjKey.hasEd25519()) {
            return ((Bytes)key.value()).length() == 0L;
        }
        if (pbjKey.hasEcdsaSecp256k1()) {
            return ((Bytes)key.value()).length() == 0L;
        }
        if (pbjKey.hasDelegatableContractId() || pbjKey.hasContractID()) {
            return ((ContractID)key.value()).contractNumOrElse(Long.valueOf(0L)) == 0L && ((ContractID)key.value()).evmAddressOrElse(Bytes.EMPTY).length() == 0L;
        }
        return true;
    }

    public static boolean isValid(@Nullable Key pbjKey) {
        if (KeyUtils.isEmpty(pbjKey)) {
            return false;
        }
        OneOf key = pbjKey.key();
        if (pbjKey.hasKeyList()) {
            for (Key keys : ((KeyList)key.value()).keys()) {
                if (KeyUtils.isValid(keys)) continue;
                return false;
            }
            return true;
        }
        if (pbjKey.hasThresholdKey()) {
            int length = ((ThresholdKey)key.value()).keys().keys().size();
            int threshold = ((ThresholdKey)key.value()).threshold();
            boolean isKeyListValid = true;
            for (Key keys : ((ThresholdKey)key.value()).keys().keys()) {
                if (KeyUtils.isValid(keys)) continue;
                isKeyListValid = false;
                break;
            }
            return threshold >= 1 && threshold <= length && isKeyListValid;
        }
        if (pbjKey.hasEd25519()) {
            return Ed25519Utils.isValidEd25519Key((Bytes)key.value());
        }
        if (pbjKey.hasEcdsaSecp256k1()) {
            return Secp256k1Utils.isValidEcdsaSecp256k1Key((Bytes)key.value());
        }
        if (pbjKey.hasDelegatableContractId() || pbjKey.hasContractID()) {
            return Secp256k1Utils.isValidEvmAddress((ContractID)key.value());
        }
        return true;
    }

    public static PrivateKey readUnknownTypeKeyFrom(File pem, String passphrase) {
        try {
            return Ed25519Utils.readKeyFrom(pem, passphrase);
        }
        catch (Exception e) {
            return Secp256k1Utils.readECKeyFrom(pem, passphrase);
        }
    }

    public static PrivateKey readUnknownTypeKeyFrom(byte[] bytes) {
        try {
            return Ed25519Utils.keyFrom(bytes);
        }
        catch (Exception e) {
            return Secp256k1Utils.readECKeyFrom(bytes);
        }
    }

    private static String withDedupedHederaNodePathSegments(@NonNull String loc) {
        int firstSegmentI = loc.indexOf("hedera-node");
        if (firstSegmentI == -1) {
            return loc;
        }
        int lastSegmentI = loc.lastIndexOf("hedera-node");
        if (lastSegmentI != firstSegmentI) {
            return loc.substring(0, firstSegmentI) + loc.substring(lastSegmentI);
        }
        return loc;
    }
}

