/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.PendingAirdropId;
import com.hedera.hapi.node.base.PendingAirdropValue;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.AccountPendingAirdrop;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.token.TokenAirdropTransactionBody;
import com.hedera.hapi.node.transaction.PendingAirdropRecord;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.service.token.ReadableAirdropStore;
import com.hedera.node.app.service.token.ReadableNftStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableAirdropStore;
import com.hedera.node.app.service.token.impl.handlers.transfer.AssociateTokenRecipientsStep;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferContextImpl;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferExecutor;
import com.hedera.node.app.service.token.impl.handlers.transfer.hooks.HookCallFactory;
import com.hedera.node.app.service.token.impl.util.AirdropHandlerHelper;
import com.hedera.node.app.service.token.impl.util.CryptoTransferHelper;
import com.hedera.node.app.service.token.impl.validators.CryptoTransferValidator;
import com.hedera.node.app.service.token.impl.validators.TokenAirdropValidator;
import com.hedera.node.app.service.token.records.CryptoTransferStreamBuilder;
import com.hedera.node.app.service.token.records.TokenAirdropStreamBuilder;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.TokensConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class TokenAirdropHandler
extends TransferExecutor
implements TransactionHandler {
    private static final Logger log = LogManager.getLogger(TokenAirdropHandler.class);
    private final TokenAirdropValidator validator;

    @Inject
    public TokenAirdropHandler(@NonNull TokenAirdropValidator validator, @NonNull CryptoTransferValidator cryptoTransferValidator, @NonNull HookCallFactory hookCallFactory) {
        super(cryptoTransferValidator, hookCallFactory);
        this.validator = validator;
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TokenAirdropTransactionBody op = context.body().tokenAirdropOrThrow();
        CryptoTransferTransactionBody convertedOp = CryptoTransferTransactionBody.newBuilder().tokenTransfers(op.tokenTransfers()).build();
        this.preHandleWithOptionalReceiverSignature(context, convertedOp);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        Objects.requireNonNull(txn);
        TokenAirdropTransactionBody op = txn.tokenAirdropOrThrow();
        this.validator.pureChecks(op);
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        TokenAirdropTransactionBody op = txn.tokenAirdropOrThrow();
        WritableAirdropStore pendingStore = (WritableAirdropStore)context.storeFactory().writableStore(WritableAirdropStore.class);
        WritableAccountStore accountStore = (WritableAccountStore)context.storeFactory().writableStore(WritableAccountStore.class);
        ReadableNftStore nftStore = (ReadableNftStore)context.storeFactory().readableStore(ReadableNftStore.class);
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.storeFactory().readableStore(ReadableTokenStore.class);
        ReadableTokenRelationStore tokenRelStore = (ReadableTokenRelationStore)context.storeFactory().readableStore(ReadableTokenRelationStore.class);
        TokenAirdropStreamBuilder recordBuilder = (TokenAirdropStreamBuilder)context.savepointStack().getBaseBuilder(TokenAirdropStreamBuilder.class);
        TokensConfig tokensConfig = (TokensConfig)context.configuration().getConfigData(TokensConfig.class);
        ArrayList<TokenTransferList> tokenTransferList = new ArrayList<TokenTransferList>();
        this.validator.validateSemantics(context, op, accountStore, tokenStore, tokenRelStore, nftStore);
        CryptoTransferTransactionBody convertedOp = CryptoTransferTransactionBody.newBuilder().tokenTransfers(op.tokenTransfers()).build();
        CryptoTransferTransactionBody opBodyAfterCustomFeesAssessment = this.assessAndChargeCustomFee(context, convertedOp);
        for (TokenTransferList xfers : opBodyAfterCustomFeesAssessment.tokenTransfers()) {
            TokenAirdropHandler.throwIfReceiverCannotClaimAirdrop(xfers, accountStore);
            TokenID tokenId = xfers.tokenOrThrow();
            boolean shouldExecuteCryptoTransfer = false;
            TokenTransferList.Builder transferListBuilder = TokenTransferList.newBuilder().expectedDecimals(xfers.expectedDecimals()).token(tokenId);
            if (!xfers.transfers().isEmpty()) {
                AirdropHandlerHelper.FungibleAirdropLists fungibleLists = AirdropHandlerHelper.separateFungibleTransfers(context, tokenId, xfers.transfers());
                HandleException.validateTrue((pendingStore.sizeOfState() + (long)fungibleLists.pendingFungibleAmounts().size() <= tokensConfig.maxAllowedPendingAirdrops() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED);
                Optional<AccountAmount> senderAccountAmount = xfers.transfers().stream().filter(item -> item.amount() < 0L).findFirst();
                AccountID senderId = senderAccountAmount.orElseThrow().accountIDOrThrow();
                int existingPendingAirdropsCount = this.countExistingPendingAirdrops(senderId, fungibleLists.pendingFungibleAmounts(), tokenId, pendingStore);
                this.chargeAirdropFee(context, fungibleLists.pendingFungibleAmounts().size(), fungibleLists.transfersNeedingAutoAssociation(), existingPendingAirdropsCount);
                this.createPendingAirdropsForFungible(fungibleLists.pendingFungibleAmounts(), tokenId, senderId, accountStore, pendingStore, recordBuilder);
                if (!fungibleLists.transferFungibleAmounts().isEmpty()) {
                    shouldExecuteCryptoTransfer = true;
                    this.addTransfersToTransferList(fungibleLists.transferFungibleAmounts(), senderId, senderAccountAmount.get().isApproval(), transferListBuilder);
                }
            }
            if (!xfers.nftTransfers().isEmpty()) {
                Optional nftTransfer = xfers.nftTransfers().stream().findFirst();
                AccountID senderId = ((NftTransfer)nftTransfer.orElseThrow()).senderAccountIDOrThrow();
                AirdropHandlerHelper.NftAirdropLists nftLists = AirdropHandlerHelper.separateNftTransfers(context, tokenId, xfers.nftTransfers());
                HandleException.validateTrue((pendingStore.sizeOfState() + (long)nftLists.pendingNftList().size() <= tokensConfig.maxAllowedPendingAirdrops() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED);
                this.chargeAirdropFee(context, nftLists.pendingNftList().size(), nftLists.transfersNeedingAutoAssociation(), 0);
                this.createPendingAirdropsForNFTs(nftLists.pendingNftList(), tokenId, pendingStore, senderId, accountStore, recordBuilder);
                if (!nftLists.transferNftList().isEmpty()) {
                    shouldExecuteCryptoTransfer = true;
                    transferListBuilder.nftTransfers(nftLists.transferNftList());
                }
            }
            if (!shouldExecuteCryptoTransfer) continue;
            tokenTransferList.add(transferListBuilder.build());
        }
        if (!tokenTransferList.isEmpty()) {
            this.executeAirdropCryptoTransfer(context, tokenTransferList, (CryptoTransferStreamBuilder)recordBuilder);
        }
    }

    private static void throwIfReceiverCannotClaimAirdrop(@NonNull TokenTransferList tokenTransferList, @NonNull WritableAccountStore accountStore) {
        Collection<AccountID> receiverIds = TokenAirdropHandler.extractAllReceiverIds(tokenTransferList);
        for (AccountID receiverId : receiverIds) {
            Account account = accountStore.getAliasedAccountById(receiverId);
            if (account == null) continue;
            HandleException.validateTrue((HapiUtils.isHollow((Account)account) || TokenAirdropHandler.canClaimAirdrop(account.keyOrThrow()) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.NOT_SUPPORTED);
        }
    }

    private static boolean canClaimAirdrop(@NonNull Key key) {
        return switch ((Key.KeyOneOfType)key.key().kind()) {
            default -> throw new MatchException(null, null);
            case Key.KeyOneOfType.UNSET -> throw new IllegalStateException("Key kind cannot be UNSET");
            case Key.KeyOneOfType.CONTRACT_ID -> true;
            case Key.KeyOneOfType.ED25519 -> true;
            case Key.KeyOneOfType.RSA_3072 -> false;
            case Key.KeyOneOfType.ECDSA_384 -> false;
            case Key.KeyOneOfType.THRESHOLD_KEY -> {
                if (key.thresholdKeyOrThrow().keysOrThrow().keys().stream().filter(TokenAirdropHandler::canClaimAirdrop).count() >= (long)key.thresholdKeyOrThrow().threshold()) {
                    yield true;
                }
                yield false;
            }
            case Key.KeyOneOfType.KEY_LIST -> key.keyListOrThrow().keys().stream().allMatch(TokenAirdropHandler::canClaimAirdrop);
            case Key.KeyOneOfType.ECDSA_SECP256K1 -> true;
            case Key.KeyOneOfType.DELEGATABLE_CONTRACT_ID -> false;
        };
    }

    private static Collection<AccountID> extractAllReceiverIds(@NonNull TokenTransferList tokenTransferList) {
        HashSet<AccountID> receivers = new HashSet<AccountID>();
        receivers.addAll(tokenTransferList.transfers().stream().filter(t -> t.amount() > 0L).map(AccountAmount::accountID).toList());
        receivers.addAll(tokenTransferList.nftTransfers().stream().map(NftTransfer::receiverAccountID).toList());
        return receivers;
    }

    private void chargeAirdropFee(@NonNull HandleContext context, int pendingAirdropsSize, int numUnlimitedAssociationTransfers, int existingPendingAirdropsCount) {
        long pendingAirdropFeeIncludingAssociationsFee = this.airdropFeeForPendingAirdrop(context) * (long)(pendingAirdropsSize - existingPendingAirdropsCount);
        long pendingAirdropFeeWithoutAssociationsFee = this.airdropFeeForPendingAirdrop(context, false) * (long)existingPendingAirdropsCount;
        long airdropFeeForUnlimitedAssociations = this.airdropFee(context) * (long)numUnlimitedAssociationTransfers;
        long totalFee = pendingAirdropFeeIncludingAssociationsFee + airdropFeeForUnlimitedAssociations + pendingAirdropFeeWithoutAssociationsFee;
        if (!context.tryToChargePayer(totalFee)) {
            throw new HandleException(ResponseCodeEnum.INSUFFICIENT_PAYER_BALANCE);
        }
    }

    private void createPendingAirdropsForNFTs(@NonNull List<NftTransfer> nftLists, @NonNull TokenID tokenId, @NonNull WritableAirdropStore pendingStore, @NonNull AccountID senderId, @NonNull WritableAccountStore accountStore, @NonNull TokenAirdropStreamBuilder recordBuilder) {
        nftLists.forEach(item -> {
            Account senderAccount = Objects.requireNonNull(accountStore.getAliasedAccountById(senderId));
            Account receiverAccount = Objects.requireNonNull(accountStore.getAliasedAccountById(item.receiverAccountIDOrThrow()));
            PendingAirdropId pendingId = AirdropHandlerHelper.createNftPendingAirdropId(tokenId, item.serialNumber(), senderAccount, receiverAccount);
            HandleException.validateTrue((!pendingStore.exists(pendingId) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.PENDING_NFT_AIRDROP_ALREADY_EXISTS);
            this.updateNewPendingAirdrop(senderAccount, pendingId, null, accountStore, pendingStore);
            PendingAirdropRecord pendingAirdropRecord = AirdropHandlerHelper.createPendingAirdropRecord(pendingId, null);
            recordBuilder.addPendingAirdrop(pendingAirdropRecord);
        });
    }

    private void addTransfersToTransferList(@NonNull List<AccountAmount> fungibleAmounts, @NonNull AccountID sender, boolean isApproval, @NonNull TokenTransferList.Builder transferListBuilder) {
        LinkedList<AccountAmount> amounts = new LinkedList<AccountAmount>();
        List<AccountAmount> receiversAmountList = fungibleAmounts.stream().filter(item -> item.amount() > 0L).toList();
        long senderAmount = receiversAmountList.stream().mapToLong(AccountAmount::amount).sum();
        AccountAmount newSenderAccountAmount = CryptoTransferHelper.createAccountAmount(sender, -senderAmount, isApproval);
        amounts.add(newSenderAccountAmount);
        amounts.addAll(receiversAmountList);
        transferListBuilder.transfers(amounts);
    }

    private void createPendingAirdropsForFungible(@NonNull List<AccountAmount> fungibleAmounts, @NonNull TokenID tokenId, @NonNull AccountID senderId, @NonNull WritableAccountStore accountStore, @NonNull WritableAirdropStore pendingStore, @NonNull TokenAirdropStreamBuilder recordBuilder) {
        fungibleAmounts.forEach(accountAmount -> {
            Account senderAccount = Objects.requireNonNull(accountStore.getAliasedAccountById(senderId));
            Account receiverAccount = Objects.requireNonNull(accountStore.getAliasedAccountById(accountAmount.accountIDOrThrow()));
            PendingAirdropId pendingId = AirdropHandlerHelper.createFungibleTokenPendingAirdropId(tokenId, senderAccount, receiverAccount);
            PendingAirdropValue pendingValue = PendingAirdropValue.newBuilder().amount(accountAmount.amount()).build();
            this.updateNewPendingAirdrop(senderAccount, pendingId, pendingValue, accountStore, pendingStore);
            PendingAirdropRecord pendingAirdropRecord = AirdropHandlerHelper.createPendingAirdropRecord(pendingId, Objects.requireNonNull(pendingStore.get(pendingId)).pendingAirdropValue());
            recordBuilder.addPendingAirdrop(pendingAirdropRecord);
        });
    }

    private CryptoTransferTransactionBody assessAndChargeCustomFee(@NonNull HandleContext context, @NonNull CryptoTransferTransactionBody body) {
        TransactionBody syntheticCryptoTransferTxn = TransactionBody.newBuilder().cryptoTransfer(body).build();
        TransferContextImpl transferContext = new TransferContextImpl(context, body, true);
        return this.chargeCustomFeeForAirdrops(syntheticCryptoTransferTxn, transferContext);
    }

    private void updateNewPendingAirdrop(@NonNull Account senderAccount, @NonNull PendingAirdropId pendingId, @Nullable PendingAirdropValue pendingValue, @NonNull WritableAccountStore accountStore, @NonNull WritableAirdropStore pendingStore) {
        if (pendingStore.contains(pendingId)) {
            this.update(pendingId, AirdropHandlerHelper.createFirstAccountPendingAirdrop(pendingValue), pendingStore);
        } else {
            AccountPendingAirdrop newHeadAirdrop;
            if (senderAccount.hasHeadPendingAirdropId()) {
                PendingAirdropId currentHeadAirdropId = senderAccount.headPendingAirdropIdOrThrow();
                AccountPendingAirdrop currentHeadAirdrop = pendingStore.get(currentHeadAirdropId);
                if (currentHeadAirdrop == null) {
                    log.error("Head pending airdrop {} not found for account {}", (Object)currentHeadAirdropId, (Object)senderAccount.accountId());
                    newHeadAirdrop = AirdropHandlerHelper.createFirstAccountPendingAirdrop(pendingValue);
                } else {
                    AccountPendingAirdrop updatedHeadAirdrop = currentHeadAirdrop.copyBuilder().previousAirdrop(pendingId).build();
                    pendingStore.put(currentHeadAirdropId, updatedHeadAirdrop);
                    newHeadAirdrop = AirdropHandlerHelper.createAccountPendingAirdrop(pendingValue, currentHeadAirdropId);
                }
            } else {
                newHeadAirdrop = AirdropHandlerHelper.createFirstAccountPendingAirdrop(pendingValue);
            }
            long numPendingAirdrops = senderAccount.numberPendingAirdrops();
            Account updatedSenderAccount = senderAccount.copyBuilder().headPendingAirdropId(pendingId).numberPendingAirdrops(numPendingAirdrops + 1L).build();
            accountStore.put(updatedSenderAccount);
            pendingStore.putAndIncrementCount(pendingId, newHeadAirdrop);
        }
    }

    private long airdropFeeForPendingAirdrop(@NonNull HandleContext feeContext) {
        return this.airdropFeeForPendingAirdrop(feeContext, true);
    }

    private long airdropFeeForPendingAirdrop(@NonNull HandleContext feeContext, boolean includeAssociationFee) {
        long airdropFee = this.airdropFee(feeContext);
        if (includeAssociationFee) {
            long associationFee = AssociateTokenRecipientsStep.associationFeeFor(feeContext, AssociateTokenRecipientsStep.PLACEHOLDER_SYNTHETIC_ASSOCIATION);
            airdropFee += associationFee;
        }
        return airdropFee;
    }

    private long airdropFee(HandleContext feeContext) {
        return ((FeeContext)feeContext).feeCalculatorFactory().feeCalculator(SubType.DEFAULT).calculate().totalFee();
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        TokenAirdropTransactionBody op = feeContext.body().tokenAirdropOrThrow();
        TokensConfig tokensConfig = (TokensConfig)feeContext.configuration().getConfigData(TokensConfig.class);
        HandleException.validateTrue((boolean)tokensConfig.airdropsEnabled(), (ResponseCodeEnum)ResponseCodeEnum.NOT_SUPPORTED);
        return this.calculateCryptoTransferFees(feeContext, op.tokenTransfers());
    }

    private Fees calculateCryptoTransferFees(@NonNull FeeContext feeContext, @NonNull List<TokenTransferList> tokenTransfers) {
        CryptoTransferTransactionBody cryptoTransferBody = CryptoTransferTransactionBody.newBuilder().tokenTransfers(tokenTransfers).build();
        TransactionBody syntheticCryptoTransferTxn = TransactionBody.newBuilder().cryptoTransfer(cryptoTransferBody).transactionID(feeContext.body().transactionID()).build();
        return feeContext.dispatchComputeFees(syntheticCryptoTransferTxn, feeContext.payer());
    }

    private int countExistingPendingAirdrops(AccountID senderId, List<AccountAmount> fungibleAmounts, TokenID tokenId, ReadableAirdropStore pendingStore) {
        return Math.toIntExact(fungibleAmounts.stream().map(accountAmount -> AirdropHandlerHelper.createFungibleTokenPendingAirdropId(tokenId, senderId, accountAmount.accountIDOrThrow())).filter(arg_0 -> ((ReadableAirdropStore)pendingStore).exists(arg_0)).count());
    }

    public void update(@NonNull PendingAirdropId airdropId, @NonNull AccountPendingAirdrop accountAirdrop, @NonNull WritableAirdropStore airdropState) {
        Objects.requireNonNull(airdropId);
        Objects.requireNonNull(accountAirdrop);
        Objects.requireNonNull(airdropState);
        if (airdropId.hasFungibleTokenType()) {
            long newValue;
            AccountPendingAirdrop existingAirdrop = Objects.requireNonNull(airdropState.get(airdropId));
            PendingAirdropValue existingValue = existingAirdrop.pendingAirdropValue();
            try {
                newValue = Math.addExact(Objects.requireNonNull(accountAirdrop.pendingAirdropValue()).amount(), Objects.requireNonNull(existingValue).amount());
            }
            catch (ArithmeticException e) {
                throw new HandleException(ResponseCodeEnum.INSUFFICIENT_TOKEN_BALANCE);
            }
            AccountPendingAirdrop newAccountAirdrop = existingAirdrop.copyBuilder().pendingAirdropValue(existingValue.copyBuilder().amount(newValue).build()).build();
            airdropState.put(airdropId, newAccountAirdrop);
        }
    }
}

