/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.node.app.service.contract.impl.exec.failure.CustomExceptionalHaltReason;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HederaSystemContract;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractNativeSystemContract;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallFactory;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;

@Singleton
public class HtsSystemContract
extends AbstractNativeSystemContract
implements HederaSystemContract {
    public static final String HTS_SYSTEM_CONTRACT_NAME = "HTS";
    public static final String HTS_167_EVM_ADDRESS = "0x167";
    public static final String HTS_16C_EVM_ADDRESS = "0x16C";
    public static final ContractID HTS_167_CONTRACT_ID = ContractID.newBuilder().contractNum(ConversionUtils.numberOfLongZero(Address.fromHexString((String)"0x167"))).build();
    public static final ContractID HTS_16C_CONTRACT_ID = ContractID.newBuilder().contractNum(ConversionUtils.numberOfLongZero(Address.fromHexString((String)"0x16C"))).build();

    @Inject
    public HtsSystemContract(@NonNull GasCalculator gasCalculator, @NonNull HtsCallFactory callFactory, @NonNull ContractMetrics contractMetrics) {
        super(HTS_SYSTEM_CONTRACT_NAME, callFactory, gasCalculator, contractMetrics);
    }

    @Override
    protected FrameUtils.CallType callTypeOf(@NonNull MessageFrame frame) {
        return FrameUtils.callTypeOf(frame, FrameUtils.EntityType.TOKEN);
    }

    @Override
    public FullResult computeFully(@NonNull ContractID contractID, @NonNull Bytes input, @NonNull MessageFrame frame) {
        if (!FrameUtils.contractsConfigOf(frame).callableHTSAddresses().contains(contractID.contractNum())) {
            return FullResult.haltResult(CustomExceptionalHaltReason.NOT_SUPPORTED, frame.getRemainingGas());
        }
        return super.computeFully(contractID, input, frame);
    }
}

