/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.infra;

import com.esaulpaugh.headlong.util.Integers;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.contract.ContractCallTransactionBody;
import com.hedera.hapi.node.contract.ContractCreateTransactionBody;
import com.hedera.hapi.node.contract.EthereumTransactionBody;
import com.hedera.hapi.node.state.file.File;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.ethereum.EthTxData;
import com.hedera.node.app.hapi.utils.ethereum.EthTxSigs;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.service.contract.impl.annotations.InitialState;
import com.hedera.node.app.service.contract.impl.annotations.TransactionScope;
import com.hedera.node.app.service.contract.impl.exec.FeatureFlags;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmContext;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmTransaction;
import com.hedera.node.app.service.contract.impl.hevm.HydratedEthTxData;
import com.hedera.node.app.service.contract.impl.infra.EthTxSigsCache;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.contract.impl.utils.SynthTxnUtils;
import com.hedera.node.app.service.contract.impl.utils.ValidationUtils;
import com.hedera.node.app.service.file.ReadableFileStore;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.api.TokenServiceApi;
import com.hedera.node.app.spi.ids.EntityIdFactory;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.spi.validation.AttributeValidator;
import com.hedera.node.app.spi.validation.ExpiryMeta;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.ContractsConfig;
import com.hedera.node.config.data.EntitiesConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.LedgerConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;

@TransactionScope
public class HevmTransactionFactory {
    private final NetworkInfo networkInfo;
    private final LedgerConfig ledgerConfig;
    private final HederaConfig hederaConfig;
    private final FeatureFlags featureFlags;
    private final GasCalculator gasCalculator;
    private final ContractsConfig contractsConfig;
    private final EntitiesConfig entitiesConfig;
    private final ReadableFileStore fileStore;
    private final TokenServiceApi tokenServiceApi;
    private final ReadableAccountStore accountStore;
    private final ExpiryValidator expiryValidator;
    private final AttributeValidator attributeValidator;
    private final HydratedEthTxData hydratedEthTxData;
    private final EthTxSigsCache ethereumSignatures;
    private final HederaEvmContext hederaEvmContext;
    private final EntityIdFactory entityIdFactory;

    @Inject
    public HevmTransactionFactory(@NonNull NetworkInfo networkInfo, @NonNull LedgerConfig ledgerConfig, @NonNull HederaConfig hederaConfig, @NonNull FeatureFlags featureFlags, @NonNull GasCalculator gasCalculator, @NonNull ContractsConfig contractsConfig, @NonNull EntitiesConfig entitiesConfig, @Nullable HydratedEthTxData hydratedEthTxData, @InitialState @NonNull ReadableAccountStore accountStore, @NonNull ExpiryValidator expiryValidator, @InitialState @NonNull ReadableFileStore fileStore, @NonNull AttributeValidator attributeValidator, @InitialState @NonNull TokenServiceApi tokenServiceApi, @NonNull EthTxSigsCache ethereumSignatures, @NonNull HederaEvmContext hederaEvmContext, @NonNull EntityIdFactory entityIdFactory) {
        this.featureFlags = featureFlags;
        this.hydratedEthTxData = hydratedEthTxData;
        this.gasCalculator = Objects.requireNonNull(gasCalculator);
        this.fileStore = Objects.requireNonNull(fileStore);
        this.networkInfo = Objects.requireNonNull(networkInfo);
        this.accountStore = Objects.requireNonNull(accountStore);
        this.ledgerConfig = Objects.requireNonNull(ledgerConfig);
        this.hederaConfig = Objects.requireNonNull(hederaConfig);
        this.contractsConfig = Objects.requireNonNull(contractsConfig);
        this.entitiesConfig = Objects.requireNonNull(entitiesConfig);
        this.tokenServiceApi = Objects.requireNonNull(tokenServiceApi);
        this.expiryValidator = Objects.requireNonNull(expiryValidator);
        this.attributeValidator = Objects.requireNonNull(attributeValidator);
        this.ethereumSignatures = Objects.requireNonNull(ethereumSignatures);
        this.hederaEvmContext = Objects.requireNonNull(hederaEvmContext);
        this.entityIdFactory = Objects.requireNonNull(entityIdFactory);
    }

    public HederaEvmTransaction fromHapiTransaction(@NonNull TransactionBody body, @NonNull AccountID payerId) {
        return switch ((TransactionBody.DataOneOfType)body.data().kind()) {
            case TransactionBody.DataOneOfType.CONTRACT_CREATE_INSTANCE -> this.fromHapiCreate(payerId, body.contractCreateInstanceOrThrow());
            case TransactionBody.DataOneOfType.CONTRACT_CALL -> this.fromHapiCall(payerId, body.contractCallOrThrow());
            case TransactionBody.DataOneOfType.ETHEREUM_TRANSACTION -> this.fromHapiEthereum(payerId, body.ethereumTransactionOrThrow());
            default -> throw new IllegalArgumentException("Not a contract operation");
        };
    }

    private HederaEvmTransaction fromHapiCreate(@NonNull AccountID payer, @NonNull ContractCreateTransactionBody body) {
        this.assertValidCreation(body);
        com.hedera.pbj.runtime.io.buffer.Bytes payload = this.initcodeFor(body);
        return new HederaEvmTransaction(payer, null, null, -1L, payload, null, body.initialBalance(), body.gas(), -1L, -1L, body, null);
    }

    private HederaEvmTransaction fromHapiCall(@NonNull AccountID payer, @NonNull ContractCallTransactionBody body) {
        this.assertValidCall(body);
        return new HederaEvmTransaction(payer, null, ConversionUtils.asPriorityId(body.contractIDOrThrow(), this.accountStore), -1L, body.functionParameters(), null, body.amount(), body.gas(), -1L, -1L, null, null);
    }

    private HederaEvmTransaction fromHapiEthereum(@NonNull AccountID payerId, @NonNull EthereumTransactionBody body) {
        EthTxData ethTxData = this.assertValidEthTx(body);
        AccountID senderId = this.asAliasedSender(ethTxData);
        return ethTxData.hasToAddress() ? this.fromEthTxCall(payerId, senderId, ethTxData, body.maxGasAllowance()) : this.fromEthTxCreate(payerId, senderId, ethTxData, body.maxGasAllowance());
    }

    @NonNull
    private HederaEvmTransaction fromEthTxCall(@NonNull AccountID relayerId, @NonNull AccountID senderId, @NonNull EthTxData ethTxData, long maxGasAllowance) {
        HandleException.validateTrue((ethTxData.getAmount() >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CONTRACT_NEGATIVE_VALUE);
        return new HederaEvmTransaction(senderId, relayerId, ConversionUtils.asPriorityId(this.entityIdFactory.newContractIdWithEvmAddress(com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])ethTxData.to())), this.accountStore), ethTxData.nonce(), ethTxData.hasCallData() ? com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])ethTxData.callData()) : com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY, com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])ethTxData.chainId()), ethTxData.effectiveTinybarValue(), ethTxData.gasLimit(), ethTxData.effectiveOfferedGasPriceInTinybars(this.hederaEvmContext.gasPrice()), maxGasAllowance, null, null);
    }

    @NonNull
    private HederaEvmTransaction fromEthTxCreate(@NonNull AccountID relayerId, @NonNull AccountID senderId, @NonNull EthTxData ethTxData, long maxGasAllowance) {
        return new HederaEvmTransaction(senderId, relayerId, null, ethTxData.nonce(), com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])ethTxData.callData()), com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])ethTxData.chainId()), ethTxData.effectiveTinybarValue(), ethTxData.gasLimit(), ethTxData.effectiveOfferedGasPriceInTinybars(this.hederaEvmContext.gasPrice()), maxGasAllowance, SynthTxnUtils.synthEthTxCreation(this.ledgerConfig.autoRenewPeriodMinDuration(), ethTxData), null);
    }

    public HederaEvmTransaction fromContractTxException(@NonNull TransactionBody body, @NonNull HandleException exception) {
        AccountID sender = null;
        AccountID relayer = null;
        long gasPrice = switch ((TransactionBody.DataOneOfType)body.data().kind()) {
            case TransactionBody.DataOneOfType.CONTRACT_CREATE_INSTANCE -> body.contractCreateInstanceOrThrow().gas();
            case TransactionBody.DataOneOfType.CONTRACT_CALL -> body.contractCallOrThrow().gas();
            case TransactionBody.DataOneOfType.ETHEREUM_TRANSACTION -> {
                EthTxData ethTxData = this.assertValidEthTx(body.ethereumTransactionOrThrow());
                sender = this.asAliasedSender(ethTxData);
                relayer = body.transactionID().accountID();
                yield ethTxData.gasLimit();
            }
            default -> throw new IllegalArgumentException("Not a contract operation");
        };
        return new HederaEvmTransaction(sender == null ? AccountID.DEFAULT : sender, relayer, null, -1L, com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY, null, 0L, gasPrice, -1L, -1L, null, exception);
    }

    @NonNull
    private EthTxData assertValidEthTx(@NonNull EthereumTransactionBody body) {
        HandleException.validateTrue((body.maxGasAllowance() >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.NEGATIVE_ALLOWANCE_AMOUNT);
        if (!Objects.requireNonNull(this.hydratedEthTxData).isAvailable()) {
            throw new HandleException(this.hydratedEthTxData.status());
        }
        EthTxData ethTxData = Objects.requireNonNull(this.hydratedEthTxData.ethTxData());
        HandleException.validateTrue((boolean)ethTxData.matchesChainId(Integers.toBytes((int)this.contractsConfig.chainId())), (ResponseCodeEnum)ResponseCodeEnum.WRONG_CHAIN_ID);
        HandleException.validateTrue((ethTxData.hasToAddress() || ethTxData.hasCallData() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ETHEREUM_TRANSACTION);
        return ethTxData;
    }

    private void assertValidCall(@NonNull ContractCallTransactionBody body) {
        long minGasLimit = Math.max(21000L, this.gasCalculator.transactionIntrinsicGasCost(Bytes.EMPTY, false, 0L));
        HandleException.validateTrue((body.gas() >= minGasLimit ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_GAS);
        HandleException.validateTrue((body.amount() >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CONTRACT_NEGATIVE_VALUE);
        HandleException.validateTrue((body.gas() <= ValidationUtils.getMaxGasLimit(this.contractsConfig) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_GAS_LIMIT_EXCEEDED);
        Account contract = this.accountStore.getContractById(body.contractIDOrThrow());
        if (contract != null) {
            Long contractNum = contract.accountIdOrThrow().accountNumOrThrow();
            boolean mayNotExist = this.featureFlags.isAllowCallsToNonContractAccountsEnabled(this.contractsConfig, contractNum);
            HandleException.validateTrue((mayNotExist || !contract.deleted() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CONTRACT_DELETED);
        }
    }

    private void assertValidCreation(@NonNull ContractCreateTransactionBody body) {
        long autoRenewPeriod;
        if (body.hasFileID()) {
            HandleException.validateTrue((body.fileIDOrThrow().fileNum() >= this.hederaConfig.firstUserEntity() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_FILE_ID);
        }
        HandleException.validateTrue(((autoRenewPeriod = body.autoRenewPeriodOrElse(Duration.DEFAULT).seconds()) >= 1L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_RENEWAL_PERIOD);
        this.attributeValidator.validateAutoRenewPeriod(autoRenewPeriod);
        HandleException.validateTrue((body.gas() >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CONTRACT_NEGATIVE_GAS);
        HandleException.validateTrue((body.initialBalance() >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CONTRACT_NEGATIVE_VALUE);
        HandleException.validateTrue((body.gas() <= ValidationUtils.getMaxGasLimit(this.contractsConfig) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_GAS_LIMIT_EXCEEDED);
        boolean usesInvalidAutoAssociations = body.maxAutomaticTokenAssociations() < -1 && this.entitiesConfig.unlimitedAutoAssociationsEnabled();
        HandleException.validateFalse((boolean)usesInvalidAutoAssociations, (ResponseCodeEnum)ResponseCodeEnum.INVALID_MAX_AUTO_ASSOCIATIONS);
        HandleException.validateTrue((body.maxAutomaticTokenAssociations() <= this.ledgerConfig.maxAutoAssociations() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.REQUESTED_NUM_AUTOMATIC_ASSOCIATIONS_EXCEEDS_ASSOCIATION_LIMIT);
        boolean usesNonDefaultProxyId = body.hasProxyAccountID() && !AccountID.DEFAULT.equals((Object)body.proxyAccountID());
        HandleException.validateFalse((boolean)usesNonDefaultProxyId, (ResponseCodeEnum)ResponseCodeEnum.PROXY_ACCOUNT_ID_FIELD_IS_DEPRECATED);
        this.tokenServiceApi.assertValidStakingElectionForCreation(body.declineReward(), ((ContractCreateTransactionBody.StakedIdOneOfType)body.stakedId().kind()).name(), body.stakedAccountId(), body.stakedNodeId(), this.accountStore, this.networkInfo);
        this.attributeValidator.validateMemo(body.memo());
        Key effectiveKey = body.adminKeyOrElse(Key.DEFAULT);
        if (!KeyUtils.isEmpty((Key)effectiveKey)) {
            try {
                this.attributeValidator.validateKey(body.adminKeyOrElse(Key.DEFAULT));
            }
            catch (HandleException | NullPointerException ignore) {
                throw new HandleException(ResponseCodeEnum.SERIALIZATION_FAILED);
            }
        }
        this.expiryValidator.resolveCreationAttempt(true, new ExpiryMeta(ExpiryMeta.NA, autoRenewPeriod, body.hasAutoRenewAccountId() ? body.autoRenewAccountIdOrThrow() : null), HederaFunctionality.CONTRACT_CREATE);
    }

    private com.hedera.pbj.runtime.io.buffer.Bytes initcodeFor(@NonNull ContractCreateTransactionBody body) {
        if (body.hasInitcode()) {
            HandleException.validateTrue((body.initcode().length() > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CONTRACT_BYTECODE_EMPTY);
            return body.initcode();
        }
        File initcode = this.fileStore.getFileLeaf(body.fileIDOrElse(FileID.DEFAULT));
        HandleException.validateFalse((initcode == null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_FILE_ID);
        HandleException.validateFalse((boolean)initcode.deleted(), (ResponseCodeEnum)ResponseCodeEnum.FILE_DELETED);
        HandleException.validateTrue((initcode.contents().length() > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CONTRACT_FILE_EMPTY);
        try {
            String hexedInitcode = new String(ConversionUtils.removeIfAnyLeading0x(initcode.contents()));
            return com.hedera.pbj.runtime.io.buffer.Bytes.fromHex((String)(hexedInitcode + body.constructorParameters().toHex()));
        }
        catch (IllegalArgumentException | NullPointerException ignore) {
            throw new HandleException(ResponseCodeEnum.ERROR_DECODING_BYTESTRING);
        }
    }

    private AccountID asAliasedSender(@NonNull EthTxData txData) {
        EthTxSigs txSign = this.ethereumSignatures.computeIfAbsent(txData);
        return AccountID.newBuilder().alias(com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])txSign.address())).build();
    }
}

