/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.utils;

import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.base.SignaturePair;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;

public class SignatureMapUtils {
    private SignatureMapUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static SignatureMap preprocessEcdsaSignatures(@NonNull SignatureMap sigMap, int chainId) {
        ArrayList<SignaturePair> newPairs = new ArrayList<SignaturePair>();
        for (SignaturePair spair : sigMap.sigPair()) {
            Bytes ecSig;
            if (spair.hasEcdsaSecp256k1() && (ecSig = Objects.requireNonNull(spair.ecdsaSecp256k1())).length() > 64L) {
                if (!SignatureMapUtils.validChainId(ecSig.toByteArray(), chainId)) {
                    throw new IllegalArgumentException("v value in ECDSA signature does not match chain ID");
                }
                spair = new SignaturePair(spair.pubKeyPrefix(), new OneOf((Enum)SignaturePair.SignatureOneOfType.ECDSA_SECP256K1, (Object)ecSig.slice(0L, 64L)));
            }
            newPairs.add(spair);
        }
        return new SignatureMap(newPairs);
    }

    public static boolean validChainId(byte[] ecSig, long chainId) {
        if (ecSig.length <= 64) {
            throw new IllegalArgumentException("signature needs to be at least 65 bytes");
        }
        try {
            long v = new BigInteger(1, ecSig, 64, ecSig.length - 64).longValueExact();
            if (v >= 35L) {
                long chainIdParityZero = 35L + chainId * 2L;
                return v == chainIdParityZero || v == chainIdParityZero + 1L;
            }
            return true;
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("EIP-155 encoded chain id too large (longer than long)");
        }
    }

    @NonNull
    public static SignatureMap stripRecoveryIdFromEcdsaSignatures(@NonNull SignatureMap sigMap) {
        ArrayList<SignaturePair> newPairs = new ArrayList<SignaturePair>();
        for (SignaturePair spair : sigMap.sigPair()) {
            Bytes ecSig;
            if (spair.hasEcdsaSecp256k1() && (ecSig = Objects.requireNonNull(spair.ecdsaSecp256k1())).length() > 64L) {
                spair = new SignaturePair(spair.pubKeyPrefix(), new OneOf((Enum)SignaturePair.SignatureOneOfType.ECDSA_SECP256K1, (Object)ecSig.slice(0L, 64L)));
            }
            newPairs.add(spair);
        }
        return new SignatureMap(newPairs);
    }
}

