/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.precompile;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.hyperledger.besu.crypto.altbn128.AbstractFieldPoint;
import org.hyperledger.besu.crypto.altbn128.AltBn128Point;
import org.hyperledger.besu.crypto.altbn128.Fq;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.precompile.AbstractAltBnPrecompiledContract;
import org.hyperledger.besu.evm.precompile.PrecompiledContract;

public class AltBN128AddPrecompiledContract
extends AbstractAltBnPrecompiledContract {
    private static final int PARAMETER_LENGTH = 128;
    private final long gasCost;

    private AltBN128AddPrecompiledContract(GasCalculator gasCalculator, long gasCost) {
        super("AltBN128Add", gasCalculator, (byte)1, 128);
        this.gasCost = gasCost;
    }

    public static AltBN128AddPrecompiledContract byzantium(GasCalculator gasCalculator) {
        return new AltBN128AddPrecompiledContract(gasCalculator, 500L);
    }

    public static AltBN128AddPrecompiledContract istanbul(GasCalculator gasCalculator) {
        return new AltBN128AddPrecompiledContract(gasCalculator, 150L);
    }

    @Override
    public long gasRequirement(Bytes input) {
        return this.gasCost;
    }

    @Override
    @Nonnull
    public PrecompiledContract.PrecompileContractResult computePrecompile(Bytes input, @Nonnull MessageFrame messageFrame) {
        if (useNative) {
            return this.computeNative(input, messageFrame);
        }
        return AltBN128AddPrecompiledContract.computeDefault(input);
    }

    private static PrecompiledContract.PrecompileContractResult computeDefault(Bytes input) {
        BigInteger x1 = AltBN128AddPrecompiledContract.extractParameter(input, 0, 32);
        BigInteger y1 = AltBN128AddPrecompiledContract.extractParameter(input, 32, 32);
        BigInteger x2 = AltBN128AddPrecompiledContract.extractParameter(input, 64, 32);
        BigInteger y2 = AltBN128AddPrecompiledContract.extractParameter(input, 96, 32);
        AltBn128Point p1 = new AltBn128Point(Fq.create((BigInteger)x1), Fq.create((BigInteger)y1));
        AltBn128Point p2 = new AltBn128Point(Fq.create((BigInteger)x2), Fq.create((BigInteger)y2));
        if (!p1.isOnCurve() || !p2.isOnCurve()) {
            return PrecompiledContract.PrecompileContractResult.halt(null, Optional.of(ExceptionalHaltReason.PRECOMPILE_ERROR));
        }
        AltBn128Point sum = (AltBn128Point)p1.add((AbstractFieldPoint)p2);
        Bytes x = sum.getX().toBytes();
        Bytes y = sum.getY().toBytes();
        MutableBytes result = MutableBytes.create((int)64);
        x.copyTo(result, 32 - x.size());
        y.copyTo(result, 64 - y.size());
        return PrecompiledContract.PrecompileContractResult.success(result.copy());
    }

    private static BigInteger extractParameter(Bytes input, int offset, int length) {
        if (offset > input.size() || length == 0) {
            return BigInteger.ZERO;
        }
        byte[] raw = Arrays.copyOfRange(input.toArray(), offset, offset + length);
        return new BigInteger(1, raw);
    }
}

