/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.record;

import com.hedera.hapi.block.stream.output.StateChange;
import com.hedera.hapi.block.stream.trace.ContractSlotUsage;
import com.hedera.hapi.block.stream.trace.EvmTransactionLog;
import com.hedera.hapi.block.stream.trace.ExecutedInitcode;
import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenAssociation;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.contract.ContractNonceInfo;
import com.hedera.hapi.node.contract.EvmTransactionResult;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.hapi.node.transaction.ExchangeRateSet;
import com.hedera.hapi.node.transaction.PendingAirdropRecord;
import com.hedera.hapi.node.transaction.SignedTransaction;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.node.transaction.TransactionReceipt;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.hapi.streams.ContractAction;
import com.hedera.hapi.streams.ContractActions;
import com.hedera.hapi.streams.ContractBytecode;
import com.hedera.hapi.streams.ContractStateChanges;
import com.hedera.hapi.streams.TransactionSidecarRecord;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.service.addressbook.impl.records.NodeCreateStreamBuilder;
import com.hedera.node.app.service.consensus.impl.records.ConsensusCreateTopicStreamBuilder;
import com.hedera.node.app.service.consensus.impl.records.ConsensusSubmitMessageStreamBuilder;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.node.app.service.contract.impl.records.ContractCreateStreamBuilder;
import com.hedera.node.app.service.contract.impl.records.ContractDeleteStreamBuilder;
import com.hedera.node.app.service.contract.impl.records.ContractOperationStreamBuilder;
import com.hedera.node.app.service.contract.impl.records.ContractUpdateStreamBuilder;
import com.hedera.node.app.service.contract.impl.records.EthereumTransactionStreamBuilder;
import com.hedera.node.app.service.file.impl.records.CreateFileStreamBuilder;
import com.hedera.node.app.service.schedule.ScheduleStreamBuilder;
import com.hedera.node.app.service.token.api.FeeStreamBuilder;
import com.hedera.node.app.service.token.impl.comparator.TokenComparators;
import com.hedera.node.app.service.token.records.ChildStreamBuilder;
import com.hedera.node.app.service.token.records.CryptoCreateStreamBuilder;
import com.hedera.node.app.service.token.records.CryptoDeleteStreamBuilder;
import com.hedera.node.app.service.token.records.CryptoTransferStreamBuilder;
import com.hedera.node.app.service.token.records.CryptoUpdateStreamBuilder;
import com.hedera.node.app.service.token.records.GenesisAccountStreamBuilder;
import com.hedera.node.app.service.token.records.HookDispatchStreamBuilder;
import com.hedera.node.app.service.token.records.NodeStakeUpdateStreamBuilder;
import com.hedera.node.app.service.token.records.TokenAccountWipeStreamBuilder;
import com.hedera.node.app.service.token.records.TokenAirdropStreamBuilder;
import com.hedera.node.app.service.token.records.TokenBurnStreamBuilder;
import com.hedera.node.app.service.token.records.TokenCreateStreamBuilder;
import com.hedera.node.app.service.token.records.TokenMintStreamBuilder;
import com.hedera.node.app.service.token.records.TokenUpdateStreamBuilder;
import com.hedera.node.app.service.util.impl.records.PrngStreamBuilder;
import com.hedera.node.app.service.util.impl.records.ReplayableFeeStreamBuilder;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.app.state.SingleTransactionRecord;
import com.hedera.node.app.state.logging.TransactionStateLogger;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.hiero.base.crypto.DigestType;

public class RecordStreamBuilder
implements StreamBuilder,
ConsensusCreateTopicStreamBuilder,
ConsensusSubmitMessageStreamBuilder,
CreateFileStreamBuilder,
CryptoCreateStreamBuilder,
CryptoTransferStreamBuilder,
ChildStreamBuilder,
PrngStreamBuilder,
ScheduleStreamBuilder,
TokenMintStreamBuilder,
TokenBurnStreamBuilder,
TokenCreateStreamBuilder,
ContractCreateStreamBuilder,
ContractCallStreamBuilder,
ContractUpdateStreamBuilder,
EthereumTransactionStreamBuilder,
CryptoDeleteStreamBuilder,
TokenUpdateStreamBuilder,
NodeStakeUpdateStreamBuilder,
FeeStreamBuilder,
ContractDeleteStreamBuilder,
GenesisAccountStreamBuilder,
ContractOperationStreamBuilder,
TokenAccountWipeStreamBuilder,
CryptoUpdateStreamBuilder,
NodeCreateStreamBuilder,
TokenAirdropStreamBuilder,
ReplayableFeeStreamBuilder,
HookDispatchStreamBuilder {
    private static final Comparator<TokenAssociation> TOKEN_ASSOCIATION_COMPARATOR = Comparator.comparingLong(a -> a.tokenId().tokenNum()).thenComparingLong(a -> a.accountIdOrThrow().accountNum());
    private static final Comparator<PendingAirdropRecord> PENDING_AIRDROP_RECORD_COMPARATOR = Comparator.comparing(PendingAirdropRecord::pendingAirdropIdOrThrow, TokenComparators.PENDING_AIRDROP_ID_COMPARATOR);
    private SignedTransaction signedTx;
    @Nullable
    private Bytes serializedSignedTx = null;
    private Instant consensusNow;
    private Instant parentConsensus;
    private TransactionID transactionID;
    private List<TokenTransferList> tokenTransferLists = new LinkedList<TokenTransferList>();
    private List<AssessedCustomFee> assessedCustomFees = new LinkedList<AssessedCustomFee>();
    private List<PendingAirdropRecord> pendingAirdropRecords = new LinkedList<PendingAirdropRecord>();
    private List<TokenAssociation> automaticTokenAssociations = new LinkedList<TokenAssociation>();
    private List<AccountAmount> paidStakingRewards = new LinkedList<AccountAmount>();
    private final TransactionRecord.Builder transactionRecordBuilder = TransactionRecord.newBuilder();
    private TransferList transferList = TransferList.DEFAULT;
    private ResponseCodeEnum status = ResponseCodeEnum.OK;
    private ExchangeRateSet exchangeRate = ExchangeRateSet.DEFAULT;
    private List<Long> serialNumbers = new LinkedList<Long>();
    private long newTotalSupply = 0L;
    private final TransactionReceipt.Builder transactionReceiptBuilder = TransactionReceipt.newBuilder();
    @Nullable
    private List<AbstractMap.SimpleEntry<ContractStateChanges, Boolean>> contractStateChanges;
    private List<AbstractMap.SimpleEntry<ContractActions, Boolean>> contractActions = new LinkedList<AbstractMap.SimpleEntry<ContractActions, Boolean>>();
    private List<AbstractMap.SimpleEntry<ContractBytecode, Boolean>> contractBytecodes = new LinkedList<AbstractMap.SimpleEntry<ContractBytecode, Boolean>>();
    private final Map<AccountID, AccountID> deletedAccountBeneficiaries = new HashMap<AccountID, AccountID>();
    @Nullable
    private Set<AccountID> explicitRewardReceiverIds;
    private long transactionFee;
    private ContractFunctionResult contractFunctionResult;
    private final StreamBuilder.ReversingBehavior reversingBehavior;
    private final HandleContext.TransactionCategory category;
    private final StreamBuilder.SignedTxCustomizer customizer;
    private TokenID tokenID;
    private ScheduleID scheduleID;
    private TokenType tokenType;
    private HederaFunctionality function;
    private boolean isContractCreate;
    private long opsDuration;
    private long nextHookId;

    public RecordStreamBuilder(@NonNull StreamBuilder.ReversingBehavior reversingBehavior, @NonNull StreamBuilder.SignedTxCustomizer customizer, @NonNull HandleContext.TransactionCategory category) {
        this.consensusNow = Instant.EPOCH;
        this.reversingBehavior = Objects.requireNonNull(reversingBehavior, "reversingBehavior must not be null");
        this.customizer = Objects.requireNonNull(customizer, "customizer must not be null");
        this.category = Objects.requireNonNull(category, "category must not be null");
    }

    public SingleTransactionRecord build() {
        Bytes transactionHash;
        Transaction transaction;
        if (this.customizer != StreamBuilder.SignedTxCustomizer.NOOP_SIGNED_TX_CUSTOMIZER) {
            this.signedTx = (SignedTransaction)this.customizer.apply((Object)this.signedTx);
            this.serializedSignedTx = SignedTransaction.PROTOBUF.toBytes((Object)this.signedTx);
        }
        TransactionReceipt.Builder builder = this.transactionReceiptBuilder.serialNumbers(this.serialNumbers);
        if (this.exchangeRate != null && this.exchangeRate.hasCurrentRate() && this.exchangeRate.hasNextRate()) {
            builder.exchangeRate(this.exchangeRate);
        }
        TransactionReceipt transactionReceipt = builder.build();
        try {
            MessageDigest digest = MessageDigest.getInstance(DigestType.SHA_384.algorithmName());
            if (this.signedTx.useSerializedTxMessageHashAlgorithm()) {
                transaction = Transaction.newBuilder().bodyBytes(this.signedTx.bodyBytes()).sigMap(this.signedTx.sigMap()).build();
                Bytes legacyBytes = Transaction.PROTOBUF.toBytes((Object)transaction);
                transactionHash = Bytes.wrap((byte[])digest.digest(legacyBytes.toByteArray()));
            } else {
                if (this.serializedSignedTx == null) {
                    this.serializedSignedTx = SignedTransaction.PROTOBUF.toBytes((Object)this.signedTx);
                }
                transaction = Transaction.newBuilder().signedTransactionBytes(this.serializedSignedTx).build();
                transactionHash = Bytes.wrap((byte[])digest.digest(this.serializedSignedTx.toByteArray()));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        Timestamp consensusTimestamp = HapiUtils.asTimestamp((Instant)this.consensusNow);
        Timestamp parentConsensusTimestamp = this.parentConsensus != null ? HapiUtils.asTimestamp((Instant)this.parentConsensus) : null;
        List<TokenAssociation> newAutomaticTokenAssociations = this.automaticTokenAssociations;
        if (!this.automaticTokenAssociations.isEmpty()) {
            newAutomaticTokenAssociations = new ArrayList<TokenAssociation>(this.automaticTokenAssociations);
            newAutomaticTokenAssociations.sort(TOKEN_ASSOCIATION_COMPARATOR);
        }
        List<PendingAirdropRecord> newPendingAirdropRecords = this.pendingAirdropRecords;
        if (!this.pendingAirdropRecords.isEmpty()) {
            newPendingAirdropRecords = new ArrayList<PendingAirdropRecord>(this.pendingAirdropRecords);
            newPendingAirdropRecords.sort(PENDING_AIRDROP_RECORD_COMPARATOR);
        }
        TransactionRecord transactionRecord = this.transactionRecordBuilder.transactionID(this.transactionID).receipt(transactionReceipt).transactionHash(transactionHash).consensusTimestamp(consensusTimestamp).parentConsensusTimestamp(parentConsensusTimestamp).transferList(this.transferList).tokenTransferLists(this.tokenTransferLists).newPendingAirdrops(newPendingAirdropRecords).assessedCustomFees(this.assessedCustomFees).automaticTokenAssociations(newAutomaticTokenAssociations).paidStakingRewards(this.paidStakingRewards).build();
        ArrayList<TransactionSidecarRecord> transactionSidecarRecords = new ArrayList<TransactionSidecarRecord>();
        if (this.contractStateChanges != null) {
            this.contractStateChanges.stream().map(pair -> new TransactionSidecarRecord(transactionRecord.consensusTimestamp(), ((Boolean)pair.getValue()).booleanValue(), new OneOf((Enum)TransactionSidecarRecord.SidecarRecordsOneOfType.STATE_CHANGES, pair.getKey()))).forEach(transactionSidecarRecords::add);
        }
        this.contractActions.stream().map(pair -> new TransactionSidecarRecord(transactionRecord.consensusTimestamp(), ((Boolean)pair.getValue()).booleanValue(), new OneOf((Enum)TransactionSidecarRecord.SidecarRecordsOneOfType.ACTIONS, pair.getKey()))).forEach(transactionSidecarRecords::add);
        this.contractBytecodes.stream().map(pair -> new TransactionSidecarRecord(transactionRecord.consensusTimestamp(), ((Boolean)pair.getValue()).booleanValue(), new OneOf((Enum)TransactionSidecarRecord.SidecarRecordsOneOfType.BYTECODE, pair.getKey()))).forEach(transactionSidecarRecords::add);
        TransactionStateLogger.logEndTransactionRecord(this.transactionID, transactionRecord);
        return new SingleTransactionRecord(transaction, transactionRecord, transactionSidecarRecords, new SingleTransactionRecord.TransactionOutputs(this.tokenType));
    }

    public void nullOutSideEffectFields() {
        this.serialNumbers.clear();
        this.tokenTransferLists.clear();
        this.pendingAirdropRecords.clear();
        this.automaticTokenAssociations.clear();
        this.transferList = TransferList.DEFAULT;
        this.paidStakingRewards.clear();
        this.assessedCustomFees.clear();
        this.newTotalSupply = 0L;
        this.transactionFee = 0L;
        if (this.contractFunctionResult != null) {
            ContractFunctionResult.Builder clearLogs = this.contractFunctionResult.copyBuilder().logInfo(Collections.emptyList()).bloom(Bytes.EMPTY);
            if (this.isContractCreate) {
                this.transactionRecordBuilder.contractCreateResult(clearLogs);
            } else {
                this.transactionRecordBuilder.contractCallResult(clearLogs);
            }
        }
        this.contractFunctionResult = null;
        this.transactionReceiptBuilder.accountID((AccountID)null);
        if (this.isContractCreate) {
            this.transactionReceiptBuilder.contractID((ContractID)null);
        }
        this.transactionReceiptBuilder.fileID((FileID)null);
        this.transactionReceiptBuilder.tokenID((TokenID)null);
        if (this.status != ResponseCodeEnum.IDENTICAL_SCHEDULE_ALREADY_CREATED) {
            this.transactionReceiptBuilder.scheduleID((ScheduleID)null);
            this.transactionReceiptBuilder.scheduledTransactionID((TransactionID)null);
        }
        this.transactionReceiptBuilder.topicRunningHash(Bytes.EMPTY);
        this.transactionReceiptBuilder.newTotalSupply(0L);
        this.transactionReceiptBuilder.topicRunningHashVersion(0L);
        this.transactionReceiptBuilder.topicSequenceNumber(0L);
        this.transactionRecordBuilder.alias(Bytes.EMPTY);
        this.transactionRecordBuilder.evmAddress(Bytes.EMPTY);
    }

    public StreamBuilder.ReversingBehavior reversingBehavior() {
        return this.reversingBehavior;
    }

    public RecordStreamBuilder parentConsensus(@NonNull Instant parentConsensus) {
        this.parentConsensus = Objects.requireNonNull(parentConsensus, "parentConsensus must not be null");
        return this;
    }

    public RecordStreamBuilder consensusTimestamp(@NonNull Instant now) {
        this.consensusNow = Objects.requireNonNull(now, "consensus time must not be null");
        return this;
    }

    @NonNull
    public RecordStreamBuilder signedTx(@NonNull SignedTransaction signedTx) {
        this.signedTx = Objects.requireNonNull(signedTx, "transaction must not be null");
        return this;
    }

    public RecordStreamBuilder serializedSignedTx(@Nullable Bytes serializedSignedTx) {
        this.serializedSignedTx = serializedSignedTx;
        return this;
    }

    public TransactionID transactionID() {
        return this.transactionID;
    }

    @NonNull
    public RecordStreamBuilder transactionID(@NonNull TransactionID transactionID) {
        this.transactionID = Objects.requireNonNull(transactionID, "transactionID must not be null");
        return this;
    }

    @NonNull
    public RecordStreamBuilder syncBodyIdFromRecordId() {
        TransactionID newTransactionID = this.transactionID;
        TransactionBody body = this.inProgressBody().copyBuilder().transactionID(newTransactionID).build();
        this.signedTx = StreamBuilder.signedTxWith((TransactionBody)body);
        this.serializedSignedTx = SignedTransaction.PROTOBUF.toBytes((Object)this.signedTx);
        return this;
    }

    @NonNull
    public RecordStreamBuilder memo(@NonNull String memo) {
        Objects.requireNonNull(memo, "memo must not be null");
        this.transactionRecordBuilder.memo(memo);
        return this;
    }

    @Nullable
    public Instant parentConsensusTimestamp() {
        return this.parentConsensus;
    }

    public long transactionFee() {
        return this.transactionFee;
    }

    @NonNull
    public RecordStreamBuilder transactionFee(long transactionFee) {
        this.transactionFee = transactionFee;
        this.transactionRecordBuilder.transactionFee(transactionFee);
        return this;
    }

    public void trackExplicitRewardSituation(@NonNull AccountID accountId) {
        if (this.explicitRewardReceiverIds == null) {
            this.explicitRewardReceiverIds = new LinkedHashSet<AccountID>();
        }
        this.explicitRewardReceiverIds.add(accountId);
    }

    public Set<AccountID> explicitRewardSituationIds() {
        return this.explicitRewardReceiverIds != null ? this.explicitRewardReceiverIds : Collections.emptySet();
    }

    @NonNull
    public RecordStreamBuilder contractCallResult(@Nullable ContractFunctionResult contractCallResult) {
        this.transactionRecordBuilder.contractCallResult(contractCallResult);
        this.contractFunctionResult = contractCallResult;
        return this;
    }

    @NonNull
    public EthereumTransactionStreamBuilder newSenderNonce(long senderNonce) {
        return this;
    }

    @NonNull
    public ContractCallStreamBuilder evmCallTransactionResult(@Nullable EvmTransactionResult result) {
        return this;
    }

    @NonNull
    public ContractCreateStreamBuilder evmCreateTransactionResult(@Nullable EvmTransactionResult result) {
        return this;
    }

    @NonNull
    public RecordStreamBuilder changedNonceInfo(@NonNull List<ContractNonceInfo> nonceInfos) {
        return this;
    }

    @NonNull
    public ContractOperationStreamBuilder createdContractIds(@NonNull List<ContractID> contractIds) {
        return this;
    }

    @NonNull
    public RecordStreamBuilder contractCreateResult(@Nullable ContractFunctionResult contractCreateResult) {
        this.transactionRecordBuilder.contractCreateResult(contractCreateResult);
        this.contractFunctionResult = contractCreateResult;
        return this;
    }

    @NonNull
    public ContractCallStreamBuilder addLogs(@NonNull List<EvmTransactionLog> logs) {
        return this;
    }

    @NonNull
    public TransferList transferList() {
        return this.transferList;
    }

    public void setReplayedFees(@NonNull TransferList transferList) {
        Objects.requireNonNull(transferList);
        if (this.transferList != null && this.transferList != TransferList.DEFAULT) {
            throw new IllegalStateException("Transfer list already set");
        }
        this.transferList = transferList;
    }

    @NonNull
    public RecordStreamBuilder transferList(@Nullable TransferList transferList) {
        this.transferList = transferList;
        return this;
    }

    @NonNull
    public RecordStreamBuilder tokenTransferLists(@NonNull List<TokenTransferList> tokenTransferLists) {
        Objects.requireNonNull(tokenTransferLists, "tokenTransferLists must not be null");
        this.tokenTransferLists = tokenTransferLists;
        return this;
    }

    public List<TokenTransferList> tokenTransferLists() {
        return this.tokenTransferLists;
    }

    @NonNull
    public RecordStreamBuilder addTokenTransferList(@NonNull TokenTransferList tokenTransferList) {
        Objects.requireNonNull(tokenTransferList, "tokenTransferList must not be null");
        this.tokenTransferLists.add(tokenTransferList);
        return this;
    }

    public RecordStreamBuilder addPendingAirdrop(@NonNull PendingAirdropRecord pendingAirdropRecord) {
        Objects.requireNonNull(pendingAirdropRecord);
        this.pendingAirdropRecords.add(pendingAirdropRecord);
        return this;
    }

    @NonNull
    public RecordStreamBuilder tokenType(@NonNull TokenType tokenType) {
        this.tokenType = Objects.requireNonNull(tokenType);
        return this;
    }

    @NonNull
    public RecordStreamBuilder scheduleRef(@NonNull ScheduleID scheduleRef) {
        Objects.requireNonNull(scheduleRef, "scheduleRef must not be null");
        this.transactionRecordBuilder.scheduleRef(scheduleRef);
        return this;
    }

    @NonNull
    public RecordStreamBuilder assessedCustomFees(@NonNull List<AssessedCustomFee> assessedCustomFees) {
        Objects.requireNonNull(assessedCustomFees, "assessedCustomFees must not be null");
        this.assessedCustomFees = assessedCustomFees;
        return this;
    }

    @NonNull
    public RecordStreamBuilder addAssessedCustomFee(@NonNull AssessedCustomFee assessedCustomFee) {
        Objects.requireNonNull(assessedCustomFee, "assessedCustomFee must not be null");
        this.assessedCustomFees.add(assessedCustomFee);
        return this;
    }

    @NonNull
    public RecordStreamBuilder automaticTokenAssociations(@NonNull List<TokenAssociation> automaticTokenAssociations) {
        Objects.requireNonNull(automaticTokenAssociations, "automaticTokenAssociations must not be null");
        this.automaticTokenAssociations = automaticTokenAssociations;
        return this;
    }

    @NonNull
    public RecordStreamBuilder addAutomaticTokenAssociation(@NonNull TokenAssociation automaticTokenAssociation) {
        Objects.requireNonNull(automaticTokenAssociation, "automaticTokenAssociation must not be null");
        this.automaticTokenAssociations.add(automaticTokenAssociation);
        return this;
    }

    public int getNumAutoAssociations() {
        return this.automaticTokenAssociations.size();
    }

    @NonNull
    public RecordStreamBuilder ethereumHash(@NonNull Bytes ethereumHash) {
        Objects.requireNonNull(ethereumHash, "ethereumHash must not be null");
        this.transactionRecordBuilder.ethereumHash(ethereumHash);
        return this;
    }

    @NonNull
    public RecordStreamBuilder paidStakingRewards(@NonNull List<AccountAmount> paidStakingRewards) {
        Objects.requireNonNull(paidStakingRewards, "paidStakingRewards must not be null");
        this.paidStakingRewards = paidStakingRewards;
        return this;
    }

    @NonNull
    public RecordStreamBuilder addPaidStakingReward(@NonNull AccountAmount paidStakingReward) {
        Objects.requireNonNull(paidStakingReward, "paidStakingReward must not be null");
        this.paidStakingRewards.add(paidStakingReward);
        return this;
    }

    @NonNull
    public RecordStreamBuilder entropyNumber(int num) {
        this.transactionRecordBuilder.prngNumber(num);
        return this;
    }

    @NonNull
    public RecordStreamBuilder entropyBytes(@NonNull Bytes prngBytes) {
        Objects.requireNonNull(prngBytes, "The argument 'prngBytes' must not be null");
        this.transactionRecordBuilder.prngBytes(prngBytes);
        return this;
    }

    @NonNull
    public RecordStreamBuilder evmAddress(@NonNull Bytes evmAddress) {
        Objects.requireNonNull(evmAddress, "evmAddress must not be null");
        this.transactionRecordBuilder.evmAddress(evmAddress);
        return this;
    }

    @NonNull
    public List<AssessedCustomFee> getAssessedCustomFees() {
        return this.assessedCustomFees;
    }

    @NonNull
    public RecordStreamBuilder status(@NonNull ResponseCodeEnum status) {
        this.status = Objects.requireNonNull(status, "status must not be null");
        this.transactionReceiptBuilder.status(status);
        return this;
    }

    @NonNull
    public ResponseCodeEnum status() {
        return this.status;
    }

    public boolean hasContractResult() {
        return this.contractFunctionResult != null;
    }

    public long getGasUsedForContractTxn() {
        return this.contractFunctionResult.gasUsed();
    }

    @NonNull
    public RecordStreamBuilder accountID(@NonNull AccountID accountID) {
        Objects.requireNonNull(accountID, "accountID must not be null");
        this.transactionReceiptBuilder.accountID(accountID);
        return this;
    }

    @NonNull
    public RecordStreamBuilder fileID(@NonNull FileID fileID) {
        Objects.requireNonNull(fileID, "fileID must not be null");
        this.transactionReceiptBuilder.fileID(fileID);
        return this;
    }

    @NonNull
    public RecordStreamBuilder contractID(@Nullable ContractID contractID) {
        this.transactionReceiptBuilder.accountID((AccountID)null);
        this.transactionReceiptBuilder.contractID(contractID);
        return this;
    }

    @NonNull
    public RecordStreamBuilder createdContractID(@Nullable ContractID contractID) {
        this.isContractCreate = true;
        this.contractID(contractID);
        return this;
    }

    @NonNull
    public RecordStreamBuilder createdEvmAddress(@Nullable Bytes evmAddress) {
        return this;
    }

    @NonNull
    public ExchangeRateSet exchangeRate() {
        return this.exchangeRate;
    }

    @NonNull
    public RecordStreamBuilder exchangeRate(@Nullable ExchangeRateSet exchangeRate) {
        this.exchangeRate = exchangeRate;
        return this;
    }

    @NonNull
    public StreamBuilder congestionMultiplier(long congestionMultiplier) {
        return this;
    }

    @NonNull
    public RecordStreamBuilder topicID(@NonNull TopicID topicID) {
        Objects.requireNonNull(topicID, "topicID must not be null");
        this.transactionReceiptBuilder.topicID(topicID);
        return this;
    }

    @NonNull
    public RecordStreamBuilder topicSequenceNumber(long topicSequenceNumber) {
        this.transactionReceiptBuilder.topicSequenceNumber(topicSequenceNumber);
        return this;
    }

    @NonNull
    public RecordStreamBuilder topicRunningHash(@NonNull Bytes topicRunningHash) {
        Objects.requireNonNull(topicRunningHash, "topicRunningHash must not be null");
        this.transactionReceiptBuilder.topicRunningHash(topicRunningHash);
        return this;
    }

    @NonNull
    public RecordStreamBuilder topicRunningHashVersion(long topicRunningHashVersion) {
        this.transactionReceiptBuilder.topicRunningHashVersion(topicRunningHashVersion);
        return this;
    }

    @NonNull
    public RecordStreamBuilder tokenID(@NonNull TokenID tokenID) {
        Objects.requireNonNull(tokenID, "tokenID must not be null");
        this.tokenID = tokenID;
        this.transactionReceiptBuilder.tokenID(tokenID);
        return this;
    }

    public TokenID tokenID() {
        return this.tokenID;
    }

    @NonNull
    public RecordStreamBuilder nodeID(long nodeId) {
        this.transactionReceiptBuilder.nodeId(nodeId);
        return this;
    }

    @NonNull
    public RecordStreamBuilder newTotalSupply(long newTotalSupply) {
        this.newTotalSupply = newTotalSupply;
        this.transactionReceiptBuilder.newTotalSupply(newTotalSupply);
        return this;
    }

    public long getNewTotalSupply() {
        return this.newTotalSupply;
    }

    @NonNull
    public RecordStreamBuilder scheduleID(@NonNull ScheduleID scheduleID) {
        Objects.requireNonNull(scheduleID, "scheduleID must not be null");
        this.transactionReceiptBuilder.scheduleID(scheduleID);
        this.scheduleID = Objects.requireNonNull(scheduleID);
        return this;
    }

    @NonNull
    public RecordStreamBuilder scheduledTransactionID(@NonNull TransactionID scheduledTransactionID) {
        this.transactionReceiptBuilder.scheduledTransactionID(scheduledTransactionID);
        return this;
    }

    @NonNull
    public RecordStreamBuilder serialNumbers(@NonNull List<Long> serialNumbers) {
        Objects.requireNonNull(serialNumbers, "serialNumbers must not be null");
        this.serialNumbers = serialNumbers;
        return this;
    }

    public List<Long> serialNumbers() {
        return this.serialNumbers;
    }

    @NonNull
    public RecordStreamBuilder addSerialNumber(long serialNumber) {
        this.serialNumbers.add(serialNumber);
        return this;
    }

    public ContractOperationStreamBuilder testForIdenticalKeys(@NonNull Predicate<Object> test) {
        return this;
    }

    @NonNull
    public RecordStreamBuilder contractStateChanges(@NonNull List<AbstractMap.SimpleEntry<ContractStateChanges, Boolean>> contractStateChanges) {
        Objects.requireNonNull(contractStateChanges, "contractStateChanges must not be null");
        this.contractStateChanges = contractStateChanges;
        return this;
    }

    public List<StateChange> getStateChanges() {
        throw new UnsupportedOperationException("Record stream does not accumulate state changes");
    }

    @NonNull
    public RecordStreamBuilder addContractStateChanges(@NonNull ContractStateChanges contractStateChanges, boolean isMigration) {
        Objects.requireNonNull(contractStateChanges, "contractStateChanges must not be null");
        if (this.contractStateChanges == null) {
            this.contractStateChanges = new LinkedList<AbstractMap.SimpleEntry<ContractStateChanges, Boolean>>();
        }
        this.contractStateChanges.add(new AbstractMap.SimpleEntry<ContractStateChanges, Boolean>(contractStateChanges, isMigration));
        return this;
    }

    @NonNull
    public ContractOperationStreamBuilder addContractSlotUsages(@NonNull List<ContractSlotUsage> slotUsages) {
        return this;
    }

    @NonNull
    public ContractOperationStreamBuilder addActions(@NonNull List<ContractAction> actions) {
        return this;
    }

    @NonNull
    public ContractOperationStreamBuilder addInitcode(@NonNull ExecutedInitcode initcode) {
        return this;
    }

    @NonNull
    public RecordStreamBuilder addContractActions(@NonNull ContractActions contractActions, boolean isMigration) {
        Objects.requireNonNull(contractActions, "contractActions must not be null");
        this.contractActions.add(new AbstractMap.SimpleEntry<ContractActions, Boolean>(contractActions, isMigration));
        return this;
    }

    @NonNull
    public RecordStreamBuilder addContractBytecode(@NonNull ContractBytecode contractBytecode, boolean isMigration) {
        Objects.requireNonNull(contractBytecode, "contractBytecode must not be null");
        AbstractMap.SimpleEntry<ContractBytecode, Boolean> entry = new AbstractMap.SimpleEntry<ContractBytecode, Boolean>(contractBytecode, isMigration);
        if (!this.contractBytecodes.contains(entry)) {
            this.contractBytecodes.add(entry);
        }
        return this;
    }

    public void addBeneficiaryForDeletedAccount(@NonNull AccountID deletedAccountID, @NonNull AccountID beneficiaryForDeletedAccount) {
        Objects.requireNonNull(deletedAccountID, "deletedAccountID must not be null");
        Objects.requireNonNull(beneficiaryForDeletedAccount, "beneficiaryForDeletedAccount must not be null");
        this.deletedAccountBeneficiaries.put(deletedAccountID, beneficiaryForDeletedAccount);
    }

    public int getNumberOfDeletedAccounts() {
        return this.deletedAccountBeneficiaries.size();
    }

    @Nullable
    public AccountID getDeletedAccountBeneficiaryFor(@NonNull AccountID deletedAccountID) {
        return this.deletedAccountBeneficiaries.get(deletedAccountID);
    }

    public ContractFunctionResult contractFunctionResult() {
        return this.contractFunctionResult;
    }

    @NonNull
    public TransactionBody transactionBody() {
        return this.inProgressBody();
    }

    private TransactionBody inProgressBody() {
        try {
            return (TransactionBody)TransactionBody.PROTOBUF.parse(this.signedTx.bodyBytes());
        }
        catch (Exception e) {
            throw new IllegalStateException("Record being built for unparseable transaction", e);
        }
    }

    @NonNull
    public List<AccountAmount> getPaidStakingRewards() {
        return this.paidStakingRewards;
    }

    @NonNull
    public HandleContext.TransactionCategory category() {
        return this.category;
    }

    public StreamBuilder functionality(@NonNull HederaFunctionality functionality) {
        this.function = functionality;
        return this;
    }

    public ScheduleID scheduleID() {
        return this.scheduleID;
    }

    public HederaFunctionality functionality() {
        return this.function;
    }

    public void nextHookId(long nextHookId) {
        this.nextHookId = nextHookId;
    }

    public long getNextHookId() {
        return this.nextHookId;
    }
}

