/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.util;

import com.esaulpaugh.headlong.util.Integers;
import java.math.BigInteger;

public final class Uint {
    private static final int MAX_BIT_LEN = 8192;
    public final int numBits;
    public final BigInteger range;
    public final long rangeLong;
    public final BigInteger halfRange;
    public final long halfRangeLong;

    public Uint(int numBits) {
        this.numBits = numBits;
        if (numBits < 63) {
            if (numBits <= 0) {
                throw new IllegalArgumentException("numBits must be positive");
            }
            this.rangeLong = 1L << numBits;
            this.range = BigInteger.valueOf(this.rangeLong);
            this.halfRangeLong = this.rangeLong >> 1;
            this.halfRange = BigInteger.valueOf(this.halfRangeLong);
        } else {
            if (numBits > 8192) {
                throw new IllegalArgumentException("numBits exceeds limit: " + numBits + " > " + 8192);
            }
            this.range = BigInteger.ONE.shiftLeft(numBits);
            this.halfRange = BigInteger.ONE.shiftLeft(numBits - 1);
            this.rangeLong = 0L;
            this.halfRangeLong = 0L;
        }
    }

    public long toSignedLong(long unsigned) {
        if (this.rangeLong != 0L) {
            if (unsigned < 0L) {
                throw new IllegalArgumentException("input must be non-negative");
            }
            int bitLen = Integers.bitLen(unsigned);
            if (bitLen <= this.numBits) {
                return unsigned >= this.halfRangeLong ? unsigned - this.rangeLong : unsigned;
            }
            throw Uint.tooManyBitsException(bitLen, this.numBits, false);
        }
        return this.toSigned(BigInteger.valueOf(unsigned)).longValue();
    }

    public BigInteger toSigned(BigInteger unsigned) {
        if (unsigned.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("input must be non-negative");
        }
        int bitLen = unsigned.bitLength();
        if (bitLen <= this.numBits) {
            return unsigned.compareTo(this.halfRange) >= 0 ? unsigned.subtract(this.range) : unsigned;
        }
        throw Uint.tooManyBitsException(bitLen, this.numBits, false);
    }

    public long toUnsignedLong(long signed) {
        if (this.numBits < 63) {
            int bitLen = Integers.bitLen(signed < 0L ? signed ^ 0xFFFFFFFFFFFFFFFFL : signed);
            if (bitLen < this.numBits) {
                return signed & this.rangeLong - 1L;
            }
            throw Uint.tooManyBitsException(bitLen, this.numBits, true);
        }
        return this.toUnsigned(signed).longValueExact();
    }

    public BigInteger toUnsigned(long signed) {
        return this.toUnsigned(BigInteger.valueOf(signed));
    }

    public BigInteger toUnsigned(BigInteger signed) {
        int bitLen = signed.bitLength();
        if (bitLen < this.numBits) {
            return signed.compareTo(BigInteger.ZERO) >= 0 ? signed : signed.add(this.range);
        }
        throw Uint.tooManyBitsException(bitLen, this.numBits, true);
    }

    private static IllegalArgumentException tooManyBitsException(int bitLen, int rangeNumBits, boolean signed) {
        return signed ? new IllegalArgumentException("signed has too many bits: " + bitLen + " is not less than " + rangeNumBits) : new IllegalArgumentException("unsigned has too many bits: " + bitLen + " > " + rangeNumBits);
    }
}

