/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Preconditions;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.DelegatingBytes;
import org.hyperledger.besu.ethereum.rlp.RLPException;
import org.hyperledger.besu.ethereum.rlp.RLPInput;

public class BLSSignature
extends DelegatingBytes {
    public static final int SIZE = 96;

    protected BLSSignature(Bytes bytes) {
        super(bytes);
    }

    public static BLSSignature wrap(Bytes value) {
        Preconditions.checkArgument((value.size() == 96 ? 1 : 0) != 0, (String)"A signature must be %s bytes long, got %s", (int)96, (int)value.size());
        return new BLSSignature(value);
    }

    public static BLSSignature readFrom(RLPInput input) {
        Bytes bytes = input.readBytes();
        if (bytes.size() != 96) {
            throw new RLPException(String.format("BLSSignature unexpected size of %s (needs %s)", bytes.size(), 96));
        }
        return BLSSignature.wrap(bytes);
    }

    @JsonCreator
    public static BLSSignature fromHexString(String str) {
        if (str == null) {
            return null;
        }
        return BLSSignature.wrap(Bytes.fromHexStringLenient((CharSequence)str, (int)96));
    }
}

