/*
 * Decompiled with CFR 0.152.
 */
package io.helidon;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.SerializationConfig;
import io.helidon.common.Weights;
import io.helidon.logging.common.LogConfig;
import io.helidon.spi.HelidonShutdownHandler;
import io.helidon.spi.HelidonStartupProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Main {
    private static final Set<HelidonShutdownHandler> SHUTDOWN_HANDLERS = Collections.newSetFromMap(new IdentityHashMap());
    private static final ReentrantLock SHUTDOWN_HANDLER_LOCK = new ReentrantLock();
    private static final AtomicBoolean SHUTDOWN_HOOK_ADDED = new AtomicBoolean();

    private Main() {
    }

    public static void main(String[] args) {
        LogConfig.configureRuntime();
        SerializationConfig.configureRuntime();
        List services = HelidonServiceLoader.create(ServiceLoader.load(HelidonStartupProvider.class)).asList();
        if (services.isEmpty()) {
            throw new IllegalStateException("Helidon Main class can only be called if a startup provider is available. Please use either Helidon Injection, or Helidon MicroProfile (or a custom extension). If neither is used, you should define your own Main class, usually configured as 'mainClass' property in your pom.xml.");
        }
        Main.addShutdownHook();
        ((HelidonStartupProvider)services.getFirst()).start(args);
    }

    public static void addShutdownHandler(HelidonShutdownHandler handler) {
        Main.addShutdownHook();
        SHUTDOWN_HANDLER_LOCK.lock();
        try {
            SHUTDOWN_HANDLERS.add(handler);
        }
        finally {
            SHUTDOWN_HANDLER_LOCK.unlock();
        }
    }

    public static void removeShutdownHandler(HelidonShutdownHandler handler) {
        SHUTDOWN_HANDLER_LOCK.lock();
        try {
            SHUTDOWN_HANDLERS.remove(handler);
        }
        finally {
            SHUTDOWN_HANDLER_LOCK.unlock();
        }
    }

    private static void addShutdownHook() {
        if (SHUTDOWN_HOOK_ADDED.compareAndSet(false, true)) {
            Thread shutdownHook = Thread.ofPlatform().daemon(false).name("helidon-shutdown-thread").unstarted(Main::shutdown);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            Main.keepLoggingActive(shutdownHook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdown() {
        SHUTDOWN_HANDLER_LOCK.lock();
        try {
            System.Logger logger = System.getLogger(Main.class.getName());
            logger.log(System.Logger.Level.INFO, "Shutdown requested by JVM shutting down");
            ArrayList<HelidonShutdownHandler> handlers = new ArrayList<HelidonShutdownHandler>(SHUTDOWN_HANDLERS);
            handlers.sort(Weights.weightComparator());
            for (HelidonShutdownHandler handler : handlers) {
                try {
                    if (logger.isLoggable(System.Logger.Level.TRACE)) {
                        logger.log(System.Logger.Level.TRACE, "Calling shutdown handler: " + String.valueOf(handler));
                    }
                    handler.shutdown();
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Failed when calling shutdown handler: " + String.valueOf(handler));
                }
            }
            SHUTDOWN_HANDLERS.clear();
            SHUTDOWN_HOOK_ADDED.set(false);
            logger.log(System.Logger.Level.INFO, "Shutdown finished");
        }
        finally {
            SHUTDOWN_HANDLER_LOCK.unlock();
        }
    }

    private static void keepLoggingActive(Thread shutdownHook) {
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        Handler[] handlers = rootLogger.getHandlers();
        ArrayList<Handler> newHandlers = new ArrayList<Handler>();
        boolean added = false;
        for (Handler handler : handlers) {
            if (handler instanceof KeepLoggingActiveHandler) {
                newHandlers.add(new KeepLoggingActiveHandler(shutdownHook));
                added = true;
                continue;
            }
            newHandlers.add(handler);
        }
        if (!added) {
            newHandlers.addFirst(new KeepLoggingActiveHandler(shutdownHook));
        }
        for (Handler handler : handlers) {
            rootLogger.removeHandler(handler);
        }
        for (Handler newHandler : newHandlers) {
            rootLogger.addHandler(newHandler);
        }
    }

    static {
        LogConfig.initClass();
    }

    private static final class KeepLoggingActiveHandler
    extends Handler {
        private final Thread shutdownHook;

        private KeepLoggingActiveHandler(Thread shutdownHook) {
            this.shutdownHook = shutdownHook;
        }

        @Override
        public void publish(LogRecord record) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
            try {
                this.shutdownHook.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

