/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.operations;

import com.hedera.node.app.service.contract.impl.exec.FeatureFlags;
import com.hedera.node.app.service.contract.impl.exec.operations.AbstractCustomCreateOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomizedOpcodes;
import com.hedera.node.app.service.contract.impl.state.ProxyWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.code.CodeFactory;
import org.hyperledger.besu.evm.code.CodeV0;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.Create2Operation;

public class CustomCreate2Operation
extends AbstractCustomCreateOperation {
    private static final Bytes EIP_1014_PREFIX = Bytes.fromHexString((CharSequence)"0xFF");
    private final FeatureFlags featureFlags;

    public CustomCreate2Operation(@NonNull GasCalculator gasCalculator, @NonNull FeatureFlags featureFlags, @NonNull CodeFactory codeFactory) {
        super(CustomizedOpcodes.CREATE2.opcode(), "\u0127CREATE2", 4, 1, gasCalculator, codeFactory);
        this.featureFlags = featureFlags;
    }

    @Override
    protected boolean isEnabled(@NonNull MessageFrame frame) {
        return this.featureFlags.isCreate2Enabled(frame);
    }

    @Override
    protected long cost(@NonNull MessageFrame frame) {
        return new Create2Operation(this.gasCalculator()).cost(frame, () -> CodeV0.EMPTY_CODE);
    }

    @Override
    @Nullable
    protected Address setupPendingCreation(@NonNull MessageFrame frame) {
        Address alias = this.eip1014AddressFor(frame);
        ProxyWorldUpdater updater = (ProxyWorldUpdater)frame.getWorldUpdater();
        if (updater.isHollowAccount(alias) && !this.featureFlags.isImplicitCreationEnabled()) {
            return null;
        }
        updater.setupInternalAliasedCreate(frame.getRecipientAddress(), alias);
        frame.warmUpAddress(alias);
        return alias;
    }

    @Override
    protected void onSuccess(@NonNull MessageFrame frame, @NonNull Address creation) {
    }

    private Address eip1014AddressFor(@NonNull MessageFrame frame) {
        Address creatorAddress = frame.getRecipientAddress();
        long offset = Words.clampedToLong((Bytes)frame.getStackItem(1));
        long length = Words.clampedToLong((Bytes)frame.getStackItem(2));
        UInt256 salt = UInt256.fromBytes((Bytes)frame.getStackItem(3));
        MutableBytes initCode = frame.readMutableMemory(offset, length);
        Bytes32 hash = this.keccak256(Bytes.concatenate((Bytes[])new Bytes[]{EIP_1014_PREFIX, creatorAddress, salt, this.keccak256((Bytes)initCode)}));
        return Address.wrap((Bytes)hash.slice(12, 20));
    }

    private Bytes32 keccak256(Bytes input) {
        return Bytes32.wrap((byte[])CustomCreate2Operation.keccak256DigestOf(input.toArrayUnsafe()));
    }

    private static byte[] keccak256DigestOf(byte[] msg) {
        return new Keccak.Digest256().digest(msg);
    }
}

