/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.mint;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.DispatchForResponseCodeHtsCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.mint.MintDecoder;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class MintTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod MINT = SystemContractMethod.declare("mintToken(address,uint64,bytes[])", "(int64,int64,int64[])").withVariant(SystemContractMethod.Variant.V1).withCategories(SystemContractMethod.Category.MINT_BURN);
    public static final SystemContractMethod MINT_V2 = SystemContractMethod.declare("mintToken(address,int64,bytes[])", "(int64,int64,int64[])").withVariant(SystemContractMethod.Variant.V2).withCategories(SystemContractMethod.Category.MINT_BURN);
    private final MintDecoder decoder;

    @Inject
    public MintTranslator(@NonNull MintDecoder decoder, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.decoder = decoder;
        this.registerMethods(MINT, MINT_V2);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isMethod(MINT, MINT_V2);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        TransactionBody body;
        boolean isFungibleMint = (body = this.bodyForClassic(attempt)).tokenMintOrThrow().metadata().isEmpty();
        return new DispatchForResponseCodeHtsCall(attempt, body, isFungibleMint ? MintTranslator::fungibleMintGasRequirement : MintTranslator::nftMintGasRequirement, MintDecoder.MINT_OUTPUT_FN);
    }

    public static long nftMintGasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.MINT_NFT, payerId);
    }

    public static long fungibleMintGasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.MINT_FUNGIBLE, payerId);
    }

    private TransactionBody bodyForClassic(@NonNull HtsCallAttempt attempt) {
        if (attempt.isSelector(MINT)) {
            return this.decoder.decodeMint(attempt);
        }
        return this.decoder.decodeMintV2(attempt);
    }
}

