/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto.altbn128;

import java.math.BigInteger;
import org.hyperledger.besu.crypto.altbn128.AbstractFieldPoint;
import org.hyperledger.besu.crypto.altbn128.FieldElement;
import org.hyperledger.besu.crypto.altbn128.Fq2;

public class AltBn128Fq2Point
extends AbstractFieldPoint<AltBn128Fq2Point> {
    private static final BigInteger CURVE_ORDER = new BigInteger("21888242871839275222246405745257275088548364400416034343698204186575808495617", 10);

    public static AltBn128Fq2Point g2() {
        Fq2 x = Fq2.create(new BigInteger("10857046999023057135944570762232829481370756359578518086990519993285655852781"), new BigInteger("11559732032986387107991004021392285783925812861821192530917403151452391805634"));
        Fq2 y = Fq2.create(new BigInteger("8495653923123431417604973247489272438418190587263600148770280649306958101930"), new BigInteger("4082367875863433681332203403145435568316851327593401208105741076214120093531"));
        return new AltBn128Fq2Point(x, y);
    }

    public AltBn128Fq2Point(Fq2 x, Fq2 y) {
        super(x, y);
    }

    public Fq2 getX() {
        return (Fq2)this.x;
    }

    public Fq2 getY() {
        return (Fq2)this.y;
    }

    @Override
    protected AltBn128Fq2Point infinity() {
        return new AltBn128Fq2Point(Fq2.zero(), Fq2.zero());
    }

    public boolean isOnCurve() {
        if (!this.x.isValid() || !this.y.isValid()) {
            return false;
        }
        if (this.isInfinity()) {
            return true;
        }
        Fq2 x = this.getX();
        Fq2 y = this.getY();
        return ((Fq2)y.power(2)).subtract((Fq2)x.power(3)).equals(Fq2.b2());
    }

    public boolean isInGroup() {
        return ((AltBn128Fq2Point)this.multiply(CURVE_ORDER)).isInfinity();
    }

    @Override
    protected AltBn128Fq2Point newInstance(FieldElement x, FieldElement y) {
        return new AltBn128Fq2Point((Fq2)x, (Fq2)y);
    }
}

