/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.isvalidalias;

import com.esaulpaugh.headlong.abi.Address;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.HasCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.isvalidalias.IsValidAliasCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class IsValidAliasTranslator
extends AbstractCallTranslator<HasCallAttempt> {
    public static final SystemContractMethod IS_VALID_ALIAS = SystemContractMethod.declare("isValidAlias(address)", "(bool)").withModifier(SystemContractMethod.Modifier.VIEW).withCategories(SystemContractMethod.Category.ALIASES);

    @Inject
    public IsValidAliasTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HAS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(IS_VALID_ALIAS);
    }

    @Override
    @NonNull
    public Call callFrom(@NonNull HasCallAttempt attempt) {
        Address address = (Address)IS_VALID_ALIAS.decodeCall(attempt.input().toArrayUnsafe()).get(0);
        return new IsValidAliasCall(attempt, address);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HasCallAttempt attempt) {
        Objects.requireNonNull(attempt, "attempt");
        return attempt.isMethod(IS_VALID_ALIAS);
    }
}

