/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer;

import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.ApprovalSwitchHelper;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.CallStatusStandardizer;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.ClassicTransfersCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.ClassicTransfersDecoder;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.SpecialRewardReceivers;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.SystemAccountCreditScreen;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ClassicTransfersTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod CRYPTO_TRANSFER = SystemContractMethod.declare("cryptoTransfer((address,(address,int64)[],(address,address,int64)[])[])", "(int64)").withVariants(SystemContractMethod.Variant.V1).withCategories(SystemContractMethod.Category.TRANSFER);
    public static final SystemContractMethod CRYPTO_TRANSFER_V2 = SystemContractMethod.declare("cryptoTransfer(((address,int64,bool)[]),(address,(address,int64,bool)[],(address,address,int64,bool)[])[])", "(int64)").withVariants(SystemContractMethod.Variant.V2).withCategories(SystemContractMethod.Category.TRANSFER);
    public static final SystemContractMethod TRANSFER_TOKENS = SystemContractMethod.declare("transferTokens(address,address[],int64[])", "(int64)").withCategories(SystemContractMethod.Category.TRANSFER);
    public static final SystemContractMethod TRANSFER_TOKEN = SystemContractMethod.declare("transferToken(address,address,address,int64)", "(int64)").withVariants(SystemContractMethod.Variant.FT).withCategories(SystemContractMethod.Category.TRANSFER);
    public static final SystemContractMethod TRANSFER_NFTS = SystemContractMethod.declare("transferNFTs(address,address[],address[],int64[])", "(int64)").withVariants(SystemContractMethod.Variant.NFT).withCategories(SystemContractMethod.Category.TRANSFER);
    public static final SystemContractMethod TRANSFER_NFT = SystemContractMethod.declare("transferNFT(address,address,address,int64)", "(int64)").withVariants(SystemContractMethod.Variant.NFT).withCategories(SystemContractMethod.Category.TRANSFER);
    public static final SystemContractMethod TRANSFER_FROM = SystemContractMethod.declare("transferFrom(address,address,address,uint256)", "(int64)").withVariants(SystemContractMethod.Variant.FT).withCategories(SystemContractMethod.Category.TRANSFER);
    public static final SystemContractMethod TRANSFER_NFT_FROM = SystemContractMethod.declare("transferFromNFT(address,address,address,uint256)", "(int64)").withVariants(SystemContractMethod.Variant.NFT).withCategories(SystemContractMethod.Category.TRANSFER);
    private final ClassicTransfersDecoder decoder;

    @Inject
    public ClassicTransfersTranslator(ClassicTransfersDecoder decoder, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.decoder = decoder;
        this.registerMethods(CRYPTO_TRANSFER, CRYPTO_TRANSFER_V2, TRANSFER_TOKENS, TRANSFER_TOKEN, TRANSFER_NFTS, TRANSFER_NFT, TRANSFER_FROM, TRANSFER_NFT_FROM);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        if (attempt.isRedirect()) {
            return Optional.empty();
        }
        return attempt.isMethod(CRYPTO_TRANSFER, CRYPTO_TRANSFER_V2, TRANSFER_TOKENS, TRANSFER_TOKEN, TRANSFER_NFTS, TRANSFER_NFT, TRANSFER_FROM, TRANSFER_NFT_FROM);
    }

    public ClassicTransfersCall callFrom(@NonNull HtsCallAttempt attempt) {
        byte[] selector = attempt.selector();
        return new ClassicTransfersCall(attempt.systemContractGasCalculator(), attempt.enhancement(), selector, this.isClassicCallSupportingQualifiedDelegate(attempt) ? attempt.authorizingId() : attempt.senderId(), this.decoder.checkForFailureStatus(attempt), this.nominalBodyFor(attempt), attempt.configuration(), this.isClassicCall(attempt) ? ApprovalSwitchHelper.APPROVAL_SWITCH_HELPER : null, CallStatusStandardizer.CALL_STATUS_STANDARDIZER, attempt.defaultVerificationStrategy(), SystemAccountCreditScreen.SYSTEM_ACCOUNT_CREDIT_SCREEN, SpecialRewardReceivers.SPECIAL_REWARD_RECEIVERS);
    }

    @Nullable
    private TransactionBody nominalBodyFor(@NonNull HtsCallAttempt attempt) {
        if (attempt.isSelector(CRYPTO_TRANSFER)) {
            return this.decoder.decodeCryptoTransfer(attempt.inputBytes(), attempt);
        }
        if (attempt.isSelector(CRYPTO_TRANSFER_V2)) {
            return this.decoder.decodeCryptoTransferV2(attempt.inputBytes(), attempt);
        }
        if (attempt.isSelector(TRANSFER_TOKENS)) {
            return this.decoder.decodeTransferTokens(attempt.inputBytes(), attempt);
        }
        if (attempt.isSelector(TRANSFER_TOKEN)) {
            return this.decoder.decodeTransferToken(attempt.inputBytes(), attempt);
        }
        if (attempt.isSelector(TRANSFER_NFTS)) {
            return this.decoder.decodeTransferNfts(attempt.inputBytes(), attempt);
        }
        if (attempt.isSelector(TRANSFER_NFT)) {
            return this.decoder.decodeTransferNft(attempt.inputBytes(), attempt);
        }
        if (attempt.isSelector(TRANSFER_FROM)) {
            return this.decoder.decodeHrcTransferFrom(attempt.inputBytes(), attempt);
        }
        return this.decoder.decodeHrcTransferNftFrom(attempt.inputBytes(), attempt);
    }

    private boolean isClassicCall(@NonNull HtsCallAttempt attempt) {
        return attempt.isMethod(CRYPTO_TRANSFER, CRYPTO_TRANSFER_V2, TRANSFER_TOKENS, TRANSFER_TOKEN, TRANSFER_NFTS, TRANSFER_NFT).isPresent();
    }

    private boolean isClassicCallSupportingQualifiedDelegate(@NonNull HtsCallAttempt attempt) {
        return attempt.isMethod(TRANSFER_TOKENS, TRANSFER_TOKEN, TRANSFER_NFTS, TRANSFER_NFT).isPresent();
    }
}

