/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.utils;

import com.esaulpaugh.headlong.abi.Function;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.hedera.hapi.node.base.ContractID;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tuweni.bytes.Bytes;

public record SystemContractMethod(@NonNull Function function, @NonNull Optional<SystemContract> systemContract, @NonNull CallVia via, @NonNull EnumSet<Category> categories, @NonNull Optional<Modifier> modifier, @NonNull EnumSet<Variant> variants, @NonNull Set<ContractID> supportedAddresses) {
    public static final ContractID ALL_CONTRACT_ID = ContractID.DEFAULT;

    public SystemContractMethod {
        Objects.requireNonNull(function);
        Objects.requireNonNull(systemContract);
        Objects.requireNonNull(via);
        Objects.requireNonNull(categories);
        Objects.requireNonNull(modifier);
        Objects.requireNonNull(variants);
        Objects.requireNonNull(supportedAddresses);
    }

    public static SystemContractMethod declare(@NonNull String signature, @NonNull String outputs) {
        Function function = new Function(signature, outputs);
        return new SystemContractMethod(function, Optional.empty(), CallVia.DIRECT, EnumSet.noneOf(Category.class), Optional.empty(), EnumSet.noneOf(Variant.class), Set.of(ALL_CONTRACT_ID));
    }

    public static SystemContractMethod declare(@NonNull String signature) {
        Function function = new Function(signature);
        return new SystemContractMethod(function, Optional.empty(), CallVia.DIRECT, EnumSet.noneOf(Category.class), Optional.empty(), EnumSet.noneOf(Variant.class), Set.of(ALL_CONTRACT_ID));
    }

    public void verifyComplete() {
        if (this.systemContract.isEmpty()) {
            throw new IllegalStateException("System contract %s is empty".formatted(this.function.getName()));
        }
    }

    @NonNull
    public SystemContractMethod withContract(@NonNull SystemContract systemContract) {
        return new SystemContractMethod(this.function, Optional.of(systemContract), this.via, this.categories, this.modifier, this.variants, this.supportedAddresses);
    }

    @NonNull
    public SystemContractMethod withVia(@NonNull CallVia via) {
        return new SystemContractMethod(this.function, this.systemContract, via, this.categories, this.modifier, this.variants, this.supportedAddresses);
    }

    @NonNull
    public SystemContractMethod withCategories(Category ... categories) {
        EnumSet<Category> c = EnumSet.copyOf(this.categories);
        c.addAll(Arrays.asList(categories));
        return new SystemContractMethod(this.function, this.systemContract, this.via, c, this.modifier, this.variants, this.supportedAddresses);
    }

    @NonNull
    public SystemContractMethod withCategory(@NonNull Category category) {
        EnumSet<Category> c = EnumSet.copyOf(this.categories);
        c.add(category);
        return new SystemContractMethod(this.function, this.systemContract, this.via, c, this.modifier, this.variants, this.supportedAddresses);
    }

    @NonNull
    public SystemContractMethod withModifier(@NonNull Modifier modifier) {
        return new SystemContractMethod(this.function, this.systemContract, this.via, this.categories, Optional.of(modifier), this.variants, this.supportedAddresses);
    }

    @NonNull
    public SystemContractMethod withVariants(Variant ... variants) {
        EnumSet<Variant> v = EnumSet.copyOf(this.variants);
        v.addAll(Arrays.asList(variants));
        return new SystemContractMethod(this.function, this.systemContract, this.via, this.categories, this.modifier, v, this.supportedAddresses);
    }

    @NonNull
    public SystemContractMethod withVariant(@NonNull Variant variant) {
        EnumSet<Variant> v = EnumSet.copyOf(this.variants);
        v.add(variant);
        return new SystemContractMethod(this.function, this.systemContract, this.via, this.categories, this.modifier, v, this.supportedAddresses);
    }

    @NonNull
    public SystemContractMethod withSupportedAddresses(ContractID ... supportedAddresses) {
        if (supportedAddresses.length == 0) {
            return new SystemContractMethod(this.function, this.systemContract, this.via, this.categories, this.modifier, this.variants, Set.of(ALL_CONTRACT_ID));
        }
        HashSet<ContractID> sa = new HashSet<ContractID>();
        sa.addAll(Arrays.asList(supportedAddresses));
        return new SystemContractMethod(this.function, this.systemContract, this.via, this.categories, this.modifier, this.variants, sa);
    }

    @NonNull
    public SystemContractMethod withSupportedAddress(@NonNull ContractID supportedAddress) {
        return this.withSupportedAddresses(supportedAddress);
    }

    public Tuple decodeCall(byte[] call) {
        return this.function.decodeCall(call);
    }

    public ByteBuffer encodeCall(Tuple tuple) {
        return this.function.encodeCall(tuple);
    }

    public ByteBuffer encodeCallWithArgs(Object ... args) {
        return this.function.encodeCallWithArgs(args);
    }

    public <T extends Tuple> TupleType<T> getOutputs() {
        return this.function.getOutputs();
    }

    @NonNull
    public String signature() {
        return this.function.getCanonicalSignature();
    }

    @NonNull
    public String signatureWithReturn() {
        return this.signature() + ":" + String.valueOf(this.function.getOutputs());
    }

    @NonNull
    public byte[] selector() {
        return this.function.selector();
    }

    public long selectorLong() {
        return Bytes.wrap((byte[])this.function.selector()).toLong(ByteOrder.BIG_ENDIAN);
    }

    @NonNull
    public String selectorHex() {
        return this.function.selectorHex();
    }

    public boolean hasVariant(@NonNull Variant variant) {
        return this.variants.contains(variant);
    }

    public boolean hasCategory(@NonNull Category category) {
        return this.categories.contains(category);
    }

    public boolean hasCategory(@NonNull Set<Category> categories) {
        Object intersection = this.categories.clone();
        ((AbstractCollection)intersection).retainAll(categories);
        return !((AbstractCollection)intersection).isEmpty();
    }

    public boolean hasSupportedAddress(@NonNull ContractID supportedAddress) {
        return this.supportedAddresses.contains(ContractID.DEFAULT) || this.supportedAddresses.contains(supportedAddress);
    }

    @NonNull
    public String methodName() {
        return this.function.getName();
    }

    @NonNull
    public String variatedMethodName() {
        return this.methodName() + this.variantsSuffix();
    }

    @NonNull
    public String fullyDecoratedMethodName() {
        Object name = this.qualifiedMethodName();
        name = (String)name + this.modifiersSuffix();
        name = (String)name + this.categoriesSuffix();
        return name;
    }

    @NonNull
    public String qualifiedMethodName() {
        String systemContractName = this.systemContract.map(Enum::name).orElse("???");
        String methodName = switch (this.via.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> systemContractName + "." + this.variatedMethodName();
            case 1 -> systemContractName + "(PROXY)." + this.variatedMethodName();
        };
        return methodName;
    }

    @NonNull
    public String variantsSuffix() {
        if (this.variants.isEmpty()) {
            return "";
        }
        return this.variants.stream().map(Variant::asSuffix).sorted().collect(Collectors.joining("_", "_", ""));
    }

    @NonNull
    public String categoriesSuffix() {
        if (this.categories.isEmpty()) {
            return "";
        }
        return this.categories.stream().map(Category::asSuffix).sorted().collect(Collectors.joining(",", "_[", "]"));
    }

    @NonNull
    public String modifiersSuffix() {
        if (this.modifier.isEmpty()) {
            return "";
        }
        return "_[" + this.modifier.get().asSuffix() + "]";
    }

    public static enum CallVia implements AsSuffix
    {
        DIRECT(""),
        PROXY("[PROXY]");

        private final String asSuffix;

        private CallVia(String viaSuffix) {
            this.asSuffix = viaSuffix;
        }

        @Override
        @NonNull
        public String asSuffix() {
            return this.asSuffix;
        }
    }

    public static enum Category implements AsSuffix
    {
        ERC20("ERC20", "(can overlap with ERC721)"),
        ERC721("ERC721", "(can overlap with ERC20)"),
        SCHEDULE("SCHEDULE"),
        TOKEN_QUERY("TOKEN_QUERY", "(any token field query)"),
        ALIASES("ALIASES"),
        IS_AUTHORIZED("IS_AUTHORIZED", "(IsAuthorized, IsAuthorizedRaw)"),
        AIRDROP("AIRDROP"),
        ALLOWANCE("ALLOWANCE", "(Allowance related)"),
        APPROVAL("APPROVAL", "(Approval related)"),
        ASSOCIATION("ASSOCIATION"),
        CREATE_DELETE_TOKEN("CREATE_OR_DELETE_TOKEN", "(Create or Delete Token)"),
        FREEZE_UNFREEZE("FREEZE_UNFREEZE", "(Freeze or Unfreeze Token)"),
        KYC("KYC"),
        MINT_BURN("MINT_OR_BURN", "(Mint or Burn Token)"),
        PAUSE_UNPAUSE("PAUSE_UNPAUSE", "(Pause or Unpause Token)"),
        REJECT("REJECT_TOKEN"),
        TRANSFER("TRANSFER_TOKEN", "(any token transfer transaction"),
        UPDATE("UPDATE_TOKEN", "(any token field update)"),
        WIPE("WIPE_TOKEN");

        private final String asSuffix;
        private final String clarification;

        private Category(String categorySuffix) {
            this.asSuffix = Objects.requireNonNull(categorySuffix);
            this.clarification = "(%s)".formatted(this.asSuffix);
        }

        private Category(String categorySuffix, String clarification) {
            this.asSuffix = Objects.requireNonNull(categorySuffix);
            this.clarification = Objects.requireNonNull(clarification);
        }

        @Override
        @NonNull
        public String asSuffix() {
            return this.asSuffix;
        }

        @NonNull
        public String clarification() {
            return this.clarification;
        }
    }

    public static enum Variant implements AsSuffix
    {
        FT,
        NFT,
        V1,
        V2,
        V3,
        WITH_METADATA,
        WITH_CUSTOM_FEES;


        @Override
        @NonNull
        public String asSuffix() {
            return this.name();
        }
    }

    public static enum Modifier implements AsSuffix
    {
        VIEW("VIEW"),
        PURE("PURE");

        private final String asSuffix;

        private Modifier(String modifierSuffix) {
            this.asSuffix = modifierSuffix;
        }

        @Override
        @NonNull
        public String asSuffix() {
            return this.asSuffix;
        }
    }

    public static interface AsSuffix {
        @NonNull
        public String asSuffix();
    }

    public static enum SystemContract {
        HTS,
        HAS,
        HSS,
        PNRG,
        EXCHANGE;

    }
}

