/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Map;
import java.util.function.Supplier;
import org.hyperledger.besu.crypto.SECP256K1;
import org.hyperledger.besu.crypto.SECP256R1;
import org.hyperledger.besu.crypto.SignatureAlgorithm;

public class SignatureAlgorithmType {
    public static final String DEFAULT_EC_CURVE_NAME = "secp256k1";
    private static final ImmutableMap<String, Supplier<SignatureAlgorithm>> SUPPORTED_ALGORITHMS = ImmutableMap.of((Object)"secp256k1", SECP256K1::new, (Object)"secp256r1", SECP256R1::new);
    public static final Supplier<SignatureAlgorithm> DEFAULT_SIGNATURE_ALGORITHM_TYPE = (Supplier)SUPPORTED_ALGORITHMS.get((Object)"secp256k1");
    private final Supplier<SignatureAlgorithm> instantiator;

    private SignatureAlgorithmType(Supplier<SignatureAlgorithm> instantiator) {
        this.instantiator = instantiator;
    }

    public static SignatureAlgorithmType create(String ecCurve) throws IllegalArgumentException {
        if (!SignatureAlgorithmType.isValidType(ecCurve)) {
            throw new IllegalArgumentException(SignatureAlgorithmType.invalidTypeErrorMessage(ecCurve));
        }
        return new SignatureAlgorithmType((Supplier)SUPPORTED_ALGORITHMS.get((Object)ecCurve));
    }

    public static SignatureAlgorithmType createDefault() {
        return new SignatureAlgorithmType(DEFAULT_SIGNATURE_ALGORITHM_TYPE);
    }

    public SignatureAlgorithm getInstance() {
        return this.instantiator.get();
    }

    public static boolean isValidType(String ecCurve) {
        return SUPPORTED_ALGORITHMS.containsKey((Object)ecCurve);
    }

    public static boolean isDefault(SignatureAlgorithm signatureAlgorithm) {
        return signatureAlgorithm.getCurveName().equals(DEFAULT_EC_CURVE_NAME);
    }

    private static String invalidTypeErrorMessage(String invalidEcCurve) {
        return invalidEcCurve + " is not in the list of valid elliptic curves " + SignatureAlgorithmType.getEcCurvesListAsString();
    }

    private static String getEcCurvesListAsString() {
        UnmodifiableIterator it = SUPPORTED_ALGORITHMS.entrySet().iterator();
        StringBuilder ecCurveListBuilder = new StringBuilder();
        ecCurveListBuilder.append("[");
        while (it.hasNext()) {
            ecCurveListBuilder.append((String)((Map.Entry)it.next()).getKey());
            if (!it.hasNext()) continue;
            ecCurveListBuilder.append(", ");
        }
        ecCurveListBuilder.append("]");
        return ecCurveListBuilder.toString();
    }
}

