/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractExtCallOperation;

public class ExtDelegateCallOperation
extends AbstractExtCallOperation {
    public static final int OPCODE = 249;

    public ExtDelegateCallOperation(GasCalculator gasCalculator) {
        super(249, "EXTDELEGATECALL", 3, 1, gasCalculator);
    }

    @Override
    protected Wei value(MessageFrame frame) {
        return Wei.ZERO;
    }

    @Override
    protected Wei apparentValue(MessageFrame frame) {
        return frame.getApparentValue();
    }

    @Override
    protected long inputDataOffset(MessageFrame frame) {
        return Words.clampedToLong(frame.getStackItem(1));
    }

    @Override
    protected long inputDataLength(MessageFrame frame) {
        return Words.clampedToLong(frame.getStackItem(2));
    }

    @Override
    protected Address address(MessageFrame frame) {
        return frame.getRecipientAddress();
    }

    @Override
    protected Address sender(MessageFrame frame) {
        return frame.getSenderAddress();
    }

    @Override
    protected boolean isDelegate() {
        return true;
    }
}

