/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.Checks;
import org.apache.tuweni.bytes.DelegatingMutableBytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.bytes.MutableBytes32;

final class DelegatingMutableBytes32
extends DelegatingMutableBytes
implements MutableBytes32 {
    private DelegatingMutableBytes32(MutableBytes delegate) {
        super(delegate);
    }

    static MutableBytes32 delegateTo(MutableBytes value) {
        Checks.checkArgument(value.size() == 32, "Expected %s bytes but got %s", 32, value.size());
        return new DelegatingMutableBytes32(value);
    }

    @Override
    public Bytes32 copy() {
        return Bytes32.wrap(this.delegate.toArray());
    }

    @Override
    public MutableBytes32 mutableCopy() {
        return MutableBytes32.wrap(this.delegate.toArray());
    }
}

