/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.addressbook.impl;

import com.hedera.hapi.node.state.addressbook.Node;
import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.addressbook.impl.ReadableNodeStoreImpl;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.hedera.node.app.spi.ids.WritableEntityCounters;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Set;

public class WritableNodeStore
extends ReadableNodeStoreImpl {
    private final WritableEntityCounters entityCounters;

    public WritableNodeStore(@NonNull WritableStates states, @NonNull WritableEntityCounters entityCounters) {
        super((ReadableStates)states, (ReadableEntityCounters)entityCounters);
        this.entityCounters = entityCounters;
    }

    protected WritableKVState<EntityNumber, Node> nodesState() {
        return (WritableKVState)super.nodesState();
    }

    public void put(@NonNull Node node) {
        Objects.requireNonNull(node);
        this.nodesState().put((Object)EntityNumber.newBuilder().number(node.nodeId()).build(), (Object)node);
    }

    public void putAndIncrementCount(@NonNull Node node) {
        this.put(node);
        this.entityCounters.incrementEntityTypeCount(EntityType.NODE);
    }

    public Set<EntityNumber> modifiedNodes() {
        return this.nodesState().modifiedKeys();
    }
}

