/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HookEntityId;
import com.hedera.hapi.node.base.HookId;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.hooks.HookCreation;
import com.hedera.hapi.node.hooks.HookCreationDetails;
import com.hedera.hapi.node.hooks.HookDispatchTransactionBody;
import com.hedera.hapi.node.hooks.HookExecution;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.token.records.HookDispatchStreamBuilder;
import com.hedera.node.app.spi.workflows.DispatchOptions;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class HookDispatchUtils {
    public static long dispatchHookDeletions(@NonNull HandleContext context, List<Long> hooksToDelete, long headBefore, AccountID ownerId) {
        long currentHead = headBefore;
        for (Long hookId : hooksToDelete) {
            HookDispatchTransactionBody hookDispatch = HookDispatchTransactionBody.newBuilder().hookIdToDelete(new HookId(HookEntityId.newBuilder().accountId(ownerId).build(), hookId.longValue())).build();
            HookDispatchStreamBuilder streamBuilder = (HookDispatchStreamBuilder)context.dispatch(DispatchOptions.hookDispatch((AccountID)context.payer(), (TransactionBody)TransactionBody.newBuilder().hookDispatch(hookDispatch).build(), HookDispatchStreamBuilder.class));
            HandleException.validateTrue((streamBuilder.status() == ResponseCodeEnum.SUCCESS ? 1 : 0) != 0, (ResponseCodeEnum)streamBuilder.status());
            if (hookId != currentHead) continue;
            currentHead = streamBuilder.getNextHookId();
        }
        return currentHead;
    }

    public static void dispatchHookCreations(HandleContext context, List<HookCreationDetails> creations, Long currentHead, AccountID owner) {
        HookEntityId ownerId = HookEntityId.newBuilder().accountId(owner).build();
        Long nextId = currentHead == 0L ? null : currentHead;
        for (int i = creations.size() - 1; i >= 0; --i) {
            HookCreationDetails d = creations.get(i);
            HookCreation.Builder creation = HookCreation.newBuilder().entityId(ownerId).details(d);
            if (nextId != null) {
                creation.nextHookId(nextId);
            }
            HookDispatchUtils.dispatchCreation(context, creation.build());
            nextId = d.hookId();
        }
    }

    static void dispatchCreation(@NonNull HandleContext context, HookCreation creation) {
        HookDispatchTransactionBody hookDispatch = HookDispatchTransactionBody.newBuilder().creation(creation).build();
        HookDispatchStreamBuilder streamBuilder = (HookDispatchStreamBuilder)context.dispatch(DispatchOptions.hookDispatch((AccountID)context.payer(), (TransactionBody)TransactionBody.newBuilder().hookDispatch(hookDispatch).build(), HookDispatchStreamBuilder.class));
        HandleException.validateTrue((streamBuilder.status() == ResponseCodeEnum.SUCCESS ? 1 : 0) != 0, (ResponseCodeEnum)streamBuilder.status());
    }

    public static void validateHookDuplicates(List<HookCreationDetails> details) throws PreCheckException {
        Set hookIds;
        if (!details.isEmpty() && (hookIds = details.stream().map(HookCreationDetails::hookId).collect(Collectors.toSet())).size() != details.size()) {
            throw new PreCheckException(ResponseCodeEnum.HOOK_ID_REPEATED_IN_CREATION_DETAILS);
        }
    }

    public static void validateHookDuplicates(List<HookCreationDetails> details, List<Long> hookIdsToDelete) throws PreCheckException {
        HookDispatchUtils.validateHookDuplicates(details);
        if (!hookIdsToDelete.isEmpty()) {
            PreCheckException.validateTruePreCheck((hookIdsToDelete.stream().distinct().count() == (long)hookIdsToDelete.size() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_ID_REPEATED_IN_CREATION_DETAILS);
        }
    }

    public static void dispatchExecution(@NonNull HandleContext context, HookExecution execution) {
        HookDispatchTransactionBody hookDispatch = HookDispatchTransactionBody.newBuilder().execution(execution).build();
        HookDispatchStreamBuilder streamBuilder = (HookDispatchStreamBuilder)context.dispatch(DispatchOptions.hookDispatch((AccountID)context.payer(), (TransactionBody)TransactionBody.newBuilder().hookDispatch(hookDispatch).build(), HookDispatchStreamBuilder.class));
        HandleException.validateTrue((streamBuilder.status() == ResponseCodeEnum.SUCCESS ? 1 : 0) != 0, (ResponseCodeEnum)streamBuilder.status());
    }
}

