/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records.impl.producers.formats.v7;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.hapi.streams.HashObject;
import com.hedera.hapi.streams.TransactionSidecarRecord;
import com.hedera.hapi.streams.schema.RecordStreamFileSchema;
import com.hedera.node.app.records.impl.producers.BlockRecordFormat;
import com.hedera.node.app.records.impl.producers.SerializedSingleTransactionRecord;
import com.hedera.node.app.state.SingleTransactionRecord;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.hiero.base.crypto.DigestType;

public final class BlockRecordFormatV7
implements BlockRecordFormat {
    public static final int VERSION_7 = 7;
    public static final BlockRecordFormat INSTANCE = new BlockRecordFormatV7();
    private boolean hasFirstItemBeenSerializedYet = false;

    private BlockRecordFormatV7() {
    }

    @Override
    public SerializedSingleTransactionRecord serialize(@NonNull SingleTransactionRecord singleTransactionRecord, long blockNumber, @NonNull SemanticVersion hapiVersion) {
        try {
            List<Bytes> sideCarItemsBytes = singleTransactionRecord.transactionSidecarRecords().stream().map(arg_0 -> ((Codec)TransactionSidecarRecord.PROTOBUF).toBytes(arg_0)).toList();
            Bytes sidecarHash = null;
            if (!sideCarItemsBytes.isEmpty()) {
                MessageDigest sidecarMessageDigest = MessageDigest.getInstance(DigestType.SHA_384.algorithmName());
                for (Bytes sideCarItem : sideCarItemsBytes) {
                    sideCarItem.writeTo(sidecarMessageDigest);
                }
                sidecarHash = Bytes.wrap((byte[])sidecarMessageDigest.digest());
            }
            RecordStreamItemV7 recordStreamItemV7 = this.hasFirstItemBeenSerializedYet ? new RecordStreamItemV7(singleTransactionRecord.transaction(), singleTransactionRecord.transactionRecord(), sidecarHash, null, 0L, 0) : new RecordStreamItemV7(singleTransactionRecord.transaction(), singleTransactionRecord.transactionRecord(), sidecarHash, hapiVersion, blockNumber, 7);
            this.hasFirstItemBeenSerializedYet = true;
            return new SerializedSingleTransactionRecord(null, RecordStreamItemV7.PROTOBUF.toBytes((Object)recordStreamItemV7), sideCarItemsBytes, singleTransactionRecord.transactionSidecarRecords());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Bytes computeNewRunningHash(@NonNull Bytes startRunningHash, @NonNull List<SerializedSingleTransactionRecord> serializedItems) {
        try {
            byte[] previousHash = startRunningHash.toByteArray();
            MessageDigest messageDigest = MessageDigest.getInstance(DigestType.SHA_384.algorithmName());
            for (int i = 0; i < serializedItems.size(); ++i) {
                Bytes serializedItem = serializedItems.get(i).protobufSerializedRecordStreamItem();
                serializedItem.writeTo(messageDigest);
                byte[] serializedItemHash = messageDigest.digest();
                messageDigest.update(previousHash);
                messageDigest.update(serializedItemHash);
                previousHash = messageDigest.digest();
            }
            return Bytes.wrap((byte[])previousHash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeHeader(@NonNull WritableStreamingData outputStream, @NonNull SemanticVersion hapiProtoVersion, @NonNull HashObject startObjectRunningHash) {
        try {
            outputStream.writeInt(7);
            ProtoWriterTools.writeMessage((WritableSequentialData)outputStream, (FieldDefinition)RecordStreamFileSchema.START_OBJECT_RUNNING_HASH, (Object)startObjectRunningHash, (Codec)HashObject.PROTOBUF);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeRecordStreamItem(@NonNull WritableStreamingData outputStream, @NonNull SerializedSingleTransactionRecord item) {
        Bytes itemBytes = item.protobufSerializedRecordStreamItem();
        outputStream.writeVarInt(RecordStreamFileSchema.RECORD_STREAM_ITEMS.number() << 3 | 2, false);
        outputStream.writeVarInt((int)itemBytes.length(), false);
        outputStream.writeBytes((RandomAccessData)itemBytes);
    }

    public record RecordStreamItemV7(@Nullable Transaction transaction, @Nullable TransactionRecord transactionRecord, @Nullable Bytes hashOfSidecarItems, @Nullable SemanticVersion hapiVersion, long blockNumber, int recordFileVersion) {
        public static final Codec<RecordStreamItemV7> PROTOBUF = new RecordStreamItemV7ProtoCodec();
    }

    public static final class RecordStreamItemV7ProtoCodec
    implements Codec<RecordStreamItemV7> {
        private static final RecordStreamItemV7 DEFAULT_VALUE = new RecordStreamItemV7(null, null, null, null, 0L, 0);

        public RecordStreamItemV7 getDefaultInstance() {
            return DEFAULT_VALUE;
        }

        @NonNull
        public RecordStreamItemV7 parse(@NonNull ReadableSequentialData readableSequentialData, boolean strictMode, boolean parseUnknownFields, int maxDepth) throws ParseException {
            return new RecordStreamItemV7(null, null, null, null, 0L, 0);
        }

        @NonNull
        public RecordStreamItemV7 parse(@NonNull ReadableSequentialData input, boolean strictMode, int maxDepth) {
            return new RecordStreamItemV7(null, null, null, null, 0L, 0);
        }

        public void write(@NonNull RecordStreamItemV7 item, @NonNull WritableSequentialData output) {
        }

        public int measure(@NonNull ReadableSequentialData input) {
            return 0;
        }

        public int measureRecord(RecordStreamItemV7 item) {
            return 0;
        }

        public boolean fastEquals(@NonNull RecordStreamItemV7 item, @NonNull ReadableSequentialData input) {
            return false;
        }
    }
}

