/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.ParallelUnsortedBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.factory.Bags;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.bag.mutable.AbstractMutableBagIterable;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.SynchronizedBag;
import org.eclipse.collections.impl.bag.mutable.UnmodifiableBag;
import org.eclipse.collections.impl.lazy.parallel.bag.NonParallelUnsortedBag;
import org.eclipse.collections.impl.partition.bag.PartitionHashBag;
import org.eclipse.collections.impl.utility.Iterate;

public abstract class AbstractMutableBag<T>
extends AbstractMutableBagIterable<T>
implements MutableBag<T> {
    public ImmutableBag<T> toImmutable() {
        return Bags.immutable.withAll((Iterable)this);
    }

    public UnmodifiableBag<T> asUnmodifiable() {
        return UnmodifiableBag.of(this);
    }

    public SynchronizedBag<T> asSynchronized() {
        return new SynchronizedBag(this);
    }

    public MutableBag<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }

    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        HashBag result = HashBag.newBag();
        this.forEachWithOccurrences((ObjectIntProcedure & Serializable)(each, occurrences) -> {
            if (clazz.isInstance(each)) {
                result.addOccurrences(each, occurrences);
            }
        });
        return result;
    }

    public MutableBag<T> select(Predicate<? super T> predicate) {
        return this.select(predicate, this.newEmpty());
    }

    public <P> MutableBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.selectWith(predicate, parameter, this.newEmpty());
    }

    public MutableBag<T> reject(Predicate<? super T> predicate) {
        return this.reject(predicate, this.newEmpty());
    }

    public <P> MutableBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.rejectWith(predicate, parameter, this.newEmpty());
    }

    public PartitionMutableBag<T> partition(Predicate<? super T> predicate) {
        PartitionHashBag result = new PartitionHashBag();
        this.forEachWithOccurrences((ObjectIntProcedure & Serializable)(each, index) -> {
            MutableBag bucket = predicate.accept(each) ? result.getSelected() : result.getRejected();
            bucket.addOccurrences(each, index);
        });
        return result;
    }

    public <P> PartitionMutableBag<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        PartitionHashBag result = new PartitionHashBag();
        this.forEachWithOccurrences((ObjectIntProcedure & Serializable)(each, index) -> {
            MutableBag bucket = predicate.accept(each, parameter) ? result.getSelected() : result.getRejected();
            bucket.addOccurrences(each, index);
        });
        return result;
    }

    @Override
    public <V> MutableBag<V> countBy(Function<? super T, ? extends V> function) {
        return this.collect(function);
    }

    @Override
    public <V, P> MutableBag<V> countByWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collectWith(function, parameter);
    }

    @Override
    public <V> MutableBag<V> countByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect(function);
    }

    public <V> MutableBag<V> collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        return (MutableBag)this.collectWithOccurrences(function, (Collection)Bags.mutable.empty());
    }

    public <V> MutableBag<V> collect(Function<? super T, ? extends V> function) {
        return this.collect(function, HashBag.newBag());
    }

    public <P, V> MutableBag<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collectWith(function, parameter, HashBag.newBag());
    }

    public <V> MutableBag<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.collectIf(predicate, function, HashBag.newBag());
    }

    public <V> MutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect(function, HashBag.newBag());
    }

    @Deprecated
    public <S> MutableBag<Pair<T, S>> zip(Iterable<S> that) {
        if (that instanceof Collection || that instanceof RichIterable) {
            int thatSize = Iterate.sizeOf(that);
            HashBag target = HashBag.newBag(Math.min(this.size(), thatSize));
            return this.zip(that, target);
        }
        return this.zip(that, HashBag.newBag());
    }

    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        return this.zipWithIndex(Sets.mutable.empty());
    }

    @Beta
    public ParallelUnsortedBag<T> asParallel(ExecutorService executorService, int batchSize) {
        if (executorService == null) {
            throw new NullPointerException();
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException();
        }
        return new NonParallelUnsortedBag(this);
    }
}

