/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes.parameters;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Preconditions;
import org.checkerframework.checker.signedness.qual.Unsigned;

public class UnsignedLongParameter {
    private final @Unsigned long value;

    @JsonCreator
    public UnsignedLongParameter(String value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0);
        this.value = value.startsWith("0x") ? Long.parseUnsignedLong(value.substring(2), 16) : Long.parseUnsignedLong(value, 16);
    }

    @JsonCreator
    public UnsignedLongParameter(@Unsigned long value) {
        this.value = value;
    }

    public @Unsigned long getValue() {
        return this.value;
    }
}

