/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.token.TokenReference;
import com.hedera.hapi.node.token.TokenRejectTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.SingletonUsageProperties;
import com.hedera.node.app.hapi.fees.usage.token.entities.TokenEntitySizes;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableNftStore;
import com.hedera.node.app.service.token.impl.WritableTokenRelationStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.hedera.node.app.service.token.impl.handlers.BaseTokenHandler;
import com.hedera.node.app.service.token.impl.handlers.transfer.AdjustFungibleTokenChangesStep;
import com.hedera.node.app.service.token.impl.handlers.transfer.NFTOwnersChangeStep;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferContextImpl;
import com.hedera.node.app.service.token.impl.util.CryptoTransferHelper;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.FeesConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.data.TokensConfig;
import com.swirlds.base.utility.Pair;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenRejectHandler
extends BaseTokenHandler
implements TransactionHandler {
    @Inject
    public TokenRejectHandler() {
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        TokenRejectTransactionBody op = txn.tokenRejectOrThrow();
        if (op.hasOwner()) {
            ReadableAccountStore accountStore = (ReadableAccountStore)context.createStore(ReadableAccountStore.class);
            this.verifyOwnerAndRequireKey(op.ownerOrThrow(), context, accountStore);
        }
    }

    private void verifyOwnerAndRequireKey(@NonNull AccountID ownerId, @NonNull PreHandleContext context, @NonNull ReadableAccountStore accountStore) throws PreCheckException {
        Account ownerAccount = accountStore.getAliasedAccountById(ownerId);
        PreCheckException.validateTruePreCheck((ownerAccount != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_OWNER_ID);
        Key key = ownerAccount.key();
        if (key == null || !KeyUtils.isValid((Key)key)) {
            throw new PreCheckException(ResponseCodeEnum.ACCOUNT_IS_IMMUTABLE);
        }
        context.requireKey(key);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        Objects.requireNonNull(txn, "Transaction body cannot be null");
        TokenRejectTransactionBody op = txn.tokenRejectOrThrow();
        PreCheckException.validateFalsePreCheck((boolean)op.rejections().isEmpty(), (ResponseCodeEnum)ResponseCodeEnum.EMPTY_TOKEN_REFERENCE_LIST);
        if (op.hasOwner()) {
            Validations.validateAccountID((AccountID)op.owner(), null);
        }
        HashSet<TokenReference> uniqueTokenReferences = new HashSet<TokenReference>();
        for (TokenReference rejection : op.rejections()) {
            if (!uniqueTokenReferences.add(rejection)) {
                throw new PreCheckException(ResponseCodeEnum.TOKEN_REFERENCE_REPEATED);
            }
            PreCheckException.validateFalsePreCheck((rejection.hasFungibleToken() && rejection.hasNft() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TRANSACTION_BODY);
            if (rejection.hasFungibleToken()) {
                TokenID tokenID = rejection.fungibleToken();
                PreCheckException.validateTruePreCheck((tokenID != null && !tokenID.equals((Object)TokenID.DEFAULT) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
            }
            if (!rejection.hasNft()) continue;
            NftID nftID = rejection.nft();
            PreCheckException.validateTruePreCheck((nftID != null && nftID.tokenId() != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NFT_ID);
            PreCheckException.validateTruePreCheck((nftID.serialNumber() > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_NFT_SERIAL_NUMBER);
        }
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        TokenRejectTransactionBody op = context.body().tokenRejectOrThrow();
        AccountID rejectingAccountID = op.ownerOrElse(context.payer());
        List rejections = op.rejections();
        LedgerConfig ledgerConfig = (LedgerConfig)context.configuration().getConfigData(LedgerConfig.class);
        TokensConfig tokensConfig = (TokensConfig)context.configuration().getConfigData(TokensConfig.class);
        HandleException.validateTrue((boolean)tokensConfig.tokenRejectEnabled(), (ResponseCodeEnum)ResponseCodeEnum.NOT_SUPPORTED);
        HandleException.validateTrue((rejections.size() <= ledgerConfig.tokenRejectsMaxLen() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_REFERENCE_LIST_SIZE_LIMIT_EXCEEDED);
        WritableAccountStore accountStore = (WritableAccountStore)context.storeFactory().writableStore(WritableAccountStore.class);
        Account rejectingAccount = TokenHandlerHelper.getIfUsableForAliasedId(rejectingAccountID, accountStore, context.expiryValidator(), ResponseCodeEnum.INVALID_ACCOUNT_ID);
        List<TokenTransferList> processedRejectTransfers = this.processRejectionsForTransfer(rejections, context, rejectingAccount);
        TransferContextImpl transferContext = new TransferContextImpl(context);
        AdjustFungibleTokenChangesStep fungibleTokensStep = new AdjustFungibleTokenChangesStep(processedRejectTransfers, context.payer());
        NFTOwnersChangeStep nftOwnersChangeStep = new NFTOwnersChangeStep(processedRejectTransfers, context.payer());
        fungibleTokensStep.doIn(transferContext);
        nftOwnersChangeStep.doIn(transferContext);
    }

    private List<TokenTransferList> processRejectionsForTransfer(@NonNull List<TokenReference> rejections, @NonNull HandleContext context, @NonNull Account rejectingAccount) {
        WritableTokenStore tokenStore = (WritableTokenStore)context.storeFactory().writableStore(WritableTokenStore.class);
        WritableNftStore nftStore = (WritableNftStore)context.storeFactory().writableStore(WritableNftStore.class);
        WritableTokenRelationStore relStore = (WritableTokenRelationStore)context.storeFactory().writableStore(WritableTokenRelationStore.class);
        AccountID accountID = rejectingAccount.accountIdOrThrow();
        List<TokenTransferList> fungibleTransfers = rejections.stream().filter(TokenReference::hasFungibleToken).map(rejection -> this.processFungibleTokenRejection((TokenReference)rejection, rejectingAccount, tokenStore, relStore)).toList();
        List<TokenTransferList> nftTransfers = rejections.stream().filter(TokenReference::hasNft).map(rejection -> this.processNFTTokenRejection(rejection.nftOrThrow(), accountID, nftStore, tokenStore)).collect(Collectors.groupingBy(Pair::left, Collectors.mapping(Pair::right, Collectors.toList()))).entrySet().stream().map(tokenIdNFTPair -> CryptoTransferHelper.createNftTransfer((TokenID)tokenIdNFTPair.getKey(), (List)tokenIdNFTPair.getValue())).toList();
        ArrayList<TokenTransferList> tokenTransferLists = new ArrayList<TokenTransferList>();
        tokenTransferLists.addAll(fungibleTransfers);
        tokenTransferLists.addAll(nftTransfers);
        return tokenTransferLists;
    }

    private Pair<TokenID, NftTransfer> processNFTTokenRejection(@NonNull NftID nftID, @NonNull AccountID rejectingAccountID, @NonNull WritableNftStore nftStore, @NonNull WritableTokenStore tokenStore) {
        Nft nft = TokenHandlerHelper.getIfUsable(nftID, nftStore);
        Token token = TokenHandlerHelper.getIfUsable(nftID.tokenIdOrThrow(), tokenStore);
        AccountID tokenTreasury = token.treasuryAccountIdOrThrow();
        HandleException.validateTrue((!tokenTreasury.equals((Object)rejectingAccountID) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_IS_TREASURY);
        HandleException.validateTrue((nft.hasOwnerId() && rejectingAccountID.equals((Object)nft.ownerId()) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_OWNER_ID);
        return Pair.of((Object)token.tokenId(), (Object)CryptoTransferHelper.nftTransfer(rejectingAccountID, tokenTreasury, nftID.serialNumber()));
    }

    private TokenTransferList processFungibleTokenRejection(@NonNull TokenReference rejection, @NonNull Account rejectingAccount, @NonNull WritableTokenStore tokenStore, @NonNull WritableTokenRelationStore relStore) {
        AccountID accountID = rejectingAccount.accountIdOrThrow();
        Token token = TokenHandlerHelper.getIfUsable(rejection.fungibleTokenOrThrow(), tokenStore);
        TokenID tokenId = token.tokenIdOrThrow();
        TokenRelation tokenRelation = TokenHandlerHelper.getIfUsable(accountID, tokenId, relStore);
        HandleException.validateTrue((token.treasuryAccountId() != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TREASURY_ACCOUNT_FOR_TOKEN);
        HandleException.validateTrue((!token.treasuryAccountId().equals((Object)accountID) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_IS_TREASURY);
        HandleException.validateTrue((tokenRelation.balance() > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_TOKEN_BALANCE);
        return CryptoTransferHelper.createFungibleTransfer(tokenId, accountID, tokenRelation.balance(), token.treasuryAccountId());
    }

    @NonNull
    public Fees calculateFees(FeeContext feeContext) {
        TransactionBody body = feeContext.body();
        TokenRejectTransactionBody op = body.tokenRejectOrThrow();
        Configuration config = feeContext.configuration();
        int tokenMultiplier = ((FeesConfig)Objects.requireNonNull(config).getConfigData(FeesConfig.class)).tokenTransferUsageMultiplier();
        int totalRejections = op.rejections().size();
        int numOfFungibleTokenRejections = 0;
        int numOfNFTRejections = 0;
        for (TokenReference rejection : op.rejections()) {
            if (rejection.hasFungibleToken()) {
                numOfFungibleTokenRejections += 2;
                continue;
            }
            ++numOfNFTRejections;
        }
        int weightedTokensInvolved = tokenMultiplier * totalRejections;
        int weightedFungibleTokens = tokenMultiplier * numOfFungibleTokenRejections;
        long bpt = this.calculateBytesPerTransaction(weightedTokensInvolved, weightedFungibleTokens, numOfNFTRejections);
        long rbs = SingletonUsageProperties.USAGE_PROPERTIES.legacyReceiptStorageSecs() * bpt;
        return feeContext.feeCalculatorFactory().feeCalculator(this.getSubType(numOfNFTRejections)).addBytesPerTransaction(bpt).addRamByteSeconds(rbs).calculate();
    }

    private SubType getSubType(int numOfNFTRejections) {
        return numOfNFTRejections != 0 ? SubType.TOKEN_NON_FUNGIBLE_UNIQUE : SubType.TOKEN_FUNGIBLE_COMMON;
    }

    private long calculateBytesPerTransaction(int weightedTokensInvolved, int weightedFungibleTokens, int numNFTRejections) {
        return TokenEntitySizes.TOKEN_ENTITY_SIZES.bytesUsedToRecordTokenTransfers(weightedTokensInvolved, weightedFungibleTokens, numNFTRejections);
    }
}

