/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer.customfees;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.hapi.node.transaction.RoyaltyFee;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.AdjustmentUtils;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.AssessmentResult;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.CustomFeeExemptions;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.CustomFixedFeeAssessor;
import com.hedera.node.app.spi.workflows.HandleException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.Pair;

@Singleton
public class CustomRoyaltyFeeAssessor {
    private final CustomFixedFeeAssessor fixedFeeAssessor;

    @Inject
    public CustomRoyaltyFeeAssessor(CustomFixedFeeAssessor fixedFeeAssessor) {
        this.fixedFeeAssessor = fixedFeeAssessor;
    }

    public void assessRoyaltyFees(@NonNull Token token, @NonNull AccountID sender, @NonNull AccountID receiver, @NonNull AssessmentResult result) {
        TokenID tokenId = token.tokenId();
        if (result.getRoyaltiesPaid().contains(Pair.of((Object)sender, (Object)tokenId))) {
            return;
        }
        List<AdjustmentUtils.ExchangedValue> exchangedValue = AdjustmentUtils.getFungibleCredits(result, sender);
        for (CustomFee fee : token.customFees()) {
            AccountID collector = fee.feeCollectorAccountId();
            if (!((CustomFee.FeeOneOfType)fee.fee().kind()).equals((Object)CustomFee.FeeOneOfType.ROYALTY_FEE)) continue;
            RoyaltyFee royaltyFee = fee.royaltyFeeOrThrow();
            if (exchangedValue.isEmpty()) {
                if (!royaltyFee.hasFallbackFee() || result.getRoyaltiesPaid().contains(Pair.of((Object)receiver, (Object)tokenId))) continue;
                FixedFee fallback = royaltyFee.fallbackFeeOrThrow();
                CustomFee fallbackFee = AdjustmentUtils.asFixedFee(fallback.amount(), fallback.denominatingTokenId(), collector, fee.allCollectorsAreExempt());
                this.fixedFeeAssessor.assessFixedFee(token, receiver, fallbackFee, result);
                continue;
            }
            if (CustomFeeExemptions.isPayerExempt(token, fee, sender)) continue;
            this.chargeRoyalty(exchangedValue, fee, result);
        }
        if (exchangedValue.isEmpty()) {
            result.addToRoyaltiesPaid((Pair<AccountID, TokenID>)Pair.of((Object)receiver, (Object)tokenId));
        } else {
            result.addToRoyaltiesPaid((Pair<AccountID, TokenID>)Pair.of((Object)sender, (Object)tokenId));
        }
    }

    private void chargeRoyalty(@NonNull List<AdjustmentUtils.ExchangedValue> exchangedValues, @NonNull CustomFee fee, @NonNull AssessmentResult result) {
        for (AdjustmentUtils.ExchangedValue exchange : exchangedValues) {
            AccountID account = exchange.account();
            long amount = exchange.amount();
            TokenID denom = exchange.tokenId();
            RoyaltyFee royaltySpec = fee.royaltyFeeOrThrow();
            AccountID feeCollector = fee.feeCollectorAccountIdOrThrow();
            try {
                long royalty = AdjustmentUtils.safeFractionMultiply(royaltySpec.exchangeValueFraction().numerator(), royaltySpec.exchangeValueFraction().denominator(), amount);
                HandleException.validateTrue((royalty <= amount ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE);
                if (denom != null) {
                    this.redirectHtsRoyaltyFee(result, account, feeCollector, royalty, denom);
                } else {
                    this.redirectHbarRoyaltyFee(result, account, feeCollector, royalty);
                }
                AssessedCustomFee.Builder assessedCustomFeeBuilder = AssessedCustomFee.newBuilder().amount(royalty).feeCollectorAccountId(feeCollector).effectivePayerAccountId(new AccountID[]{account});
                if (denom != null) {
                    result.addAssessedCustomFee(assessedCustomFeeBuilder.tokenId(denom).build());
                    continue;
                }
                result.addAssessedCustomFee(assessedCustomFeeBuilder.build());
            }
            catch (ArithmeticException e) {
                throw new HandleException(ResponseCodeEnum.INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE);
            }
        }
    }

    private void redirectHtsRoyaltyFee(@NonNull AssessmentResult result, @NonNull AccountID account, @NonNull AccountID feeCollector, long royalty, @NonNull TokenID denom) {
        Map<AccountID, Long> htsAdjustments = result.getHtsAdjustments().computeIfAbsent(denom, AdjustmentUtils.ADJUSTMENTS_MAP_FACTORY);
        Map<AccountID, Long> mutableInputHtsAdjustments = result.getMutableInputBalanceAdjustments().get(denom);
        mutableInputHtsAdjustments.merge(account, -royalty, AdjustmentUtils::addExactOrThrow);
        htsAdjustments.merge(feeCollector, royalty, AdjustmentUtils::addExactOrThrow);
    }

    private void redirectHbarRoyaltyFee(@NonNull AssessmentResult result, @NonNull AccountID account, @NonNull AccountID feeCollector, long royalty) {
        Map<AccountID, Long> hbarAdjustments = result.getHbarAdjustments();
        Map<AccountID, Long> mutableHbarAdjustments = result.getMutableInputBalanceAdjustments().get(AssessmentResult.HBAR_TOKEN_ID);
        mutableHbarAdjustments.merge(account, -royalty, AdjustmentUtils::addExactOrThrow);
        hbarAdjustments.merge(feeCollector, royalty, AdjustmentUtils::addExactOrThrow);
    }
}

