/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.util;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableNftStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class TokenHandlerHelper {
    private TokenHandlerHelper() {
        throw new UnsupportedOperationException("Utility class only");
    }

    @NonNull
    public static Account getIfUsable(@NonNull AccountID accountId, @NonNull ReadableAccountStore accountStore, @NonNull ExpiryValidator expiryValidator, @NonNull ResponseCodeEnum errorIfNotUsable) {
        return TokenHandlerHelper.getIfUsable(accountId, accountStore, expiryValidator, errorIfNotUsable, ResponseCodeEnum.ACCOUNT_DELETED, AccountIDType.NOT_ALIASED_ID);
    }

    @NonNull
    public static Account getIfUsable(@NonNull AccountID accountId, @NonNull ReadableAccountStore accountStore, @NonNull ExpiryValidator expiryValidator, @NonNull ResponseCodeEnum errorIfNotUsable, @NonNull ResponseCodeEnum errorOnAccountDeleted, @NonNull AccountIDType accountIDType) {
        Objects.requireNonNull(accountId);
        Objects.requireNonNull(accountStore);
        Objects.requireNonNull(expiryValidator);
        Objects.requireNonNull(errorIfNotUsable);
        Objects.requireNonNull(errorOnAccountDeleted);
        Account acct = accountIDType == AccountIDType.ALIASED_ID ? accountStore.getAliasedAccountById(accountId) : accountStore.getAccountById(accountId);
        HandleException.validateTrue((acct != null ? 1 : 0) != 0, (ResponseCodeEnum)errorIfNotUsable);
        boolean isContract = acct.smartContract();
        HandleException.validateFalse((boolean)acct.deleted(), (ResponseCodeEnum)errorOnAccountDeleted);
        EntityType type = isContract ? EntityType.CONTRACT_BYTECODE : EntityType.ACCOUNT;
        ResponseCodeEnum expiryStatus = expiryValidator.expirationStatus(type, acct.expiredAndPendingRemoval(), acct.tinybarBalance());
        HandleException.validateTrue((expiryStatus == ResponseCodeEnum.OK ? 1 : 0) != 0, (ResponseCodeEnum)expiryStatus);
        return acct;
    }

    public static Token getIfUsable(@NonNull TokenID tokenId, @NonNull ReadableTokenStore tokenStore) {
        return TokenHandlerHelper.getIfUsable(tokenId, tokenStore, TokenValidations.REQUIRE_NOT_PAUSED);
    }

    @NonNull
    public static Token getIfUsable(@NonNull TokenID tokenId, @NonNull ReadableTokenStore tokenStore, @NonNull TokenValidations tokenValidations) {
        return TokenHandlerHelper.getIfUsable(tokenId, tokenStore, tokenValidations, null);
    }

    @NonNull
    public static Token getIfUsable(@NonNull TokenID tokenId, @NonNull ReadableTokenStore tokenStore, @NonNull TokenValidations tokenValidations, @Nullable ResponseCodeEnum errorIfNotUsable) {
        Objects.requireNonNull(tokenId);
        Objects.requireNonNull(tokenStore);
        Objects.requireNonNull(tokenValidations);
        Token token = tokenStore.get(tokenId);
        HandleException.validateTrue((token != null ? 1 : 0) != 0, (ResponseCodeEnum)(errorIfNotUsable == null ? ResponseCodeEnum.INVALID_TOKEN_ID : errorIfNotUsable));
        HandleException.validateFalse((boolean)token.deleted(), (ResponseCodeEnum)(errorIfNotUsable == null ? ResponseCodeEnum.TOKEN_WAS_DELETED : errorIfNotUsable));
        if (tokenValidations == TokenValidations.REQUIRE_NOT_PAUSED) {
            HandleException.validateFalse((boolean)token.paused(), (ResponseCodeEnum)(errorIfNotUsable == null ? ResponseCodeEnum.TOKEN_IS_PAUSED : errorIfNotUsable));
        }
        return token;
    }

    @NonNull
    public static TokenRelation getIfUsable(@NonNull AccountID accountId, @NonNull TokenID tokenId, @NonNull ReadableTokenRelationStore tokenRelStore) {
        Objects.requireNonNull(accountId);
        Objects.requireNonNull(tokenId);
        Objects.requireNonNull(tokenRelStore);
        TokenRelation tokenRel = tokenRelStore.get(accountId, tokenId);
        HandleException.validateTrue((tokenRel != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_ACCOUNT);
        HandleException.validateTrue((!tokenRel.frozen() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_FROZEN_FOR_TOKEN);
        return tokenRel;
    }

    public static Nft getIfUsable(@NonNull NftID nftId, @NonNull ReadableNftStore nftStore) {
        Objects.requireNonNull(nftId);
        Objects.requireNonNull(nftStore);
        Nft nft = nftStore.get(nftId);
        HandleException.validateTrue((nft != null && nft.nftId() != null && nft.nftId().tokenId() != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NFT_ID);
        return nft;
    }

    @NonNull
    public static Account getIfUsableForAliasedId(@NonNull AccountID accountId, @NonNull ReadableAccountStore accountStore, @NonNull ExpiryValidator expiryValidator, @NonNull ResponseCodeEnum errorIfNotUsable) {
        return TokenHandlerHelper.getIfUsable(accountId, accountStore, expiryValidator, errorIfNotUsable, ResponseCodeEnum.ACCOUNT_DELETED, AccountIDType.ALIASED_ID);
    }

    @NonNull
    public static Account getIfUsableForAutoRenew(@NonNull AccountID accountId, @NonNull ReadableAccountStore accountStore, @NonNull ExpiryValidator expiryValidator, @NonNull ResponseCodeEnum errorIfNotUsable) {
        return TokenHandlerHelper.getIfUsable(accountId, accountStore, expiryValidator, errorIfNotUsable, ResponseCodeEnum.INVALID_AUTORENEW_ACCOUNT, AccountIDType.NOT_ALIASED_ID);
    }

    @NonNull
    public static Account getIfUsableWithTreasury(@NonNull AccountID accountId, @NonNull ReadableAccountStore accountStore, @NonNull ExpiryValidator expiryValidator, @NonNull ResponseCodeEnum errorIfNotUsable) {
        return TokenHandlerHelper.getIfUsable(accountId, accountStore, expiryValidator, errorIfNotUsable, ResponseCodeEnum.INVALID_TREASURY_ACCOUNT_FOR_TOKEN, AccountIDType.NOT_ALIASED_ID);
    }

    public static void verifyNotEmptyKey(@Nullable Key key, @NonNull ResponseCodeEnum responseCode) throws PreCheckException {
        if (HapiUtils.EMPTY_KEY_LIST.equals((Object)key)) {
            throw new PreCheckException(responseCode);
        }
    }

    public static enum AccountIDType {
        ALIASED_ID,
        NOT_ALIASED_ID;

    }

    public static enum TokenValidations {
        REQUIRE_NOT_PAUSED,
        PERMIT_PAUSED;

    }
}

