/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.services;

import com.swirlds.config.api.Configuration;
import com.swirlds.state.lifecycle.SchemaRegistry;
import com.swirlds.state.lifecycle.Service;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import org.hiero.base.constructable.ConstructableRegistry;

public interface ServicesRegistry {
    @NonNull
    public Set<Registration> registrations();

    public void register(@NonNull Service var1);

    @NonNull
    public ServicesRegistry subRegistryFor(String ... var1);

    public record Registration(@NonNull Service service, @NonNull SchemaRegistry registry) implements Comparable<Registration>
    {
        private static final Comparator<Registration> COMPARATOR = Comparator.comparingInt(r -> r.service().migrationOrder()).thenComparing(r -> r.service().getServiceName());

        public Registration {
            Objects.requireNonNull(service);
            Objects.requireNonNull(registry);
        }

        public String serviceName() {
            return this.service.getServiceName();
        }

        @Override
        public int compareTo(@NonNull Registration that) {
            return COMPARATOR.compare(this, that);
        }
    }

    public static interface Factory {
        public ServicesRegistry create(@NonNull ConstructableRegistry var1, @NonNull Configuration var2);
    }
}

