/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.handlers;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.contract.EthereumTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.ethereum.EthTxData;
import com.hedera.node.app.hapi.utils.ethereum.EthTxSigs;
import com.hedera.node.app.service.contract.impl.ContractServiceComponent;
import com.hedera.node.app.service.contract.impl.exec.CallOutcome;
import com.hedera.node.app.service.contract.impl.exec.TransactionComponent;
import com.hedera.node.app.service.contract.impl.handlers.AbstractContractTransactionHandler;
import com.hedera.node.app.service.contract.impl.hevm.HydratedEthTxData;
import com.hedera.node.app.service.contract.impl.infra.EthTxSigsCache;
import com.hedera.node.app.service.contract.impl.infra.EthereumCallDataHydration;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.node.app.service.contract.impl.records.ContractCreateStreamBuilder;
import com.hedera.node.app.service.contract.impl.records.EthereumTransactionStreamBuilder;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.file.ReadableFileStore;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.config.data.HederaConfig;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;

@Singleton
public class EthereumTransactionHandler
extends AbstractContractTransactionHandler {
    private final byte[] EMPTY_ADDRESS = new byte[20];
    private final EthTxSigsCache ethereumSignatures;
    private final EthereumCallDataHydration callDataHydration;

    @Inject
    public EthereumTransactionHandler(@NonNull EthTxSigsCache ethereumSignatures, @NonNull EthereumCallDataHydration callDataHydration, @NonNull Provider<TransactionComponent.Factory> provider, @NonNull GasCalculator gasCalculator, @NonNull ContractServiceComponent component) {
        super(provider, gasCalculator, component);
        this.ethereumSignatures = Objects.requireNonNull(ethereumSignatures);
        this.callDataHydration = Objects.requireNonNull(callDataHydration);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        this.computeEthTxSigsFor(context.body().ethereumTransactionOrThrow(), (ReadableFileStore)context.createStore(ReadableFileStore.class), context.configuration());
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        try {
            TransactionBody txn = context.body();
            EthTxData ethTxData = EthTxData.populateEthTxData((byte[])Objects.requireNonNull(txn.ethereumTransactionOrThrow().ethereumData()).toByteArray());
            PreCheckException.validateTruePreCheck((boolean)Objects.nonNull(ethTxData), (ResponseCodeEnum)ResponseCodeEnum.INVALID_ETHEREUM_TRANSACTION);
            byte[] callData = ethTxData.hasCallData() ? ethTxData.callData() : new byte[]{};
            long intrinsicGas = this.gasCalculator.transactionIntrinsicGasCost(Bytes.wrap((byte[])callData), false, 0L);
            PreCheckException.validateTruePreCheck((ethTxData.gasLimit() >= intrinsicGas ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_GAS);
            if (ethTxData.value().compareTo(BigInteger.ZERO) > 0) {
                PreCheckException.validateFalsePreCheck((boolean)Arrays.equals(ethTxData.to(), this.EMPTY_ADDRESS), (ResponseCodeEnum)ResponseCodeEnum.INVALID_SOLIDITY_ADDRESS);
            }
            if (ethTxData.hasToAddress()) {
                PreCheckException.validateTruePreCheck((ethTxData.to().length == 20 ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_CONTRACT_ID);
            }
        }
        catch (Exception e) {
            this.bumpExceptionMetrics(HederaFunctionality.ETHEREUM_TRANSACTION, e);
            if (e instanceof NullPointerException) {
                this.component.contractMetrics().incrementRejectedType3EthTx();
            }
            throw e;
        }
    }

    @Nullable
    public EthTxSigs maybeEthTxSigsFor(@NonNull EthereumTransactionBody op, @NonNull ReadableFileStore fileStore, @NonNull Configuration config) {
        Objects.requireNonNull(op);
        Objects.requireNonNull(config);
        Objects.requireNonNull(fileStore);
        try {
            return this.computeEthTxSigsFor(op, fileStore, config);
        }
        catch (PreCheckException ignore) {
            return null;
        }
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        TransactionComponent component = this.getTransactionComponent(context, HederaFunctionality.ETHEREUM_TRANSACTION);
        CallOutcome outcome = component.contextTransactionProcessor().call();
        HydratedEthTxData hydratedEthTxData = Objects.requireNonNull(component.hydratedEthTxData());
        EthTxData ethTxData = Objects.requireNonNull(hydratedEthTxData.ethTxData());
        EthereumTransactionStreamBuilder ethStreamBuilder = ((EthereumTransactionStreamBuilder)context.savepointStack().getBaseBuilder(EthereumTransactionStreamBuilder.class)).ethereumHash(com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])ethTxData.getEthereumHash()));
        if (outcome.hasNewSenderNonce()) {
            Optional nonceCallback = context.dispatchMetadata().getMetadata(HandleContext.DispatchMetadata.Type.ETHEREUM_NONCE_INCREMENT_CALLBACK, BiConsumer.class);
            long newNonce = outcome.newSenderNonceOrThrow();
            nonceCallback.ifPresent(cb -> cb.accept(outcome.txResult().senderId(), newNonce));
            ethStreamBuilder.newSenderNonce(newNonce);
        }
        if (ethTxData.hasToAddress()) {
            streamBuilder = (ContractCallStreamBuilder)context.savepointStack().getBaseBuilder(ContractCallStreamBuilder.class);
            outcome.addCallDetailsTo((ContractCallStreamBuilder)streamBuilder, context);
            ConversionUtils.throwIfUnsuccessfulCall(outcome, component.hederaOperations(), streamBuilder);
        } else {
            streamBuilder = (ContractCreateStreamBuilder)context.savepointStack().getBaseBuilder(ContractCreateStreamBuilder.class);
            outcome.addCreateDetailsTo((ContractCreateStreamBuilder)streamBuilder, context);
            ConversionUtils.throwIfUnsuccessfulCreate(outcome, component.hederaOperations());
        }
    }

    public void handleThrottled(@NonNull HandleContext context) {
        TransactionComponent component = this.getTransactionComponent(context, HederaFunctionality.ETHEREUM_TRANSACTION);
        HydratedEthTxData hydratedEthTxData = Objects.requireNonNull(component.hydratedEthTxData());
        EthTxData ethTxData = Objects.requireNonNull(hydratedEthTxData.ethTxData());
        ((EthereumTransactionStreamBuilder)context.savepointStack().getBaseBuilder(EthereumTransactionStreamBuilder.class)).ethereumHash(com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])ethTxData.getEthereumHash()));
    }

    @Override
    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        TransactionBody body = feeContext.body();
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).legacyCalculate(sigValueObj -> this.usageEstimator.getEthereumTransactionFeeMatrices(CommonPbjConverters.fromPbj((TransactionBody)body), sigValueObj));
    }

    private EthTxSigs computeEthTxSigsFor(@NonNull EthereumTransactionBody op, @NonNull ReadableFileStore fileStore, @NonNull Configuration config) throws PreCheckException {
        HederaConfig hederaConfig = (HederaConfig)config.getConfigData(HederaConfig.class);
        HydratedEthTxData hydratedTx = this.callDataHydration.tryToHydrate(op, fileStore, hederaConfig.firstUserEntity());
        PreCheckException.validateTruePreCheck((hydratedTx.status() == ResponseCodeEnum.OK ? 1 : 0) != 0, (ResponseCodeEnum)hydratedTx.status());
        EthTxData ethTxData = hydratedTx.ethTxData();
        PreCheckException.validateTruePreCheck((ethTxData != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ETHEREUM_TRANSACTION);
        try {
            return this.ethereumSignatures.computeIfAbsent(ethTxData);
        }
        catch (RuntimeException ignore) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_ETHEREUM_TRANSACTION);
        }
    }
}

