/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.hasschedulecapacity;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.HssCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.hasschedulecapacity.HasScheduleCapacityTranslator;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class HasScheduleCapacityCall
extends AbstractCall {
    private final long gasLimit;
    private final long consensusSecond;
    private final AccountID senderId;

    public HasScheduleCapacityCall(@NonNull HssCallAttempt attempt, long consensusSecond, long gasLimit) {
        this(attempt.enhancement(), attempt.systemContractGasCalculator(), consensusSecond, gasLimit, attempt.senderId());
    }

    public HasScheduleCapacityCall(@NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull SystemContractGasCalculator gasCalculator, long consensusSecond, long gasLimit, @NonNull AccountID senderId) {
        super(gasCalculator, enhancement, false);
        this.gasLimit = gasLimit;
        this.consensusSecond = consensusSecond;
        this.senderId = Objects.requireNonNull(senderId);
    }

    @Override
    public boolean allowsStaticFrame() {
        return true;
    }

    @Override
    @NonNull
    public Call.PricedResult execute(@NonNull MessageFrame frame) {
        boolean hasCapacity = this.nativeOperations().canScheduleContractCall(this.consensusSecond, this.gasLimit, this.senderId);
        return Call.PricedResult.gasOnly(FullResult.successResult(HasScheduleCapacityTranslator.HAS_SCHEDULE_CAPACITY.getOutputs().encode((Object)Tuple.singleton((Object)hasCapacity)), this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.SUCCESS, this.isViewCall);
    }
}

