/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.AccountApprovalForAllAllowance;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableNftStore;
import com.hedera.node.app.service.token.impl.WritableTokenRelationStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.hedera.node.app.service.token.impl.handlers.BaseTokenHandler;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferContext;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferStep;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;

public class NFTOwnersChangeStep
extends BaseTokenHandler
implements TransferStep {
    private final List<TokenTransferList> tokenTransferLists;
    private final AccountID topLevelPayer;

    public NFTOwnersChangeStep(List<TokenTransferList> tokenTransferLists, AccountID topLevelPayer) {
        this.tokenTransferLists = tokenTransferLists;
        this.topLevelPayer = topLevelPayer;
    }

    @Override
    public void doIn(TransferContext transferContext) {
        HandleContext handleContext = transferContext.getHandleContext();
        StoreFactory storeFactory = handleContext.storeFactory();
        WritableNftStore nftStore = (WritableNftStore)storeFactory.writableStore(WritableNftStore.class);
        WritableAccountStore accountStore = (WritableAccountStore)storeFactory.writableStore(WritableAccountStore.class);
        WritableTokenStore tokenStore = (WritableTokenStore)storeFactory.writableStore(WritableTokenStore.class);
        WritableTokenRelationStore tokenRelStore = (WritableTokenRelationStore)storeFactory.writableStore(WritableTokenRelationStore.class);
        ExpiryValidator expiryValidator = handleContext.expiryValidator();
        for (TokenTransferList xfers : this.tokenTransferLists) {
            TokenID tokenId = xfers.token();
            Token token = TokenHandlerHelper.getIfUsable(tokenId, tokenStore);
            for (NftTransfer nftTransfer : xfers.nftTransfers()) {
                AccountID senderId = nftTransfer.senderAccountIDOrThrow();
                AccountID receiverId = nftTransfer.receiverAccountIDOrThrow();
                long serial = nftTransfer.serialNumber();
                Account senderAccount = TokenHandlerHelper.getIfUsable(senderId, accountStore, expiryValidator, ResponseCodeEnum.INVALID_ACCOUNT_ID);
                Account receiverAccount = TokenHandlerHelper.getIfUsable(receiverId, accountStore, expiryValidator, ResponseCodeEnum.INVALID_ACCOUNT_ID);
                TokenRelation senderRel = TokenHandlerHelper.getIfUsable(senderId, tokenId, tokenRelStore);
                TokenRelation receiverRel = TokenHandlerHelper.getIfUsable(receiverId, tokenId, tokenRelStore);
                this.validateNotFrozenAndKycOnRelation(senderRel);
                this.validateNotFrozenAndKycOnRelation(receiverRel);
                AccountID treasuryId = token.treasuryAccountId();
                TokenHandlerHelper.getIfUsable(treasuryId, accountStore, expiryValidator, ResponseCodeEnum.INVALID_ACCOUNT_ID);
                Nft nft = nftStore.get(tokenId, serial);
                HandleException.validateTrue((nft != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NFT_ID);
                if (nftTransfer.isApproval()) {
                    NFTOwnersChangeStep.validateSpenderHasAllowance(senderAccount, this.topLevelPayer, tokenId, nft);
                }
                if (nft.hasOwnerId()) {
                    HandleException.validateTrue((boolean)nft.ownerId().equals((Object)senderId), (ResponseCodeEnum)ResponseCodeEnum.SENDER_DOES_NOT_OWN_NFT_SERIAL_NO);
                } else {
                    HandleException.validateTrue((boolean)treasuryId.equals((Object)senderId), (ResponseCodeEnum)ResponseCodeEnum.SENDER_DOES_NOT_OWN_NFT_SERIAL_NO);
                }
                this.updateOwnership(nft, treasuryId, senderAccount, receiverAccount, senderRel, receiverRel, accountStore, tokenRelStore, nftStore);
            }
        }
    }

    static void validateSpenderHasAllowance(Account owner, AccountID spender, TokenID tokenId, Nft nft) {
        AccountApprovalForAllAllowance allowance;
        List approveForAllAllowances = owner.approveForAllNftAllowances();
        if (!approveForAllAllowances.contains(allowance = AccountApprovalForAllAllowance.newBuilder().spenderId(spender).tokenId(tokenId).build())) {
            AccountID approvedSpender = nft.spenderId();
            HandleException.validateTrue((approvedSpender != null && approvedSpender.equals((Object)spender) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.SPENDER_DOES_NOT_HAVE_ALLOWANCE);
        }
    }

    private void updateOwnership(@NonNull Nft nft, @NonNull AccountID treasuryId, @NonNull Account senderAccount, @NonNull Account receiverAccount, TokenRelation senderRel, TokenRelation receiverRel, WritableAccountStore accountStore, WritableTokenRelationStore tokenRelStore, WritableNftStore nftStore) {
        Nft.Builder nftCopy = nft.copyBuilder();
        long fromNftsOwned = senderAccount.numberOwnedNfts();
        long toNftsOwned = receiverAccount.numberOwnedNfts();
        long fromTokenRelBalance = senderRel.balance();
        long toTokenRelBalance = receiverRel.balance();
        int fromNumPositiveBalances = senderAccount.numberPositiveBalances();
        int toNumPositiveBalances = receiverAccount.numberPositiveBalances();
        boolean isTreasuryReturn = treasuryId.equals((Object)receiverAccount.accountId());
        boolean isSenderTreasury = treasuryId.equals((Object)senderAccount.accountId());
        if (isTreasuryReturn) {
            nftCopy.ownerId((AccountID)null);
        } else {
            nftCopy.ownerId(receiverAccount.accountId());
        }
        nftCopy.spenderId((AccountID)null);
        nftStore.put(nftCopy.build());
        int updatedFromPositiveBalances = fromTokenRelBalance - 1L == 0L ? fromNumPositiveBalances - 1 : fromNumPositiveBalances;
        int updatedToPositiveBalances = toTokenRelBalance == 0L ? toNumPositiveBalances + 1 : toNumPositiveBalances;
        this.updateLinks(senderAccount, receiverAccount, nft.nftIdOrThrow(), isSenderTreasury, isTreasuryReturn, nftStore, accountStore);
        Account.Builder senderAccountCopy = Objects.requireNonNull(accountStore.get(senderAccount.accountIdOrThrow())).copyBuilder();
        Account.Builder receiverAccountCopy = Objects.requireNonNull(accountStore.get(receiverAccount.accountIdOrThrow())).copyBuilder();
        TokenRelation.Builder senderRelCopy = senderRel.copyBuilder();
        TokenRelation.Builder receiverRelCopy = receiverRel.copyBuilder();
        accountStore.put(senderAccountCopy.numberOwnedNfts(fromNftsOwned - 1L).numberPositiveBalances(updatedFromPositiveBalances).build());
        accountStore.put(receiverAccountCopy.numberOwnedNfts(toNftsOwned + 1L).numberPositiveBalances(updatedToPositiveBalances).build());
        tokenRelStore.put(senderRelCopy.balance(fromTokenRelBalance - 1L).build());
        tokenRelStore.put(receiverRelCopy.balance(toTokenRelBalance + 1L).build());
    }

    public void updateLinks(@NonNull Account from, @NonNull Account to, @NonNull NftID nftId, boolean isSenderTreasury, boolean isReceiverTreasury, WritableNftStore nftStore, WritableAccountStore accountStore) {
        if (!isSenderTreasury) {
            NFTOwnersChangeStep.removeFromList(nftId, nftStore, from, accountStore);
        }
        if (!isReceiverTreasury) {
            this.insertToList(nftId, nftStore, to, accountStore);
        } else {
            Nft nft = Objects.requireNonNull(nftStore.get(nftId));
            Nft.Builder nftCopy = nft.copyBuilder();
            nftCopy.ownerPreviousNftId((NftID)null);
            nftCopy.ownerNextNftId((NftID)null);
            nftStore.put(nftCopy.build());
        }
    }

    private void insertToList(@NonNull NftID nftId, @NonNull WritableNftStore nftStore, @NonNull Account to, @NonNull WritableAccountStore accountStore) {
        Nft nft = Objects.requireNonNull(nftStore.get(nftId));
        Nft.Builder nftCopy = nft.copyBuilder();
        if (to.hasHeadNftId()) {
            Nft headNft = Objects.requireNonNull(nftStore.get(to.headNftIdOrThrow()));
            Nft.Builder headCopy = headNft.copyBuilder();
            headCopy.ownerPreviousNftId(nftId);
            nftStore.put(headCopy.build());
            nftCopy.ownerNextNftId(to.headNftId());
        } else {
            nftCopy.ownerNextNftId((NftID)null);
        }
        nftCopy.ownerPreviousNftId((NftID)null);
        Account.Builder toAccountCopy = to.copyBuilder();
        toAccountCopy.headNftId(nftId);
        nftStore.put(nftCopy.build());
        accountStore.put(toAccountCopy.build());
    }

    public static void removeFromList(@NonNull NftID nftId, @NonNull WritableNftStore nftStore, @NonNull Account from, @NonNull WritableAccountStore accountStore) {
        Nft nft = Objects.requireNonNull(nftStore.get(nftId));
        if (!nft.hasOwnerPreviousNftId()) {
            Account.Builder accountCopy = from.copyBuilder();
            accountCopy.headNftId(nft.ownerNextNftId());
            accountStore.put(accountCopy.build());
        } else {
            Nft previousNft = Objects.requireNonNull(nftStore.get(nft.ownerPreviousNftIdOrThrow()));
            Nft.Builder previousCopy = previousNft.copyBuilder();
            previousCopy.ownerNextNftId(nft.ownerNextNftId());
            nftStore.put(previousCopy.build());
        }
        if (nft.hasOwnerNextNftId()) {
            Nft nextNft = Objects.requireNonNull(nftStore.get(nft.ownerNextNftIdOrThrow()));
            Nft.Builder nextCopy = nextNft.copyBuilder();
            nextCopy.ownerPreviousNftId(nft.ownerPreviousNftId());
            nftStore.put(nextCopy.build());
        }
    }
}

