/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.consensus.impl.handlers;

import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ResponseHeader;
import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.consensus.ConsensusGetTopicInfoQuery;
import com.hedera.hapi.node.consensus.ConsensusGetTopicInfoResponse;
import com.hedera.hapi.node.consensus.ConsensusTopicInfo;
import com.hedera.hapi.node.state.consensus.Topic;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.ConsensusServiceFeeBuilder;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.service.consensus.ReadableTopicStore;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.PaidQueryHandler;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.config.data.LedgerConfig;
import com.hederahashgraph.api.proto.java.FeeComponents;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.Key;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ConsensusGetTopicInfoHandler
extends PaidQueryHandler {
    @Inject
    public ConsensusGetTopicInfoHandler() {
    }

    public QueryHeader extractHeader(@NonNull Query query) {
        Objects.requireNonNull(query);
        return query.consensusGetTopicInfoOrThrow().header();
    }

    public Response createEmptyResponse(@NonNull ResponseHeader header) {
        Objects.requireNonNull(header);
        ConsensusGetTopicInfoResponse.Builder response = ConsensusGetTopicInfoResponse.newBuilder().header(header);
        return Response.newBuilder().consensusGetTopicInfo(response).build();
    }

    public boolean requiresNodePayment(@NonNull ResponseType responseType) {
        return responseType == ResponseType.ANSWER_ONLY || responseType == ResponseType.ANSWER_STATE_PROOF;
    }

    public boolean needsAnswerOnlyCost(@NonNull ResponseType responseType) {
        return ResponseType.COST_ANSWER == responseType;
    }

    public void validate(@NonNull QueryContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        Query query = context.query();
        ReadableTopicStore topicStore = (ReadableTopicStore)context.createStore(ReadableTopicStore.class);
        ConsensusGetTopicInfoQuery op = query.consensusGetTopicInfoOrThrow();
        if (op.hasTopicID()) {
            Topic topic = topicStore.getTopic(op.topicIDOrElse(TopicID.DEFAULT));
            Validations.mustExist((Object)topic, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOPIC_ID);
            if (topic.deleted()) {
                throw new PreCheckException(ResponseCodeEnum.INVALID_TOPIC_ID);
            }
        } else {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TOPIC_ID);
        }
    }

    public Response findResponse(@NonNull QueryContext context, @NonNull ResponseHeader header) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(header);
        Query query = context.query();
        LedgerConfig config = (LedgerConfig)context.configuration().getConfigData(LedgerConfig.class);
        ReadableTopicStore topicStore = (ReadableTopicStore)context.createStore(ReadableTopicStore.class);
        ConsensusGetTopicInfoQuery op = query.consensusGetTopicInfoOrThrow();
        ConsensusGetTopicInfoResponse.Builder response = ConsensusGetTopicInfoResponse.newBuilder();
        TopicID topic = op.topicIDOrElse(TopicID.DEFAULT);
        response.topicID(topic);
        ResponseType responseType = op.headerOrElse(QueryHeader.DEFAULT).responseType();
        response.header(header);
        if (header.nodeTransactionPrecheckCode() == ResponseCodeEnum.OK && responseType != ResponseType.COST_ANSWER) {
            Optional<ConsensusTopicInfo> optionalInfo = this.infoForTopic(topic, topicStore, config);
            optionalInfo.ifPresent(arg_0 -> ((ConsensusGetTopicInfoResponse.Builder)response).topicInfo(arg_0));
        }
        return Response.newBuilder().consensusGetTopicInfo(response).build();
    }

    private Optional<ConsensusTopicInfo> infoForTopic(@NonNull TopicID topicID, @NonNull ReadableTopicStore topicStore, @NonNull LedgerConfig config) {
        Topic meta = topicStore.getTopic(topicID);
        if (meta == null) {
            return Optional.empty();
        }
        ConsensusTopicInfo.Builder info = ConsensusTopicInfo.newBuilder();
        info.memo(meta.memo());
        info.runningHash(meta.runningHash());
        info.sequenceNumber(meta.sequenceNumber());
        info.expirationTime(Timestamp.newBuilder().seconds(meta.expirationSecond()).build());
        if (!KeyUtils.isEmpty((com.hedera.hapi.node.base.Key)meta.adminKey())) {
            info.adminKey(meta.adminKey());
        }
        if (!KeyUtils.isEmpty((com.hedera.hapi.node.base.Key)meta.submitKey())) {
            info.submitKey(meta.submitKey());
        }
        info.autoRenewPeriod(Duration.newBuilder().seconds(meta.autoRenewPeriod()));
        if (meta.hasAutoRenewAccountId()) {
            info.autoRenewAccount(meta.autoRenewAccountId());
        }
        if (meta.hasFeeScheduleKey()) {
            info.feeScheduleKey(meta.feeScheduleKey());
        }
        if (!meta.feeExemptKeyList().isEmpty()) {
            info.feeExemptKeyList(meta.feeExemptKeyList());
        }
        if (!meta.customFees().isEmpty()) {
            info.customFees(meta.customFees());
        }
        info.ledgerId(config.id());
        return Optional.of(info.build());
    }

    @NonNull
    public Fees computeFees(@NonNull QueryContext queryContext) {
        Query query = queryContext.query();
        ReadableTopicStore topicStore = (ReadableTopicStore)queryContext.createStore(ReadableTopicStore.class);
        ConsensusGetTopicInfoQuery op = query.consensusGetTopicInfoOrThrow();
        TopicID topicId = op.topicIDOrElse(TopicID.DEFAULT);
        ResponseType responseType = op.headerOrElse(QueryHeader.DEFAULT).responseType();
        Topic topic = topicStore.getTopic(topicId);
        return queryContext.feeCalculator().legacyCalculate(ignored -> this.usageGivenTypeAndTopic(topic, responseType));
    }

    private FeeData usageGivenTypeAndTopic(@Nullable Topic topic, @NonNull ResponseType responseType) {
        Objects.requireNonNull(responseType);
        if (topic == null) {
            return Fees.CONSTANT_FEE_DATA;
        }
        long bpr = 16L + (long)FeeBuilder.getStateProofSize((com.hederahashgraph.api.proto.java.ResponseType)CommonPbjConverters.fromPbjResponseType((ResponseType)responseType)) + 24L + (long)ConsensusGetTopicInfoHandler.getTopicInfoSize(topic);
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(236L).setVpt(0L).setRbh(0L).setSbh(0L).setGas(0L).setTv(0L).setBpr(bpr).setSbpr(0L).build();
        return FeeBuilder.getQueryFeeDataMatrices((FeeComponents)feeMatrices);
    }

    private static int getTopicInfoSize(@NonNull Topic topic) {
        return 72 + ConsensusServiceFeeBuilder.computeVariableSizedFieldsUsage((Key)CommonPbjConverters.fromPbj((com.hedera.hapi.node.base.Key)topic.adminKeyOrElse(com.hedera.hapi.node.base.Key.DEFAULT)), (Key)CommonPbjConverters.fromPbj((com.hedera.hapi.node.base.Key)topic.submitKeyOrElse(com.hedera.hapi.node.base.Key.DEFAULT)), (String)topic.memo(), (boolean)topic.hasAutoRenewAccountId());
    }
}

