/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class IncrementalStreamingHasher {
    private static final byte[] LEAF_PREFIX = new byte[]{0};
    private static final byte[] INTERNAL_NODE_PREFIX = new byte[]{2};
    private final MessageDigest digest;
    private final LinkedList<byte[]> hashList = new LinkedList();
    private long leafCount;

    public IncrementalStreamingHasher(MessageDigest digest, List<byte[]> intermediateHashingState, long leafCount) {
        if (digest == null) {
            throw new IllegalArgumentException("digest must not be null");
        }
        this.digest = digest;
        this.hashList.addAll(intermediateHashingState);
        this.leafCount = leafCount;
    }

    public void addLeaf(byte[] data) {
        long i = this.leafCount;
        byte[] e = this.hashLeaf(data);
        this.hashList.add(e);
        long n = i;
        while ((n & 1L) == 1L) {
            byte[] y = this.hashList.removeLast();
            byte[] x = this.hashList.removeLast();
            this.hashList.add(this.hashInternalNode(x, y));
            n >>= 1;
        }
        ++this.leafCount;
    }

    public byte[] computeRootHash() {
        if (this.hashList.isEmpty()) {
            return Bytes.EMPTY.toByteArray();
        }
        if (this.hashList.size() == 1) {
            return this.hashList.getFirst();
        }
        byte[] merkleRootHash = this.hashList.getLast();
        for (int i = this.hashList.size() - 2; i >= 0; --i) {
            merkleRootHash = this.hashInternalNode(this.hashList.get(i), merkleRootHash);
        }
        return merkleRootHash;
    }

    public List<Bytes> intermediateHashingState() {
        return this.hashList.stream().map(b -> Bytes.wrap((byte[])Arrays.copyOf(b, ((byte[])b).length))).toList();
    }

    public long leafCount() {
        return this.leafCount;
    }

    private byte[] hashLeaf(byte[] leafData) {
        this.digest.reset();
        this.digest.update(LEAF_PREFIX);
        return this.digest.digest(leafData);
    }

    private byte[] hashInternalNode(byte[] firstChild, byte[] secondChild) {
        this.digest.reset();
        this.digest.update(INTERNAL_NODE_PREFIX);
        this.digest.update(firstChild);
        return this.digest.digest(secondChild);
    }
}

