/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.signature;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.base.SignaturePair;
import com.hedera.node.app.signature.DefaultKeyVerifier;
import com.hedera.node.app.signature.ExpandedSignaturePair;
import com.hedera.node.app.signature.SignatureExpander;
import com.hedera.node.app.signature.SignatureVerificationFuture;
import com.hedera.node.app.signature.SignatureVerifier;
import com.hedera.node.app.spi.signatures.SignatureVerifier;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AppSignatureVerifier
implements com.hedera.node.app.spi.signatures.SignatureVerifier {
    private static final int EDDSA_COUNT_INDEX = 0;
    private static final int ECDSA_COUNT_INDEX = 1;
    private final HederaConfig hederaConfig;
    private final SignatureExpander signatureExpander;
    private final SignatureVerifier signatureVerifier;

    @Inject
    public AppSignatureVerifier(@NonNull HederaConfig hederaConfig, @NonNull SignatureExpander signatureExpander, @NonNull SignatureVerifier signatureVerifier) {
        this.hederaConfig = Objects.requireNonNull(hederaConfig);
        this.signatureExpander = Objects.requireNonNull(signatureExpander);
        this.signatureVerifier = Objects.requireNonNull(signatureVerifier);
    }

    public boolean verifySignature(@NonNull Key key, @NonNull Bytes bytes, @NonNull SignatureVerifier.MessageType messageType, @NonNull SignatureMap signatureMap, @Nullable Function<Key, SignatureVerifier.SimpleKeyStatus> simpleKeyVerifier) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(bytes);
        Objects.requireNonNull(messageType);
        Objects.requireNonNull(signatureMap);
        if (messageType == SignatureVerifier.MessageType.KECCAK_256_HASH && bytes.length() != 32L) {
            throw new IllegalArgumentException("Message type " + String.valueOf(SignatureVerifier.MessageType.KECCAK_256_HASH) + " must be 32 bytes long, got '" + bytes.toHex() + "'");
        }
        HashSet<ExpandedSignaturePair> sigPairs = new HashSet<ExpandedSignaturePair>();
        this.signatureExpander.expand(key, (List<SignaturePair>)signatureMap.sigPair(), sigPairs);
        Map<Key, SignatureVerificationFuture> results = this.signatureVerifier.verify(bytes, sigPairs, messageType);
        DefaultKeyVerifier verifier = new DefaultKeyVerifier(this.hederaConfig, results);
        return simpleKeyVerifier == null ? verifier.verificationFor(key).passed() : verifier.verificationFor(key, (k, v) -> switch ((SignatureVerifier.SimpleKeyStatus)simpleKeyVerifier.apply((Key)k)) {
            default -> throw new MatchException(null, null);
            case SignatureVerifier.SimpleKeyStatus.VALID -> true;
            case SignatureVerifier.SimpleKeyStatus.INVALID -> false;
            case SignatureVerifier.SimpleKeyStatus.ONLY_IF_CRYPTO_SIG_VALID -> v.passed();
        }).passed();
    }

    public SignatureVerifier.KeyCounts countSimpleKeys(@NonNull Key key) {
        int[] counts = new int[2];
        this.countSimpleKeys(key, counts);
        return new SignatureVerifier.KeyCounts(counts[0], counts[1]);
    }

    private void countSimpleKeys(@NonNull Key key, @NonNull int[] counts) {
        switch ((Key.KeyOneOfType)key.key().kind()) {
            case ED25519: {
                counts[0] = counts[0] + 1;
                break;
            }
            case ECDSA_SECP256K1: {
                counts[1] = counts[1] + 1;
                break;
            }
            case KEY_LIST: {
                key.keyListOrThrow().keys().forEach(k -> this.countSimpleKeys((Key)k, counts));
                break;
            }
            case THRESHOLD_KEY: {
                key.thresholdKeyOrThrow().keysOrThrow().keys().forEach(k -> this.countSimpleKeys((Key)k, counts));
                break;
            }
        }
    }
}

