/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import io.vertx.core.buffer.Buffer;
import org.apache.tuweni.bytes.BufferWrappingBytes;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Checks;
import org.apache.tuweni.bytes.MutableBytes;

final class MutableBufferWrappingBytes
extends BufferWrappingBytes
implements MutableBytes {
    MutableBufferWrappingBytes(Buffer buffer) {
        super(buffer);
    }

    MutableBufferWrappingBytes(Buffer buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    @Override
    public void set(int i, byte b) {
        this.buffer.setByte(i, b);
    }

    @Override
    public void set(int i, Bytes b) {
        byte[] bytes = b.toArrayUnsafe();
        this.buffer.setBytes(i, bytes);
    }

    @Override
    public void setInt(int i, int value) {
        this.buffer.setInt(i, value);
    }

    @Override
    public void setLong(int i, long value) {
        this.buffer.setLong(i, value);
    }

    @Override
    public MutableBytes mutableSlice(int i, int length) {
        int size = this.size();
        if (i == 0 && length == size) {
            return this;
        }
        if (length == 0) {
            return MutableBytes.EMPTY;
        }
        Checks.checkElementIndex(i, size);
        Checks.checkArgument(i + length <= size, "Provided length %s is too big: the value has size %s and has only %s bytes from %s", length, size, size - i, i);
        return new MutableBufferWrappingBytes(this.buffer.slice(i, i + length));
    }

    @Override
    public Bytes copy() {
        return Bytes.wrap(this.toArray());
    }

    @Override
    public MutableBytes mutableCopy() {
        return MutableBytes.wrap(this.toArray());
    }

    @Override
    public int hashCode() {
        return this.computeHashcode();
    }
}

