/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;

public interface Operation {
    public OperationResult execute(MessageFrame var1, EVM var2);

    public int getOpcode();

    public String getName();

    public int getStackItemsConsumed();

    public int getStackItemsProduced();

    default public boolean isVirtualOperation() {
        return false;
    }

    public static class OperationResult {
        final long gasCost;
        final ExceptionalHaltReason haltReason;
        final int pcIncrement;

        public OperationResult(long gasCost, ExceptionalHaltReason haltReason) {
            this(gasCost, haltReason, 1);
        }

        public OperationResult(long gasCost, ExceptionalHaltReason haltReason, int pcIncrement) {
            this.gasCost = gasCost;
            this.haltReason = haltReason;
            this.pcIncrement = pcIncrement;
        }

        public long getGasCost() {
            return this.gasCost;
        }

        public ExceptionalHaltReason getHaltReason() {
            return this.haltReason;
        }

        public int getPcIncrement() {
            return this.pcIncrement;
        }
    }
}

