/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.consensus.impl.handlers;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.consensus.ConsensusDeleteTopicTransactionBody;
import com.hedera.hapi.node.state.consensus.Topic;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.ConsensusServiceFeeBuilder;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hedera.node.app.service.consensus.ReadableTopicStore;
import com.hedera.node.app.service.consensus.impl.WritableTopicStore;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hederahashgraph.api.proto.java.FeeData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hiero.hapi.fees.FeeModel;
import org.hiero.hapi.fees.FeeModelRegistry;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.support.fees.Extra;

@Singleton
public class ConsensusDeleteTopicHandler
implements TransactionHandler {
    @Inject
    public ConsensusDeleteTopicHandler() {
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        ConsensusDeleteTopicTransactionBody op = txn.consensusDeleteTopicOrThrow();
        PreCheckException.validateTruePreCheck((boolean)op.hasTopicID(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOPIC_ID);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        ConsensusDeleteTopicTransactionBody op = context.body().consensusDeleteTopicOrThrow();
        ReadableTopicStore topicStore = (ReadableTopicStore)context.createStore(ReadableTopicStore.class);
        Validations.mustExist((Object)op.topicID(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOPIC_ID);
        Topic topic = topicStore.getTopic(op.topicIDOrThrow());
        Validations.mustExist((Object)topic, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOPIC_ID);
        context.requireKeyOrThrow(topic.adminKey(), ResponseCodeEnum.UNAUTHORIZED);
    }

    public void handle(@NonNull HandleContext context) {
        Objects.requireNonNull(context, "The argument 'context' must not be null");
        ConsensusDeleteTopicTransactionBody op = context.body().consensusDeleteTopicOrThrow();
        WritableTopicStore topicStore = (WritableTopicStore)context.storeFactory().writableStore(WritableTopicStore.class);
        TopicID topicId = op.topicIDOrElse(TopicID.DEFAULT);
        Topic topic = topicStore.getTopic(topicId);
        if (topic.adminKey() == null) {
            throw new HandleException(ResponseCodeEnum.UNAUTHORIZED);
        }
        Topic.Builder topicBuilder = new Topic.Builder().topicId(topic.topicId()).adminKey(topic.adminKey()).submitKey(topic.submitKey()).autoRenewAccountId(topic.autoRenewAccountId()).autoRenewPeriod(topic.autoRenewPeriod()).expirationSecond(topic.expirationSecond()).memo(topic.memo()).runningHash(topic.runningHash()).sequenceNumber(topic.sequenceNumber());
        topicBuilder.deleted(true);
        topicStore.put(topicBuilder.build());
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        TransactionBody op = feeContext.body();
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).legacyCalculate(sigValueObj -> this.usageGiven(CommonPbjConverters.fromPbj((TransactionBody)op), (SigValueObj)sigValueObj));
    }

    @NonNull
    public FeeResult calculateFeeResult(@NonNull FeeContext feeContext) {
        FeeModel entity = FeeModelRegistry.lookupModel((HederaFunctionality)HederaFunctionality.CONSENSUS_DELETE_TOPIC);
        HashMap<Extra, Long> params = new HashMap<Extra, Long>();
        params.put(Extra.SIGNATURES, Long.valueOf(feeContext.numTxnSignatures()));
        return entity.computeFee(params, feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).getSimpleFeesSchedule());
    }

    private FeeData usageGiven(com.hederahashgraph.api.proto.java.TransactionBody txn, SigValueObj sigUsage) {
        return ConsensusServiceFeeBuilder.getConsensusDeleteTopicFee((com.hederahashgraph.api.proto.java.TransactionBody)txn, (SigValueObj)sigUsage);
    }
}

