/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.stack;

import com.hedera.node.app.workflows.handle.stack.WritableStatesStack;
import com.swirlds.state.spi.WritableSingletonState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class WritableSingletonStateStack<T>
implements WritableSingletonState<T> {
    private final WritableStatesStack writableStatesStack;
    private final int stateId;

    public WritableSingletonStateStack(@NonNull WritableStatesStack writableStatesStack, int stateId) {
        this.writableStatesStack = Objects.requireNonNull(writableStatesStack, "writableStatesStack must not be null");
        this.stateId = stateId;
    }

    @NonNull
    private WritableSingletonState<T> getCurrent() {
        return this.writableStatesStack.getCurrent().getSingleton(this.stateId);
    }

    public int getStateId() {
        return this.stateId;
    }

    @Nullable
    public T get() {
        return (T)this.getCurrent().get();
    }

    public boolean isRead() {
        return this.getCurrent().isRead();
    }

    public void put(@Nullable T value) {
        this.getCurrent().put(value);
    }

    public boolean isModified() {
        return this.getCurrent().isModified();
    }
}

